/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.runtime;

import com.ibm.cics.cm.model.DataSource;
import com.ibm.cics.cm.model.ReportItem;
import com.ibm.cics.cm.model.ReportSet;
import com.ibm.cics.cm.model.runtime.MessageResponse;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DeployMessageResponse
extends MessageResponse {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String startObjectTag = "REPORT";
    private HashMap<Integer, DataSource> dataSources = new HashMap();
    private HashMap<Integer, ReportSet> reportSets = new HashMap();
    private HashMap<Integer, ReportItem> reportItems = new HashMap();
    private boolean inObject = false;
    private boolean inDataSourceElement = false;
    private boolean inReportSetElement = false;
    private boolean inReportLineElement = false;
    private boolean inTargetRegionElement = false;
    private boolean inCCMRegionElement = false;
    private boolean inReportVerifyElement = false;
    private boolean inReportVerElementElement = false;
    private boolean inReportDifferencesElement = false;
    private boolean inReportDiffElementElement = false;
    private int elementCount = 0;
    private int reportItemCount = 1;
    private DataSource currentDataSource = null;
    private ReportSet currentReportSet = null;
    private ReportItem currentReportItem = null;

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, name, attributes);
        if (this.status == 1) {
            if (startObjectTag.equalsIgnoreCase(name)) {
                this.inObject = true;
            } else if (DataSource.Tags.DATA_SOURCE_ELEMENT.toString().equals(name)) {
                this.inDataSourceElement = true;
                this.currentDataSource = new DataSource();
            } else if (ReportSet.Tags.REPORT_SET_ELEMENT.toString().equals(name)) {
                this.inReportSetElement = true;
                this.currentReportSet = new ReportSet();
            } else if (ReportItem.Tags.REPORT_LINE_ELEMENT.toString().equals(name)) {
                this.inReportLineElement = true;
                this.currentReportItem = new ReportItem();
            } else if (this.inDataSourceElement && DataSource.Tags.TARGET_REGION.toString().equals(name)) {
                this.inTargetRegionElement = true;
            } else if (this.inDataSourceElement && DataSource.Tags.CCM_REGION.toString().equals(name)) {
                this.inCCMRegionElement = true;
            } else if (this.inReportLineElement && ReportItem.Tags.REPORTVERIFY.toString().equals(name)) {
                this.inReportVerifyElement = true;
            } else if (this.inReportVerifyElement && ReportItem.Tags.REPORTVERELEMENT.toString().equals(name)) {
                this.inReportVerElementElement = true;
            } else if (this.inReportLineElement && ReportItem.Tags.REPORTDIFFERENCES.toString().equals(name)) {
                this.inReportDifferencesElement = true;
            } else if (this.inReportDifferencesElement && ReportItem.Tags.REPORTDIFFELEMENT.toString().equals(name)) {
                this.inReportDiffElementElement = true;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
        if (this.status == 1) {
            if (startObjectTag.equalsIgnoreCase(name)) {
                this.inObject = false;
            } else if (this.inObject) {
                if (DataSource.Tags.DATA_SOURCE_ELEMENT.toString().equals(name)) {
                    this.inDataSourceElement = false;
                    if (this.currentDataSource != null && this.currentDataSource.getId() != -1) {
                        this.dataSources.put(this.currentDataSource.getId(), this.currentDataSource);
                    }
                    this.currentDataSource = null;
                } else if (ReportSet.Tags.REPORT_SET_ELEMENT.toString().equals(name)) {
                    this.inReportSetElement = false;
                    if (this.currentReportSet != null && this.currentReportSet.getId() != -1) {
                        this.reportSets.put(this.currentReportSet.getId(), this.currentReportSet);
                    }
                    this.currentReportSet = null;
                } else if (ReportItem.Tags.REPORT_LINE_ELEMENT.toString().equals(name)) {
                    this.inReportLineElement = false;
                    if (this.currentReportItem != null && this.currentReportItem.getId() != -1) {
                        this.reportItems.put(this.reportItemCount++, this.currentReportItem);
                    }
                    this.currentReportItem = null;
                } else if (this.inDataSourceElement) {
                    if (DataSource.Tags.TARGET_REGION.toString().equals(name)) {
                        this.inTargetRegionElement = false;
                    } else if (DataSource.Tags.CCM_REGION.toString().equals(name)) {
                        this.inCCMRegionElement = false;
                    } else if (this.inTargetRegionElement) {
                        this.currentDataSource.getTargetRegion().addAttribute(name, this.getCurrentTagValue());
                    } else if (this.inCCMRegionElement) {
                        this.currentDataSource.getCCMRegion().addAttribute(name, this.getCurrentTagValue());
                    } else {
                        this.currentDataSource.addAttribute(name, this.getCurrentTagValue());
                    }
                } else if (this.inReportSetElement) {
                    this.currentReportSet.addAttribute(name, this.getCurrentTagValue());
                } else if (this.inReportLineElement) {
                    if (ReportItem.Tags.REPORTVERIFY.toString().equals(name)) {
                        this.inReportVerifyElement = false;
                        this.elementCount = 0;
                    } else if (ReportItem.Tags.REPORTDIFFERENCES.toString().equals(name)) {
                        this.inReportDifferencesElement = false;
                        this.elementCount = 0;
                    } else if (this.inReportVerifyElement) {
                        if (ReportItem.Tags.REPORTVERELEMENT.toString().equals(name)) {
                            this.inReportVerElementElement = false;
                            ++this.elementCount;
                        } else if (this.inReportVerElementElement) {
                            this.currentReportItem.getReportVerify().addAttribute(String.valueOf(name) + this.elementCount, this.getCurrentTagValue());
                        } else {
                            this.currentReportItem.getReportVerify().addAttribute(name, this.getCurrentTagValue());
                        }
                    } else if (this.inReportDifferencesElement) {
                        if (ReportItem.Tags.REPORTDIFFELEMENT.toString().equals(name)) {
                            this.inReportDiffElementElement = false;
                            ++this.elementCount;
                        } else if (this.inReportDiffElementElement) {
                            this.currentReportItem.getReportDifferences().addAttribute(String.valueOf(name) + this.elementCount, this.getCurrentTagValue());
                        } else {
                            this.currentReportItem.getReportDifferences().addAttribute(name, this.getCurrentTagValue());
                        }
                    } else {
                        this.currentReportItem.addAttribute(name, this.getCurrentTagValue());
                    }
                }
            }
        }
    }

    public HashMap<Integer, DataSource> getDataSources() {
        return this.dataSources;
    }

    public HashMap<Integer, ReportSet> getReportSets() {
        return this.reportSets;
    }

    public HashMap<Integer, ReportItem> getReportItems() {
        return this.reportItems;
    }

    public String getXMLMessage() {
        return this.rawMessageBuffer.toString();
    }
}

