/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.runtime;

import com.ibm.cics.cm.model.runtime.Node;

public class ContainerData
extends Node {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    @Override
    public String getName() {
        return "INPUTDATA";
    }

    public static ContainerData newContainerDataForConfiguration(String configurationName) {
        ContainerData containerData = new ContainerData();
        containerData.setAttribute("CONTAINERNAME", configurationName.toUpperCase());
        containerData.setAttribute("CONTAINERTYPE", "CCONFIG");
        return containerData;
    }

    public static ContainerData newContainerDataForChangePackage(String packageID) {
        ContainerData containerData = new ContainerData();
        containerData.setAttribute("CONTAINERNAME", packageID.toUpperCase());
        containerData.setAttribute("CONTAINERTYPE", "CHGPKG");
        return containerData;
    }

    public static ContainerData newContainerDataForResourceGroup(String groupName) {
        ContainerData containerData = new ContainerData();
        containerData.setAttribute("CONTAINERNAME", groupName);
        containerData.setAttribute("CONTAINERTYPE", "RESGROUP");
        return containerData;
    }

    public static ContainerData newContainerDataForResourceList(String listName) {
        ContainerData containerData = new ContainerData();
        containerData.setAttribute("CONTAINERNAME", listName);
        containerData.setAttribute("CONTAINERTYPE", "RESDESC");
        return containerData;
    }

    private void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }
}

