/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.runtime;

import com.ibm.cics.cm.model.runtime.MessageResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ConnectionDataMessageResponse
extends MessageResponse {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<Map<String, String>> connectionObjects = new ArrayList<Map<String, String>>();
    protected String startListTag = "LISTELEMENT";
    protected String startObjectTag = "OBJECTDATA";
    private String startConnectionElement = "CONNECTIONELEMENT";
    private String serverJobName = "SVRJOBNAME";
    private String connectionCount = "CONNECTIONCOUNT";
    protected List<Map<String, String>> objects = new ArrayList<Map<String, String>>();
    protected Map<String, String> currentObject;

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, name, attributes);
        if (this.status == 1) {
            if (this.startListTag.equals(name)) {
                this.currentObject = new HashMap<String, String>();
            } else if (this.startObjectTag.equals(name)) {
                this.currentObject = new HashMap<String, String>();
            } else if (this.startConnectionElement.equals(name)) {
                this.currentObject = new HashMap<String, String>();
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
        if (this.status == 1 && this.currentObject != null) {
            if (this.startObjectTag.equalsIgnoreCase(name) || this.connectionCount.equalsIgnoreCase(name)) {
                this.objects.add(this.currentObject);
                this.currentObject = null;
            } else if (this.startConnectionElement.equalsIgnoreCase(name)) {
                this.connectionObjects.add(this.currentObject);
                this.currentObject = null;
            } else if (this.startListTag.equals(name)) {
                this.currentObject = new HashMap<String, String>();
            } else if (this.currentObject != null) {
                this.currentObject.put(name, this.getCurrentTagValue());
            }
        }
    }

    public List<Map<String, String>> getConnectionObjects() {
        return this.connectionObjects;
    }

    public List<Map<String, String>> getObjects() {
        return this.objects;
    }
}

