/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.runtime;

import com.ibm.cics.cm.comm.CMResponse;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.runtime.ActionMessageResponse;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.model.runtime.ChangePackageObjectCriteria;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.ConnectionDataMessageResponse;
import com.ibm.cics.cm.model.runtime.ContainerData;
import com.ibm.cics.cm.model.runtime.CreateAliasMessageResponse;
import com.ibm.cics.cm.model.runtime.CreateChangePackageMessageResponse;
import com.ibm.cics.cm.model.runtime.Debug;
import com.ibm.cics.cm.model.runtime.DeleteMessageResponse;
import com.ibm.cics.cm.model.runtime.DeployMessageResponse;
import com.ibm.cics.cm.model.runtime.InquireMessageResponse;
import com.ibm.cics.cm.model.runtime.JournalCriteria;
import com.ibm.cics.cm.model.runtime.ListMessageResponse;
import com.ibm.cics.cm.model.runtime.LocationCriteria;
import com.ibm.cics.cm.model.runtime.MessageFactory;
import com.ibm.cics.cm.model.runtime.MessageResponse;
import com.ibm.cics.cm.model.runtime.Messages;
import com.ibm.cics.cm.model.runtime.ObjectCriteria;
import com.ibm.cics.cm.model.runtime.ObjectCriteriaList;
import com.ibm.cics.cm.model.runtime.ObjectData;
import com.ibm.cics.cm.model.runtime.ProcessParms;
import com.ibm.cics.cm.model.runtime.RestrictionCriteriaList;
import com.ibm.cics.cm.model.runtime.SelectionCriteria;
import com.ibm.cics.cm.model.runtime.ServerApiMessageResponse;
import com.ibm.cics.cm.model.runtime.TargetCriteria;
import com.ibm.cics.cm.model.runtime.TargetLocationCriteria;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.ExplorerHostnameVerifier;
import com.ibm.cics.core.comm.ExplorerSecurityHelper;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.sm.comm.SMUpdateException;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.Permission;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.codec.binary.Base64;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CMConnection
implements Constants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2023 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private SSLSocketFactory sslSocketFactory;
    public static final String CCV120_1 = "CCV120.1";
    public static final String CCV210 = "CCV210";
    public static final String CCV510 = "CCV510";
    public static final String CCV520 = "CCV520";
    public static final String CCV530 = "CCV530";
    public static final String CCV540 = "CCV540";
    private String password;
    private String hostName;
    private int port;
    private String userID;
    private static Logger logger = Logger.getLogger("com.ibm.cics.cm.model");
    public static boolean logIncomingSOAPmessages = Boolean.getBoolean("CMExplorer.logIncomingSOAPmessages");
    public static boolean logOutgoingSOAPmessages = Boolean.getBoolean("CMExplorer.logOutgoingSOAPmessages");
    public static boolean logBadResponses = Boolean.getBoolean("CMExplorer.logBadResponses");
    public Map<ObjectKey, String> integrityTokens = new HashMap<ObjectKey, String>();
    private String cicsRelease;
    private int release;
    private String cicsVersion;
    private String cmServerApplID;
    private String cmSystemID;
    private boolean isConnected;
    private int cmRelease;
    private List<Listener> connectionObjectListeners = new ArrayList<Listener>();
    private List<Map<String, String>> connectionObjects;
    public static String apiLevel = "CCV120.1";
    private SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private SAXParser parser;
    private String credentialsId;
    private boolean ssl;
    private String name;

    public void setConfiguration(ConnectionConfiguration configuration) {
        this.hostName = configuration.getHost();
        this.port = configuration.getPort();
        this.ssl = configuration.getSecureHint();
        this.name = configuration.getName();
        this.credentialsId = configuration.getCredentialsID();
        CredentialsConfiguration creds = ConnectionsPlugin.getDefault().getConnectionService().getConnectionManager().getCredentialsManager().findCredentialsConfigurationByID(this.credentialsId);
        if (creds != null) {
            this.userID = creds.getUserID();
            this.password = creds.getPassword();
        }
    }

    public void setUrbanCodeOnlyConnection(ConnectionConfiguration configuration) {
        this.hostName = configuration.getHost();
        this.port = configuration.getPort();
        this.userID = configuration.getUserID();
        this.password = configuration.getPassword();
        this.ssl = configuration.getSecureHint();
    }

    public InquireMessageResponse create(LocationCriteria aLocationCriteria, ObjectCriteria anObjectCriteria, ObjectData anObjectData) throws SystemManagerConnectionException, CMServerException {
        String message = MessageFactory.getObjectCreateMessage(aLocationCriteria, anObjectCriteria, anObjectData);
        InputStreamReader messageReturnStream = this.sendMessage(message);
        MessageResponse response = new MessageResponse();
        this.processMessageResponse(message, messageReturnStream, response);
        return this.inquire(aLocationCriteria, anObjectCriteria);
    }

    public InquireMessageResponse createChangePackage(LocationCriteria aLocationCriteria, ChangePackageObjectCriteria anObjectCriteria, ObjectData anObjectData) throws SystemManagerConnectionException, CMServerException {
        String message = MessageFactory.getObjectCreateMessage(aLocationCriteria, anObjectCriteria, anObjectData);
        InputStreamReader messageReturnStream = this.sendMessage(message);
        CreateChangePackageMessageResponse response = new CreateChangePackageMessageResponse();
        this.processMessageResponse(message, messageReturnStream, response);
        anObjectCriteria.setObjectName(response.getCPID());
        return this.inquire(aLocationCriteria, anObjectCriteria);
    }

    public InquireMessageResponse createAppldef(LocationCriteria aLocationCriteria, ObjectCriteria anObjectCriteria, ObjectData anObjectData) throws SystemManagerConnectionException, CMServerException {
        String message = MessageFactory.getObjectCreateMessage(aLocationCriteria, anObjectCriteria, anObjectData);
        InputStreamReader messageReturnStream = this.sendMessage(message);
        CreateAliasMessageResponse response = new CreateAliasMessageResponse();
        this.processMessageResponse(message, messageReturnStream, response);
        anObjectCriteria.setObjectName(response.getAlias());
        return this.inquire(aLocationCriteria, anObjectCriteria);
    }

    public CMResponse delete(String configurationName, String groupName, String resourceType, String resourceName) {
        try {
            String message = MessageFactory.getDeleteMessage(configurationName, groupName, resourceType, resourceName);
            InputStreamReader messageReturnStream = this.sendMessage(message);
            DeleteMessageResponse response = new DeleteMessageResponse();
            this.processMessageResponse(message, messageReturnStream, response);
        }
        catch (Exception e) {
            com.ibm.cics.common.util.Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"delete", (Throwable)e);
            com.ibm.cics.common.util.Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"delete", (Object[])new Object[]{e});
        }
        return null;
    }

    private void deploy(String xmlMessage, DeployMessageResponse messageResponse) throws CMServerException {
        String message = xmlMessage;
        InputStreamReader messageReturnStream = this.sendMessage(message);
        this.processMessageResponse(message, messageReturnStream, messageResponse);
        String integrityToken = messageResponse.integrityToken;
    }

    public DeployMessageResponse deploy(String xmlMessage) {
        DeployMessageResponse messageResponse = new DeployMessageResponse();
        try {
            this.deploy(xmlMessage, messageResponse);
        }
        catch (CMServerException cMServerException) {
            // empty catch block
        }
        return messageResponse;
    }

    private void processMessageResponse(String message, InputStreamReader inputStream, MessageResponse response) throws CMServerException {
        this.processMessageResponse(message, inputStream, response, logBadResponses);
    }

    private synchronized void processMessageResponse(String message, InputStreamReader inputStream, MessageResponse response, boolean logBadReturnResponses) throws CMServerException {
        com.ibm.cics.common.util.Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"processMessageResponse");
        try {
            if (this.parser == null) {
                this.parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                this.parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                this.parser = this.parserFactory.newSAXParser();
            }
            this.parser.parse(new InputSource(inputStream), (DefaultHandler)response);
            this.parser.reset();
            if (logIncomingSOAPmessages) {
                Debug.soapMessageReceived(logger, CMConnection.class.getName(), "processMessageResponse", response.rawMessageBuffer);
            }
            switch (response.returnCode) {
                case 0: {
                    break;
                }
                case 4: {
                    if (logBadReturnResponses) {
                        com.ibm.cics.common.util.Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"processMessageResponse", (Object[])new Object[]{message, response.rawMessageBuffer});
                    }
                    break;
                }
                default: {
                    if (!response.reasonCode.endsWith("0000")) {
                        if (logBadReturnResponses) {
                            com.ibm.cics.common.util.Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"processMessageResponse", (Object[])new Object[]{message, response.rawMessageBuffer});
                        }
                        throw new CMServerException(response);
                    }
                }
            }
        }
        catch (SAXException e) {
            com.ibm.cics.common.util.Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"processMessageResponse", (Throwable)e);
            com.ibm.cics.common.util.Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"processMessageResponse", (Object[])new Object[]{e, response, response.rawMessageBuffer});
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            com.ibm.cics.common.util.Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"processMessageResponse", (Throwable)e);
            com.ibm.cics.common.util.Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"processMessageResponse", (Object[])new Object[]{e, response, response.rawMessageBuffer});
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            com.ibm.cics.common.util.Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"processMessageResponse", (Throwable)e);
            com.ibm.cics.common.util.Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"processMessageResponse", (Object[])new Object[]{e, response, response.rawMessageBuffer});
            throw new RuntimeException(e);
        }
        com.ibm.cics.common.util.Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"processMessageResponse");
    }

    private HttpURLConnection getConnection() throws Exception {
        String endpoint = String.valueOf(this.ssl ? "https" : "http") + "://{0}:{1}/CICS/CWBA/CCVWSDSH/CCVADISP";
        String urlString = MessageFormat.format(endpoint, this.hostName, Integer.toString(this.port));
        URL url = new URL(urlString);
        HttpURLConnection httpConn = this.openConnection(url);
        return httpConn;
    }

    public InputStreamReader sendMessage(String message) {
        com.ibm.cics.common.util.Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"sendMessage");
        try {
            if (logOutgoingSOAPmessages) {
                Debug.aboutToSendSOAPMessage(logger, CMConnection.class.getName(), "sendMessage", message);
            }
            HttpURLConnection connection = this.getConnection();
            String authentication = String.valueOf(this.userID) + ":" + this.password;
            byte[] authenticationArray = authentication.getBytes("UTF-8");
            connection.setRequestProperty("Content-Length", String.valueOf(message.length()));
            connection.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
            connection.setRequestProperty("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])authenticationArray), "UTF-8"));
            Permission permission = connection.getPermission();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            OutputStream out = connection.getOutputStream();
            out.write(message.getBytes("UTF-8"));
            out.close();
            com.ibm.cics.common.util.Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)Messages.getString("CMConnection.0"));
            InputStream responseStream = connection.getInputStream();
            InputStreamReader responseReader = null;
            String contentType = connection.getHeaderField("Content-Type");
            if (contentType.matches(".*charset=\".*\".*")) {
                int charsetPos = contentType.indexOf("charset=\"") + 9;
                String charset = contentType.substring(charsetPos, contentType.indexOf("\"", charsetPos));
                try {
                    responseReader = new InputStreamReader(responseStream, charset);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            if (responseReader == null) {
                responseReader = new InputStreamReader(responseStream, "iso-8859-1");
            }
            return responseReader;
        }
        catch (Exception e) {
            com.ibm.cics.common.util.Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"sendMessage", (Throwable)e);
            com.ibm.cics.common.util.Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"sendMessage", (Object[])new Object[]{message});
            throw new RuntimeException(e);
        }
    }

    public void inquire(LocationCriteria aLocationCriteria, ObjectCriteria anObjectCriteria, MessageResponse aMessageResponse) throws CMServerException {
        com.ibm.cics.common.util.Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"inquire");
        String message = MessageFactory.inquire(aLocationCriteria, anObjectCriteria);
        InputStreamReader messageReturnStream = this.sendMessage(message);
        this.processMessageResponse(message, messageReturnStream, aMessageResponse);
        String integrityToken = aMessageResponse.integrityToken;
        ObjectKey objectKey = this.asObjectKey(aLocationCriteria, anObjectCriteria);
        this.integrityTokens.put(objectKey, integrityToken);
        com.ibm.cics.common.util.Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"inquire");
    }

    public InquireMessageResponse inquire(LocationCriteria aLocationCriteria, ObjectCriteria anObjectCriteria) throws CMServerException {
        com.ibm.cics.common.util.Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"inquire", (Object)aLocationCriteria, (Object)anObjectCriteria);
        InquireMessageResponse messageResponse = new InquireMessageResponse();
        this.inquire(aLocationCriteria, anObjectCriteria, messageResponse);
        com.ibm.cics.common.util.Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"inquire");
        return messageResponse;
    }

    public void deleteResource(String objectType, String objectName) {
        try {
            String message = MessageFactory.getDeleteResourceMessage(objectType, objectName);
            InputStreamReader messageReturnStream = this.sendMessage(message);
            DeleteMessageResponse response = new DeleteMessageResponse();
            this.processMessageResponse(message, messageReturnStream, response);
        }
        catch (Exception e) {
            com.ibm.cics.common.util.Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"deleteResource", (Throwable)e);
            com.ibm.cics.common.util.Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"deleteResource", (Object[])new Object[]{e});
        }
    }

    public MessageResponse alter(String type, String name, String integrityToken, Map<String, String> attributes) throws CMServerException {
        String message = MessageFactory.getObjectUpdateMessage(type, name, integrityToken, attributes);
        InputStreamReader messageReturnStream = this.sendMessage(message);
        ActionMessageResponse response = new ActionMessageResponse();
        this.processMessageResponse(message, messageReturnStream, response);
        return response;
    }

    public boolean delete(LocationCriteria locationCriteria, ObjectCriteria objectCriteria) throws CMServerException {
        String message = MessageFactory.getDeleteMessage(locationCriteria, objectCriteria);
        InputStreamReader messageReturnStream = this.sendMessage(message);
        DeleteMessageResponse response = new DeleteMessageResponse();
        this.processMessageResponse(message, messageReturnStream, response);
        if (response.hasApiMessages()) {
            for (String apiMsg : response.getApiMessages().values()) {
                ConfigurationManager.getCurrent().triggerUIMessage(apiMsg);
            }
        }
        return true;
    }

    public MessageResponse alter(LocationCriteria locationCriteria, ObjectCriteria objectCriteria, ObjectData objectData, String integrityToken) throws CMServerException {
        String message = MessageFactory.getObjectUpdateMessage(locationCriteria, objectCriteria, objectData, integrityToken);
        InputStreamReader messageReturnStream = this.sendMessage(message);
        ActionMessageResponse response = new ActionMessageResponse();
        this.processMessageResponse(message, messageReturnStream, response);
        return response;
    }

    public MessageResponse listWithProcessParms(LocationCriteria locationCriteria, ObjectCriteria objectCriteria, ProcessParms processParms, MessageResponse messageResponse) throws CMServerException {
        String message = MessageFactory.getObjectsMessage(locationCriteria, objectCriteria, processParms);
        InputStreamReader messageReturnStream = this.sendMessage(message);
        this.processMessageResponse(message, messageReturnStream, messageResponse);
        return messageResponse;
    }

    public ListMessageResponse listWithProcessParms(LocationCriteria locationCriteria, ObjectCriteria objectCriteria, ProcessParms processParms) throws CMServerException {
        ListMessageResponse messageResponse = new ListMessageResponse();
        this.listWithProcessParms(locationCriteria, objectCriteria, processParms, messageResponse);
        return messageResponse;
    }

    public ListMessageResponse listResources(LocationCriteria aLocationCriteria, ObjectCriteria objectCriteria, RestrictionCriteriaList restrictionCriteriaList) throws CMServerException {
        String message = MessageFactory.getObjectsMessage(aLocationCriteria, objectCriteria, restrictionCriteriaList);
        InputStreamReader messageReturnStream = this.sendMessage(message);
        ListMessageResponse messageResponse = new ListMessageResponse();
        this.processMessageResponse(message, messageReturnStream, messageResponse);
        return messageResponse;
    }

    public void initialiseServerAPILevel() throws CMServerException {
        ServerApiMessageResponse messageResponse;
        block2: {
            com.ibm.cics.common.util.Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"initialiseServerAPILevel");
            String message = MessageFactory.getServerAPILevelMessage();
            InputStreamReader messageReturnStream = this.sendMessage(message);
            messageResponse = new ServerApiMessageResponse();
            try {
                this.processMessageResponse(message, messageReturnStream, messageResponse, false);
            }
            catch (CMServerException e) {
                if (e.isAPIMismatch() || e.isOKWarning()) break block2;
                com.ibm.cics.common.util.Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"initialiseServerAPILevel", (Object)e);
                throw e;
            }
        }
        this.setAPILevel(messageResponse.getAPILevel());
        com.ibm.cics.common.util.Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"initialiseServerAPILevel");
    }

    public ListMessageResponse getResources(LocationCriteria locationCriteria, JournalCriteria journalCriteria, RestrictionCriteriaList restrictionCriteriaList) throws CMServerException {
        String message = MessageFactory.getObjectsMessage(locationCriteria, journalCriteria, restrictionCriteriaList);
        InputStreamReader messageReturnStream = this.sendMessage(message);
        ListMessageResponse messageResponse = new ListMessageResponse();
        this.processMessageResponse(message, messageReturnStream, messageResponse);
        return messageResponse;
    }

    public MessageResponse alter(LocationCriteria locationCriteria, ObjectCriteria objectCriteria, ObjectData objectData) throws CMServerException {
        String integrityToken = this.integrityTokens.get(this.asObjectKey(locationCriteria, objectCriteria));
        if (integrityToken == null) {
            this.inquire(locationCriteria, objectCriteria);
            integrityToken = this.integrityTokens.get(this.asObjectKey(locationCriteria, objectCriteria));
            if (integrityToken == null) {
                throw new SMUpdateException("Cannot update at this time");
            }
        }
        this.sanitiseObjectDataForAPI(locationCriteria, objectData);
        return this.alter(locationCriteria, objectCriteria, objectData, integrityToken);
    }

    public MessageResponse renameGroup(LocationCriteria locationCriteria, ObjectCriteria objectCriteria, TargetCriteria targetCriteria, ProcessParms processParms) throws CMServerException {
        String message = MessageFactory.getObjectRenameMessage(locationCriteria, objectCriteria, targetCriteria, processParms);
        InputStreamReader messageReturnStream = this.sendMessage(message);
        MessageResponse response = new MessageResponse();
        this.processMessageResponse(message, messageReturnStream, response);
        return response;
    }

    private ObjectKey asObjectKey(LocationCriteria aLocationCriteria, ObjectCriteria anObjectCriteria) {
        return new ObjectKey(aLocationCriteria.getLocationName(), anObjectCriteria.getObjectGroup(), anObjectCriteria.getObjectType(), anObjectCriteria.getObjectName());
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void connect() throws ConnectionException {
        com.ibm.cics.common.util.Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"connect");
        try {
            this.initialiseServerAPILevel();
            ConnectionDataMessageResponse listServerDetailsResponse = new ConnectionDataMessageResponse();
            listServerDetailsResponse = (ConnectionDataMessageResponse)this.listWithProcessParms(LocationCriteria.newRepositoryLocationCriteria(), ObjectCriteria.newServerCriteria(), ProcessParms.getExtendedServerInfo(true), listServerDetailsResponse);
            for (Map<String, String> serverMap : listServerDetailsResponse.getObjects()) {
                this.cicsRelease = serverMap.get("CICSREL");
                this.setRelease(Integer.parseInt(this.cicsRelease));
                this.cicsVersion = serverMap.get("CCVREL");
                this.setCMRelease(Integer.parseInt(this.cicsVersion));
                this.cmServerApplID = serverMap.get("SVRAPPLID");
                this.cmSystemID = serverMap.get("SVRSYSID");
                this.isConnected = true;
            }
            this.connectionObjects = listServerDetailsResponse.getConnectionObjects();
            this.notifyConnectionObjectListeners(this.connectionObjects);
        }
        catch (Exception e) {
            com.ibm.cics.common.util.Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"connect", (Object)e);
            this.isConnected = false;
            throw new ConnectionException(String.valueOf(this.hostName) + ":" + this.port, (Throwable)e);
        }
        if (this.parser != null) {
            this.parser.reset();
        }
        com.ibm.cics.common.util.Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"connect");
    }

    private void notifyConnectionObjectListeners(List<Map<String, String>> connectionObjects) {
        for (Listener listener : this.connectionObjectListeners) {
            listener.connectionObjectsChanged(connectionObjects);
        }
    }

    private void setAPILevel(String level) {
        if (level == null) {
            level = CCV120_1;
        }
        apiLevel = level;
    }

    public String getAPILevel() {
        return apiLevel;
    }

    public MessageResponse install(LocationCriteria locationCriteria, ObjectCriteriaList objectCriteriaList, ProcessParms processParms) throws CMServerException {
        String message = MessageFactory.getInstallMessage(locationCriteria, objectCriteriaList, processParms);
        InputStreamReader messageReturnStream = this.sendMessage(message);
        MessageResponse response = new MessageResponse();
        this.processMessageResponse(message, messageReturnStream, response);
        return response;
    }

    public MessageResponse copy(LocationCriteria locationCriteria, ObjectCriteriaList objectCriteriaList, ProcessParms processParms, TargetLocationCriteria targetLocationCriteria) throws CMServerException {
        String message = MessageFactory.getCopyMessage(locationCriteria, objectCriteriaList, processParms, targetLocationCriteria);
        InputStreamReader messageReturnStream = this.sendMessage(message);
        ActionMessageResponse response = new ActionMessageResponse();
        this.processMessageResponse(message, messageReturnStream, response);
        return response;
    }

    public boolean discard(LocationCriteria locationCriteria, ObjectCriteriaList objectCriteriaList, ProcessParms processParms) throws CMServerException {
        String message = MessageFactory.getDiscardMessage(locationCriteria, objectCriteriaList, processParms);
        InputStreamReader messageReturnStream = this.sendMessage(message);
        MessageResponse response = new MessageResponse();
        this.processMessageResponse(message, messageReturnStream, response);
        return true;
    }

    public MessageResponse add(LocationCriteria locationCriteria, ObjectCriteria objectCriteria, ContainerData containerData) throws CMServerException {
        com.ibm.cics.common.util.Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"add", (Object)locationCriteria, (Object)objectCriteria, (Object)containerData);
        String message = MessageFactory.getAddToContainerMessage(locationCriteria, objectCriteria, containerData, null);
        InputStreamReader messageReturnStream = this.sendMessage(message);
        ActionMessageResponse messageResponse = new ActionMessageResponse();
        this.processMessageResponse(message, messageReturnStream, messageResponse);
        com.ibm.cics.common.util.Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"add", (Object)messageResponse);
        return messageResponse;
    }

    public MessageResponse remove(LocationCriteria locationCriteria, ObjectCriteria objectCriteria, ContainerData containerData) throws CMServerException {
        String message = MessageFactory.getRemoveFromContainerMessage(locationCriteria, objectCriteria, containerData, null);
        InputStreamReader messageReturnStream = this.sendMessage(message);
        MessageResponse messageResponse = new MessageResponse();
        this.processMessageResponse(message, messageReturnStream, messageResponse);
        return messageResponse;
    }

    public MessageResponse add(LocationCriteria locationCriteria, ObjectCriteriaList objectCriteria, ContainerData containerData, ProcessParms processParms) throws CMServerException {
        String message = MessageFactory.getAddToContainerMessage(locationCriteria, objectCriteria, containerData, processParms);
        InputStreamReader messageReturnStream = this.sendMessage(message);
        ActionMessageResponse messageResponse = new ActionMessageResponse();
        this.processMessageResponse(message, messageReturnStream, messageResponse);
        return messageResponse;
    }

    private void setRelease(int release) {
        this.release = release;
    }

    public MessageResponse remove(LocationCriteria locationCriteria, ObjectCriteriaList objectCriteria, ContainerData containerData) throws CMServerException {
        String message = MessageFactory.getRemoveFromContainerMessage(locationCriteria, objectCriteria, containerData, null);
        InputStreamReader messageReturnStream = this.sendMessage(message);
        MessageResponse messageResponse = new MessageResponse();
        this.processMessageResponse(message, messageReturnStream, messageResponse);
        return messageResponse;
    }

    private void setCMRelease(int cmRelease) {
        this.cmRelease = cmRelease;
    }

    public int getRelease() {
        return this.release;
    }

    public String getCicsRelease() {
        return this.cicsRelease;
    }

    public int getCMRelease() {
        return this.cmRelease;
    }

    public MessageResponse kill(String token) throws CMServerException {
        String message = MessageFactory.getKillMessage(token);
        InputStreamReader messageReturnStream = this.sendMessage(message);
        MessageResponse messageResponse = new MessageResponse();
        this.processMessageResponse(message, messageReturnStream, messageResponse);
        return messageResponse;
    }

    public MessageResponse ready(SelectionCriteria packageCriteria) throws CMServerException {
        String message = MessageFactory.getReadyMessage(packageCriteria, true);
        InputStreamReader messageReturnStream = this.sendMessage(message);
        MessageResponse messageResponse = new MessageResponse();
        this.processMessageResponse(message, messageReturnStream, messageResponse);
        return messageResponse;
    }

    public MessageResponse unready(SelectionCriteria packageCriteria) throws CMServerException {
        String message = MessageFactory.getReadyMessage(packageCriteria, false);
        InputStreamReader messageReturnStream = this.sendMessage(message);
        MessageResponse messageResponse = new MessageResponse();
        this.processMessageResponse(message, messageReturnStream, messageResponse);
        return messageResponse;
    }

    public MessageResponse migrate(SelectionCriteria packageCriteria) throws CMServerException {
        String message = MessageFactory.getMigrateMessage(packageCriteria);
        InputStreamReader messageReturnStream = this.sendMessage(message);
        MessageResponse messageResponse = new MessageResponse();
        this.processMessageResponse(message, messageReturnStream, messageResponse);
        return messageResponse;
    }

    public MessageResponse backout(SelectionCriteria packageCriteria) throws CMServerException {
        String message = MessageFactory.getBackoutMessage(packageCriteria);
        InputStreamReader messageReturnStream = this.sendMessage(message);
        MessageResponse messageResponse = new MessageResponse();
        this.processMessageResponse(message, messageReturnStream, messageResponse);
        return messageResponse;
    }

    public ListMessageResponse listWithRestrictionCriteriaAndProcessParms(LocationCriteria locationCriteria, ObjectCriteria objectCriteria, RestrictionCriteriaList restrictionCriteriaList, ProcessParms processParms) throws CMServerException {
        String message = MessageFactory.getObjectsMessage(locationCriteria, objectCriteria, restrictionCriteriaList, processParms);
        InputStreamReader messageReturnStream = this.sendMessage(message);
        ListMessageResponse messageResponse = new ListMessageResponse();
        this.processMessageResponse(message, messageReturnStream, messageResponse);
        return messageResponse;
    }

    public void removeConnectionObjectListener(Listener connectionObjectListener) {
        this.connectionObjectListeners.remove(connectionObjectListener);
    }

    public void addConnectionObjectListener(Listener connectionObjectListener) {
        this.connectionObjectListeners.add(connectionObjectListener);
    }

    public List<Map<String, String>> getConnectionObjects() {
        return this.connectionObjects;
    }

    private void sanitiseObjectDataForAPI(LocationCriteria loCr, ObjectData obDa) {
        String location = loCr.getLocationName();
        Configuration config = ConfigurationManager.getCurrent().getConfiguration(location);
        if (ConfigurationManager.getCurrent().getConnection().getRelease() >= 420 && obDa.attributes.containsKey("LSRPOOLID")) {
            String value = (String)obDa.attributes.get("LSRPOOLID");
            obDa.setAttribute("LSRPOOLNUM", value);
            if (Integer.valueOf(value) > 8) {
                obDa.attributes.remove("LSRPOOLID");
            }
        }
    }

    protected HttpURLConnection openConnection(URL url) throws Exception {
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        if (urlConnection instanceof HttpsURLConnection) {
            if (this.sslSocketFactory == null) {
                this.sslSocketFactory = ExplorerSecurityHelper.getSSLSocketFactory((String)this.name, (String)this.hostName, null);
            }
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)urlConnection;
            httpsURLConnection.setHostnameVerifier((HostnameVerifier)new ExplorerHostnameVerifier());
            httpsURLConnection.setSSLSocketFactory(this.sslSocketFactory);
        }
        return urlConnection;
    }

    public static interface Listener {
        public void connectionObjectsChanged(List<Map<String, String>> var1);
    }

    class ObjectKey {
        String configurationName;
        String groupName;
        String type;
        String name;

        ObjectKey(String aConfigurationName, String aGroupName, String aType, String aName) {
            this.configurationName = aConfigurationName;
            this.groupName = aGroupName;
            this.type = aType;
            this.name = aName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.configurationName == null ? 0 : this.configurationName.hashCode());
            result = 31 * result + (this.groupName == null ? 0 : this.groupName.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ObjectKey other = (ObjectKey)obj;
            if (this.configurationName == null ? other.configurationName != null : !this.configurationName.equals(other.configurationName)) {
                return false;
            }
            if (this.groupName == null ? other.groupName != null : !this.groupName.equals(other.groupName)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }
}

