/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.builder;

import com.ibm.cics.cm.model.CPSMConfiguration;
import com.ibm.cics.cm.model.CSDConfiguration;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ExportConfiguration;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.ZfsConfiguration;
import com.ibm.cics.cm.model.builder.ObjectBuilder;
import com.ibm.cics.cm.model.runtime.CMConnection;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.InquireMessageResponse;
import com.ibm.cics.cm.model.runtime.MessageResponse;
import java.util.List;
import java.util.Map;

public class ConfigurationBuilder
extends ObjectBuilder {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static ConfigurationManager.CMObjectFactory configurationObjectFactory;

    public ConfigurationBuilder() {
        this.setConfigurationAttributes("", "", "", "", "", "OLD", "", false, 0, "");
    }

    public ConfigurationBuilder(String name, String cpsmContext) {
        this.setConfigurationAttributes(name, "CPSM", cpsmContext, "", "DYNAMIC", "OLD", "", false, 0, "");
    }

    public ConfigurationBuilder(String name, String csdName, String csdRLS) {
        this.setConfigurationAttributes(name, "CSD", "", csdName, csdRLS, "OLD", "", false, 0, "");
    }

    public ConfigurationBuilder(String name, String rootPath, boolean backup, int backupCount, String backupDir) {
        this.setConfigurationAttributes(name, "ZFS", "", "", "DYNAMIC", "OLD", rootPath, backup, backupCount, backupDir);
    }

    private void setConfigurationAttributes(String name, String fileType, String cpsmContext, String csdName, String csdRLS, String expDisp, String rootPath, boolean backup, int backupCount, String backupDir) {
        this.setName(name);
        this.setAttribute("FILETYPE", fileType);
        this.setAttribute("CONTEXT", cpsmContext);
        this.setAttribute("CSDNAME", csdName);
        this.setAttribute("CSDRLS", csdRLS);
        this.setAttribute("EXPDISP", expDisp);
        if (CMConnection.apiLevel.compareTo("CCV540") >= 0) {
            this.setAttribute("ZROOTDIR", rootPath);
            this.setAttribute("ZBKUPTYPE", backup ? "DIR" : "NONE");
            this.setAttribute("ZBKUPCOUNT", String.format("%08d", backup ? backupCount : 0));
            this.setAttribute("ZBKUPDIR", backup ? backupDir : "");
        }
    }

    public static ConfigurationManager.CMObjectFactory getObjectFactory() {
        if (configurationObjectFactory == null) {
            configurationObjectFactory = new ConfigurationManager.CMObjectFactory(){

                @Override
                public ICMObject createObject(Map<String, String> attributes) {
                    String fileType = attributes.get("FILETYPE");
                    if ("CPSM".equals(fileType)) {
                        return new CPSMConfiguration(attributes);
                    }
                    if ("CSD".equals(fileType)) {
                        return new CSDConfiguration(attributes);
                    }
                    if ("EXPORT".equals(fileType)) {
                        return new ExportConfiguration(attributes);
                    }
                    if ("ZFS".equals(fileType)) {
                        return new ZfsConfiguration(attributes);
                    }
                    return new Configuration(attributes);
                }
            };
        }
        return configurationObjectFactory;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.setAttribute("NAME", name);
    }

    @Override
    public void setDescription(String desc) {
        this.setAttribute("DESCRIPTION", desc);
    }

    public void setTransformationVariables(Map<String, String> vars) {
        this.setAttribute("LTVCOUNT", String.format("%08d", vars.size()));
        int count = 0;
        for (String key : vars.keySet()) {
            this.setAttribute("XNAME" + count, key);
            this.setAttribute("XVALUE" + count, vars.get(key));
            ++count;
        }
    }

    public void setMROLinks(List<String> conns) {
        this.setAttribute("MROCOUNT", String.format("%08d", conns.size()));
        int count = 0;
        for (String conn : conns) {
            this.setAttribute("MROLINK" + count, conn);
            ++count;
        }
    }

    @Override
    public String getType() {
        return "CCONFIG";
    }

    @Override
    public Configuration create(ConfigurationManager aConfigurationManager) throws CMServerException {
        MessageResponse messageResponse;
        block3: {
            try {
                messageResponse = aConfigurationManager.create(this.getLocationCriteria(), this.getObjectCriteria(), this.getObjectData());
            }
            catch (CMServerException e) {
                messageResponse = e.getMessageResponse();
                if (messageResponse.returnCode != 8 || !"00040102".equals(messageResponse.reasonCode)) break block3;
                throw e;
            }
        }
        if (messageResponse != null && messageResponse.returnCode <= 4 && messageResponse instanceof InquireMessageResponse) {
            return (Configuration)ConfigurationBuilder.getObjectFactory().createObject(((InquireMessageResponse)messageResponse).getObject());
        }
        return null;
    }
}

