/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.builder;

import com.ibm.cics.cm.model.ChangePackage;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.builder.ObjectBuilder;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.model.runtime.ChangePackageObjectCriteria;
import com.ibm.cics.cm.model.runtime.ChangePackageRegistry;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.InquireMessageResponse;
import com.ibm.cics.cm.model.runtime.MessageResponse;
import java.util.Map;

public class ChangePackageBuilder
extends ObjectBuilder {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private MessageResponse lastMessageResponse = null;
    private static ConfigurationManager.CMObjectFactory packageObjectFactory;

    public ChangePackageBuilder() {
        this.objectCriteria = new ChangePackageObjectCriteria();
    }

    @Override
    public void setName(String aName) {
        super.setName(aName);
        this.objectCriteria.setObjectName(aName);
    }

    public static ConfigurationManager.CMObjectFactory getObjectFactory() {
        if (packageObjectFactory == null) {
            packageObjectFactory = new ConfigurationManager.CMObjectFactory(){

                @Override
                public ICMObject createObject(Map<String, String> attributes) {
                    ChangePackage result = null;
                    if (ChangePackageRegistry.getInstance().isCached(attributes.get("CPID"))) {
                        result = ChangePackageRegistry.getInstance().getPackage(attributes.get("CPID"));
                        result.updateAttributes(attributes);
                    } else {
                        result = new ChangePackage(attributes);
                        ChangePackageRegistry.getInstance().addPackage(result);
                    }
                    return result;
                }
            };
        }
        return packageObjectFactory;
    }

    @Override
    public String getType() {
        return "CHGPKG";
    }

    public MessageResponse getLastResponse() {
        return this.lastMessageResponse;
    }

    @Override
    public ChangePackage create(ConfigurationManager aConfigurationManager) {
        MessageResponse messageResponse;
        this.lastMessageResponse = null;
        try {
            messageResponse = aConfigurationManager.createChangePackage(this.getLocationCriteria(), (ChangePackageObjectCriteria)this.getObjectCriteria(), this.getObjectData());
        }
        catch (CMServerException e) {
            messageResponse = e.getMessageResponse();
        }
        if (messageResponse != null) {
            if (messageResponse.returnCode <= 4 && messageResponse instanceof InquireMessageResponse) {
                this.lastMessageResponse = messageResponse;
                return (ChangePackage)ChangePackageBuilder.getObjectFactory().createObject(((InquireMessageResponse)messageResponse).getObject());
            }
            this.lastMessageResponse = messageResponse;
        }
        return null;
    }
}

