/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.CMObject;
import com.ibm.cics.cm.model.CMUtilities;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.FilteredCollection;
import com.ibm.cics.cm.model.HistoryProviderDelegate;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.ICMDefinition2;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.ZfsConfiguration;
import com.ibm.cics.cm.model.runtime.CMListFactory;
import com.ibm.cics.cm.model.runtime.CMServerDeleteException;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.model.runtime.CMServerListException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.ListMessageResponse;
import com.ibm.cics.cm.model.runtime.LocationCriteria;
import com.ibm.cics.cm.model.runtime.MessageResponse;
import com.ibm.cics.cm.model.runtime.ObjectCriteria;
import com.ibm.cics.cm.model.runtime.ObjectData;
import com.ibm.cics.common.util.Debug;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ZfsDefinition
extends CMObject
implements ICMDefinition2 {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2017, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Map<String, Map<String, ZfsDefinition>> localDefinitions = new HashMap<String, Map<String, ZfsDefinition>>();
    private List<ZfsDefinitionListener> listeners = new ArrayList<ZfsDefinitionListener>();
    private Date changeTime;
    private HistoryProviderDelegate historyProviderDelegate;
    protected static Logger logger = Logger.getLogger("com.ibm.cics.cm.model");
    private boolean deleted = false;

    private ZfsDefinition(Map<String, String> attributes) {
        super(attributes);
        this.setName(attributes.get("NAME"));
    }

    public static ZfsDefinition getNewZfsDefinition(Map<String, String> attributes) {
        ZfsDefinition definition;
        String configName = attributes.get("CCONFIG");
        String name = attributes.get("NAME");
        Map<String, ZfsDefinition> defsByConfig = localDefinitions.get(configName);
        if (defsByConfig == null) {
            defsByConfig = new HashMap<String, ZfsDefinition>();
            localDefinitions.put(configName, defsByConfig);
        }
        if ((definition = defsByConfig.get(name)) == null) {
            definition = new ZfsDefinition(attributes);
            defsByConfig.put(name, definition);
        } else {
            definition.fillAttributes(attributes);
        }
        return definition;
    }

    public IFilteredCollection<ICMDefinition> getDefinitions() {
        return this.getDefinitions(true);
    }

    @Override
    public String getType() {
        return "ZFSFILE";
    }

    public IFilteredCollection<ICMDefinition> getDefinitions(boolean skinny) {
        ObjectCriteria objectCriteria = ObjectCriteria.newObjectCriteriaForGroup("*", "*");
        LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(this.getName());
        FilteredCollection definitions = new FilteredCollection(new CMListFactory(locationCriteria, objectCriteria){

            @Override
            public List<ICMObject> getResults() {
                ListMessageResponse response = null;
                try {
                    response = ConfigurationManager.getCurrent().getList(this.locationCriteria, this.objectCriteria, this.restrictionCriteriaList);
                }
                catch (CMServerListException e) {
                    Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"getDefinitions", (String)"CM Server List Exception", (Throwable)e);
                }
                if (response != null) {
                    ArrayList<ICMObject> objects = new ArrayList<ICMObject>();
                    Iterator<Map<String, String>> iterator = response.getObjects();
                    while (iterator.hasNext()) {
                        Map<String, String> map = iterator.next();
                    }
                    return objects;
                }
                return null;
            }
        });
        return definitions;
    }

    public ICMDefinition getDefinition(String type, String name) {
        IFilteredCollection<ICMDefinition> definitions = this.getDefinitions();
        definitions.setObjectName(name);
        definitions.setObjectType(type);
        if (definitions.size() >= 1) {
            return definitions.iterator().next();
        }
        return null;
    }

    public boolean equals(Object o) {
        return o instanceof ZfsDefinition && ((ZfsDefinition)o).getName().equals(this.getName()) && ((ZfsDefinition)o).getConfigurationName().equals(this.getConfigurationName());
    }

    public String getConfigurationName() {
        return (String)this.attributes.get("CCONFIG");
    }

    @Override
    public Configuration getConfiguration() {
        return ConfigurationManager.getCurrent().getConfiguration((String)this.attributes.get("CCONFIG"));
    }

    public String getLocation() {
        String configName = (String)this.attributes.get("CCONFIG");
        Configuration config = null;
        if (configName != null) {
            config = ConfigurationManager.getCurrent().getConfiguration(configName);
        }
        if (config != null && config instanceof ZfsConfiguration) {
            return ((ZfsConfiguration)config).getZfsRootDir();
        }
        return null;
    }

    public String getDisplayChangeTime() {
        try {
            Date date = CMUtilities.getyyyyMMddDateFormat().parse((String)this.attributes.get("CHANGETIME"));
            return DateFormat.getDateTimeInstance().format(date);
        }
        catch (ParseException e) {
            return (String)this.attributes.get("CHANGETIME");
        }
    }

    @Override
    public Date getChangeTime() {
        try {
            return CMUtilities.getyyyyMMddDateFormat().parse((String)this.attributes.get("CHANGETIME"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getRelPath() {
        return (String)this.attributes.get("RELPATH");
    }

    public void setRelPath(String path) {
        this.attributes.put("RELPATH", path);
    }

    public String getData1() {
        return (String)this.attributes.get("DATA1");
    }

    public void setData1(String data) {
        this.attributes.put("DATA1", data);
    }

    public String getData2() {
        return (String)this.attributes.get("DATA2");
    }

    public void setData2(String data) {
        this.attributes.put("DATA2", data);
    }

    public String getData3() {
        return (String)this.attributes.get("DATA3");
    }

    public void setData3(String data) {
        this.attributes.put("DATA3", data);
    }

    public String getData4() {
        return (String)this.attributes.get("DATA4");
    }

    public void setData4(String data) {
        this.attributes.put("DATA4", data);
    }

    public void setIntegrityToken(String token) {
        this.attributes.put("INTEGRITYTOKEN", token);
    }

    public MessageResponse update() throws CMServerException {
        HashMap<String, String> tempMap = new HashMap<String, String>(this.attributes);
        tempMap.remove("TYPE");
        tempMap.remove("INTEGRITYTOKEN");
        tempMap.remove("OBJECTINSTANCE");
        ObjectData od = new ObjectData();
        od.setAttributes(tempMap);
        MessageResponse response = ConfigurationManager.getCurrent().update(LocationCriteria.newConfigurationLocationCriteria(this.getConfigurationName()), ObjectCriteria.newZfsDefinitionCriteria(this.name), od, (String)this.attributes.get("INTEGRITYTOKEN"));
        this.notifyListeners(true);
        return response;
    }

    public boolean delete() throws CMServerDeleteException {
        boolean result = false;
        try {
            LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(this.getConfigurationName());
            ObjectCriteria objectCriteria = ObjectCriteria.newZfsDefinitionCriteria(this.getName());
            result = ConfigurationManager.getCurrent().delete(locationCriteria, objectCriteria);
        }
        catch (CMServerDeleteException de) {
            Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"delete", (String)"Delete failed.", (Throwable)de);
            throw de;
        }
        this.deleted = result;
        this.notifyListeners(true);
        return result;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted() {
        this.deleted = true;
        this.notifyListeners(true);
    }

    public void setDescription(String newDescription) {
        this.attributes.put("DESCRIPTION", newDescription);
    }

    public void setAttributes(Map<String, String> attributes) {
        this.fillAttributes(attributes);
    }

    public boolean addListener(ZfsDefinitionListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(ZfsDefinitionListener listener) {
        return this.listeners.remove(listener);
    }

    public void notifyListeners(boolean changed) {
        for (ZfsDefinitionListener next : this.listeners) {
            next.notify(changed, this);
        }
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    public abstract class ZfsDefinitionListener {
        private ZfsDefinition host;

        public ZfsDefinitionListener(ZfsDefinition next) {
            this.host = next;
        }

        public abstract void notify(boolean var1, ZfsDefinition var2);

        public void dispose() {
            this.host.removeListener(this);
        }
    }
}

