/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.Messages;
import com.ibm.cics.cm.model.builder.ConfigurationBuilder;
import com.ibm.cics.cm.model.definitions.ResourceDefinitionFactory;
import java.util.HashMap;
import java.util.Map;

public class ReadyListObject
implements ICMObject {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String SEL_COMMAND = "SEL_COMMAND";
    public static final String SEL_CPID = "SEL_CPID";
    public static final String SEL_CCONFIG = "SEL_CCONFIG";
    public static final String SEL_GROUP = "SEL_GROUP";
    public static final String SEL_OBJTYPE = "SEL_OBJTYPE";
    public static final String SEL_OBJNAME = "SEL_OBJNAME";
    public static final String SEL_TCONTAINER = "SEL_TCONTAINER";
    public static final String CSD_DSN = "CSD_DSN";
    public static final String CONTEXT = "CONTEXT";
    public static final String CREMETHOD = "CREMETHOD";
    public static final String CC_TYPE = "CC_TYPE";
    public static final String PREV_CCONFIG = "PREV_CCONFIG";
    public static final String PREV_GROUP = "PREV_GROUP";
    public static final String PREV_OBJTYPE = "PREV_OBJTYPE";
    public static final String PREV_OBJNAME = "PREV_OBJNAME";
    public static final String PREV_TCONTAINER = "PREV_TCONTAINER";
    public static final String RETURNCODE = "RETURNCODE";
    public static final String REASONCODE = "REASONCODE";
    public static final String SPACES = "-SPACES-";
    protected Map<String, String> attributes;
    protected String name;
    private boolean isCommand;

    public ReadyListObject(Map<String, String> attributes) {
        this.attributes = attributes;
        this.name = this.attributes.get(SEL_OBJNAME);
        if (SPACES.equals(this.attributes.get(SEL_GROUP))) {
            this.attributes.put(SEL_GROUP, "");
        }
        this.isCommand = this.attributes.containsKey(SEL_COMMAND);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.isCommand) {
            sb.append("Command : ");
        } else {
            sb.append("Resource : ");
        }
        sb.append(this.name);
        return sb.toString();
    }

    public boolean isCommand() {
        return this.isCommand;
    }

    public ICMDefinition getResource() {
        HashMap<String, String> standardAttribs = new HashMap<String, String>();
        standardAttribs.put("NAME", this.attributes.get(SEL_OBJNAME));
        standardAttribs.put("TYPE", this.attributes.get(SEL_OBJTYPE));
        standardAttribs.put("GROUP", this.attributes.get(SEL_GROUP));
        HashMap<String, String> configAttribs = new HashMap<String, String>();
        configAttribs.put("NAME", this.attributes.get(SEL_CCONFIG));
        String ccCode = this.attributes.get(CC_TYPE);
        String ccType = null;
        if (ccCode != null) {
            if (ccCode.matches("C")) {
                ccType = "CPSM";
            } else if (ccCode.matches("D")) {
                ccType = "CSD";
            } else if (ccCode.matches("E")) {
                ccType = "EXPORT";
            }
        }
        configAttribs.put("FILETYPE", ccType);
        Configuration configuration = (Configuration)ConfigurationBuilder.getObjectFactory().createObject(configAttribs);
        return (ICMDefinition)ResourceDefinitionFactory.getObject(configuration, standardAttribs);
    }

    public ReadyState getState() {
        String rc = this.attributes.get(RETURNCODE);
        if (rc.matches("00000000")) {
            return ReadyState.READY;
        }
        String reason = this.attributes.get(REASONCODE);
        if (reason.endsWith("0018")) {
            return ReadyState.NOT_READY_CHANGED;
        }
        if (reason.endsWith("004E")) {
            return ReadyState.NOT_READY_NEVER;
        }
        if (reason.endsWith("0058")) {
            return ReadyState.NOT_FOUND;
        }
        return ReadyState.UNKNOWN;
    }

    public static enum ReadyState {
        READY,
        NOT_READY_CHANGED,
        NOT_READY_NEVER,
        NOT_FOUND,
        UNKNOWN;


        public String getShortState() {
            return Messages.getString("ReadyListObject.ReadyState.short." + this.toString());
        }

        public String getDescription() {
            return Messages.getString("ReadyListObject.ReadyState.description." + this.toString());
        }
    }
}

