/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.cm.model.ResourceList;
import com.ibm.cics.cm.model.runtime.ListElement;

public class PackageCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String COMMAND_TYPE = "COMMAND";
    public static final String TARGET_CONTAINER = "TCONTAINER";
    private ListElement le;

    public PackageCommand(Type type, ICMDefinition definition, ResourceDefinitionGroup sourceGroup, String targetGroup) {
        this.le = new ListElement(definition.getResourceGroupName(), definition.getType(), definition.getName());
        this.le.addAttribute(COMMAND_TYPE, type.name());
        this.le.addAttribute(TARGET_CONTAINER, targetGroup);
    }

    public PackageCommand(Type type, ResourceDefinitionGroup sourceGroup, String targetList) {
        this.le = new ListElement(null, "RESGROUP", sourceGroup.getName());
        this.le.addAttribute(COMMAND_TYPE, type.name());
        this.le.addAttribute(TARGET_CONTAINER, targetList);
    }

    public PackageCommand(ResourceDefinitionGroup sourceGroup, String targetList, String beforeAfter, ResourceDefinitionGroup adjGroup) {
        this.le = new ListElement(null, "RESGROUP", sourceGroup.getName());
        this.le.addAttribute(COMMAND_TYPE, Type.ADD.name());
        this.le.addAttribute(TARGET_CONTAINER, targetList);
        this.le.addAttribute("GRPPLACEMENT", beforeAfter);
        this.le.addAttribute("ADJACENTGRP", adjGroup.getName());
    }

    public PackageCommand(ResourceList list) {
        this.le = new ListElement(null, "RESDESC", list.getName());
        this.le.addAttribute(COMMAND_TYPE, Type.DELETE.name());
    }

    public ListElement getListElement() {
        return this.le;
    }

    public static enum Type {
        ADD,
        REMOVE,
        DELETE;

    }
}

