/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.MutableCMObject;
import com.ibm.cics.cm.model.ResourceList;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.LocationCriteria;
import com.ibm.cics.cm.model.runtime.ObjectCriteria;
import com.ibm.cics.cm.model.runtime.ObjectData;
import com.ibm.cics.cm.model.runtime.ResourceListObjectData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MutableResourceList
extends MutableCMObject {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<String> groupNames = new ArrayList<String>();

    public MutableResourceList(ConfigurationManager cm, ResourceList resourceList, List<Map<String, String>> groupObjects) {
        super(cm, resourceList);
        for (Map<String, String> obj : groupObjects) {
            String groupName = obj.get("LISTGROUP");
            if (groupName == null) continue;
            this.groupNames.add(groupName);
        }
    }

    @Override
    public String getObjectType() {
        return "RESDESC";
    }

    @Override
    protected ObjectCriteria getObjectCriteria() {
        return ObjectCriteria.newObjectCriteria(this.getObjectType(), this.cmObject.getAttributes().get("NAME"));
    }

    @Override
    protected LocationCriteria getLocationCriteria() {
        return LocationCriteria.newConfigurationLocationCriteria(((ResourceList)this.cmObject).getConfiguration().getName());
    }

    @Override
    public void refresh() {
    }

    @Override
    protected ObjectData getObjectData() {
        ResourceListObjectData data = new ResourceListObjectData();
        data.setGroups(this.groupNames);
        data.setAttributes(this.getAttributes());
        return data;
    }

    public List<String> getGroupNames() {
        return this.groupNames;
    }

    public void setGroupNames(List<String> groupNames) {
        this.groupNames = groupNames;
    }
}

