/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.Messages;
import java.util.HashMap;

public class DataSource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String IMCS = "Runtime CSD";
    private static final String IMCP = "Runtime CICSPlexSM";
    private static final String CLCS = "Candidates CSD";
    private static final String CLCP = "Candidates CICSPlexSM";
    private HashMap<String, String> attributes = new HashMap();
    private TargetRegion targetRegion = new TargetRegion();
    private CCMRegion ccmRegion = new CCMRegion();

    public static String getCollectionType(String code) {
        if (code.trim().equalsIgnoreCase("IMCS")) {
            return IMCS;
        }
        if (code.trim().equalsIgnoreCase("IMCP")) {
            return IMCP;
        }
        if (code.trim().equalsIgnoreCase("CLCS")) {
            return CLCS;
        }
        if (code.trim().equalsIgnoreCase("CLCP")) {
            return CLCP;
        }
        return Messages.getString("ReportViewer.unknown_collection_type");
    }

    public int getId() {
        return Integer.parseInt(this.attributes.get(Tags.ID.toString()));
    }

    public TargetRegion getTargetRegion() {
        return this.targetRegion;
    }

    public CCMRegion getCCMRegion() {
        return this.ccmRegion;
    }

    public HashMap<String, String> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(String tag, String value) {
        this.attributes.put(tag, value);
    }

    public class CCMRegion {
        private HashMap<String, String> attributes = new HashMap();

        public HashMap<String, String> getAttributes() {
            return this.attributes;
        }

        public void addAttribute(String tag, String value) {
            this.attributes.put(tag, value);
        }
    }

    public static enum Tags {
        DATA_SOURCE_ELEMENT("DATASOURCEELEMENT"),
        ID("ID"),
        DATE("DATE"),
        TIME("TIME"),
        RECORD_COUNT("RECORDCOUNT"),
        TYPE("TYPE"),
        SMFID("SMFID"),
        DATA_SET_NAME("DATASETNAME"),
        REPORT_SET_ID("REPORTSETID"),
        TARGET_REGION("TARGETREGION"),
        CCM_REGION("CCMREGION"),
        JOB_NAME("JOBNAME"),
        APPL_ID("APPLID"),
        SYS_ID("SYSID"),
        CTS_VRM("CTSVRM"),
        CCM_VRM("CCMVRM");

        private final String text;

        private Tags(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    public class TargetRegion {
        private HashMap<String, String> attributes = new HashMap();

        public HashMap<String, String> getAttributes() {
            return this.attributes;
        }

        public void addAttribute(String tag, String value) {
            this.attributes.put(tag, value);
        }
    }
}

