/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.CMContext;
import com.ibm.cics.cm.model.CPSMConfiguration;
import com.ibm.cics.cm.model.CPSMContext;
import com.ibm.cics.cm.model.CSDConfiguration;
import com.ibm.cics.cm.model.CSDContext;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ZfsConfiguration;
import com.ibm.cics.cm.model.ZfsContext;
import com.ibm.cics.sm.comm.IContext;

public class ConfigurationContext
extends CMContext {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static ConfigurationContext newFrom(Configuration aConfiguration) {
        if (aConfiguration instanceof CSDConfiguration) {
            return new CSDContext(aConfiguration);
        }
        if (aConfiguration instanceof CPSMConfiguration) {
            return new CPSMContext(aConfiguration);
        }
        if (aConfiguration instanceof ZfsConfiguration) {
            return new ZfsContext(aConfiguration);
        }
        throw new RuntimeException("Unknown configuration");
    }

    ConfigurationContext(Configuration aConfiguration) {
        this.setConfiguration(aConfiguration);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ConfigurationContext(");
        buffer.append(this.getConfiguration());
        buffer.append(')');
        return buffer.toString();
    }

    public IContext getSMContext() {
        if (this.getConfiguration() instanceof CPSMConfiguration) {
            final String cpsmContext = ((CPSMConfiguration)this.getConfiguration()).getCPSMContext();
            IContext context = new IContext(){

                public String getContext() {
                    return cpsmContext;
                }
            };
            return context;
        }
        return null;
    }

    public boolean equals(Object o) {
        return o instanceof ConfigurationContext && ((ConfigurationContext)o).getConfiguration().equals(this.getConfiguration());
    }
}

