/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.CICSConfiguration;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ConfigurationConnection;
import com.ibm.cics.cm.model.ConfigurationConnectionManager;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.ProcessParms;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.model.IRepository;
import com.ibm.cics.model.InstallTarget;
import com.ibm.cics.sm.comm.CSDRepository;
import com.ibm.cics.sm.comm.IScopedContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class CSDConfiguration
extends CICSConfiguration {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    Logger logger = Logger.getLogger("com.ibm.cics.cm.model");
    private List<String> mROLinks;
    private ArrayList<ConfigurationConnection> configurationConnections;

    public CSDConfiguration(Map<String, String> attributes) {
        super(attributes);
    }

    public String getCSDName() {
        return this.getAttributes().get("CSDNAME");
    }

    public boolean getCSDAudit() {
        return "YES".equals(this.getAttributes().get("AUDCSDUP"));
    }

    public void setCSDAudit(boolean audit) {
        this.getAttributes().put("AUDCSDUP", audit ? "YES" : "NO");
    }

    public List<String> getMROlinks() {
        this.mROLinks = new ArrayList<String>();
        String mro = "MROLINK";
        String mROCount = this.getAttributes().get("MROCOUNT");
        if (mROCount == null) {
            try {
                Configuration configuration = ConfigurationManager.getCurrent().getConfiguration(this.getName());
                Map<String, String> attributes = configuration.getAttributes();
                this.fillAttributes(attributes);
            }
            catch (Exception e) {
                Debug.event((Logger)this.logger, (String)CSDConfiguration.class.getName(), (String)"getMROlinks", (Object)e);
            }
            mROCount = this.getAttributes().get("MROCOUNT");
        }
        if (mROCount != null) {
            int count = Integer.parseInt(mROCount);
            int i = 0;
            while (i < count) {
                String link = this.getAttributes().get(String.valueOf(mro) + i);
                this.mROLinks.add(link);
                ++i;
            }
        }
        return this.mROLinks;
    }

    @Override
    public ProcessParms getInstallProcessParms(IScopedContext target, boolean quiesce, boolean discard) {
        String applid = target.getScope();
        ConfigurationConnection configurationConnectionForApplid = ConfigurationConnectionManager.getCurrent().getConfigurationConnectionForApplid(applid);
        if (configurationConnectionForApplid == null) {
            return new ProcessParms();
        }
        String mroLink = configurationConnectionForApplid.getName();
        String qParm = quiesce ? "YES" : "NO";
        String dParm = discard ? "YES" : "NO";
        return ProcessParms.getInstallForCSD(qParm, dParm, new String[]{mroLink});
    }

    @Override
    public ProcessParms getInstallProcessParms(ConfigurationConnection[] targets, boolean quiesce, boolean discard) {
        String[] mroLinks = new String[targets.length];
        int i = 0;
        while (i < targets.length) {
            mroLinks[i] = targets[i].getName();
            ++i;
        }
        String qParm = quiesce ? "YES" : "NO";
        String dParm = discard ? "YES" : "NO";
        return ProcessParms.getInstallForCSD(qParm, dParm, mroLinks);
    }

    public List<ConfigurationConnection> getConnections() {
        if (this.configurationConnections == null) {
            this.configurationConnections = new ArrayList();
            this.getMROlinks();
            for (String mROLink : this.mROLinks) {
                ConfigurationConnection configurationConnection = ConfigurationConnectionManager.getCurrent().getConfigurationConnection(mROLink);
                if (configurationConnection == null) continue;
                this.configurationConnections.add(configurationConnection);
            }
        }
        return this.configurationConnections;
    }

    public void setCSDFile(String newCSDFileName) {
        this.attributes.put("CSDNAME", newCSDFileName);
    }

    public void setCSDRLS(String csdrls) {
        this.attributes.put("CSDRLS", csdrls);
    }

    public void setMROLinks(ArrayList<String> csdConnections) {
        this.clearMROLinks();
        int count = 0;
        for (String entry : csdConnections) {
            this.attributes.put("MROLINK" + count, entry);
            ++count;
        }
        this.attributes.put("MROCOUNT", String.format("%08d", count));
    }

    private void clearMROLinks() {
        HashMap<String, String> newAttr = new HashMap<String, String>();
        for (Map.Entry entry : this.attributes.entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith("MROLINK") || key.equals("MROCOUNT")) continue;
            newAttr.put(key, (String)entry.getValue());
        }
        this.attributes = newAttr;
    }

    @Override
    public IRepository getRepository() {
        return new CSDRepository(this.getName(), this.getInstallTargets());
    }

    @Override
    public List<InstallTarget> getInstallTargets() {
        ArrayList<InstallTarget> list = new ArrayList<InstallTarget>();
        List<ConfigurationConnection> connections = this.getConnections();
        Iterator<ConfigurationConnection> iterator = connections.iterator();
        while (iterator.hasNext()) {
            ConfigurationConnection c;
            final ConfigurationConnection fC = c = iterator.next();
            list.add(new InstallTarget(){

                public String getResourceType() {
                    return "CONNDEF";
                }

                public String getName() {
                    return fC.getName();
                }

                public String getID() {
                    return fC.getName();
                }

                public String getContextString() {
                    return CSDConfiguration.this.getCSDName();
                }
            });
        }
        return list;
    }
}

