/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.compare.ui;

import com.ibm.cics.cm.compare.ui.CompareCICSObjectEditorInput;
import com.ibm.cics.cm.compare.ui.Messages;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.History;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import com.ibm.cics.model.ICICSObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CompareWithCurrentHandler
implements IHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ICMDefinition current;
    private static Logger logger = Logger.getLogger(CompareWithCurrentHandler.class.getPackage().getName());

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final History selectedItem = (History)((IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event)).getFirstElement();
        JobWithCancelingSupport compareWithCurrentJob = new JobWithCancelingSupport(Messages.getString("CompareWithCurrentHandler.description")){
            boolean cancelled;
            {
                super($anonymous0);
                this.cancelled = false;
            }

            protected void cancelingSub() {
                this.cancelled = true;
            }

            protected IStatus runSub(IProgressMonitor monitor) {
                if (!this.cancelled) {
                    Configuration configuration = selectedItem.getProvider().getConfiguration();
                    if (configuration == null) {
                        logger.log(Level.WARNING, "Can't find valid Configuration to compare current artifact", selectedItem);
                        this.cancelled = true;
                    } else {
                        ResourceDefinitionGroup group = configuration.getResourceGroup(selectedItem.getResourceGroup());
                        if (group != null) {
                            CompareWithCurrentHandler.this.current = group.getDefinition(selectedItem.getType(), selectedItem.getName());
                        }
                    }
                }
                if (!this.cancelled) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (CompareWithCurrentHandler.this.current != null) {
                                ICICSObject left = (ICICSObject)Platform.getAdapterManager().loadAdapter((Object)CompareWithCurrentHandler.this.current, ICICSObject.class.getName());
                                ICICSObject right = (ICICSObject)Platform.getAdapterManager().loadAdapter((Object)selectedItem, ICICSObject.class.getName());
                                if (left != null && right != null) {
                                    try {
                                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new CompareCICSObjectEditorInput(left, right), "com.ibm.cics.cm.compare.editor");
                                    }
                                    catch (PartInitException e) {
                                        logger.log(Level.SEVERE, "Exception opening compare editor", e);
                                    }
                                }
                            } else {
                                ViewHelper.setDeferredStatusErrorMessage((String)Messages.getString("CompareWithCurrentHandler.currentVersionNotFoundError"));
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        };
        compareWithCurrentJob.schedule();
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

