/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.compare.ui;

import com.ibm.cics.cm.compare.model.CompareResult;
import com.ibm.cics.cm.compare.model.IDifferenceEngine;
import com.ibm.cics.cm.compare.model.StructureCompareResult;
import com.ibm.cics.cm.compare.ui.CICSCompareEditorInput;
import com.ibm.cics.cm.compare.ui.CompareEditorPropertySheet;
import com.ibm.cics.cm.compare.ui.CompareResourceExplorerEditorInput;
import com.ibm.cics.cm.compare.ui.Messages;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.cm.model.ResourceList;
import com.ibm.cics.cm.ui.CMUIUtilities;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.editors.IExplorerEditorInput;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSObject;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class CompareResourceDefinitionEditor
extends EditorPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String ID = "com.ibm.cics.cm.compare.editor";
    protected CICSCompareEditorInput input;
    private SashForm topLevelForm;
    private Composite compareEditorComposite;
    TreeViewer structureTreeViewer;
    CompareEditorPropertySheet propSheet;
    protected CompareSelectionListener selectionListener;
    private String checksumType;
    private Job compareJob;
    private IPartListener2 partListener;
    private Menu menu;
    private ToolItem checksumToolItem;
    private ToolBar checksumToolBar;

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.input = (CICSCompareEditorInput)input;
        this.checksumType = "NONE";
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        Composite masterComposite = new Composite(parent, 0);
        masterComposite.setLayout((Layout)new GridLayout(1, false));
        this.createToolbar(masterComposite);
        this.topLevelForm = new SashForm(masterComposite, 512);
        this.topLevelForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTopPanel((Composite)this.topLevelForm);
        this.createBottomPanel((Composite)this.topLevelForm);
        this.topLevelForm.setWeights(new int[]{1, 3});
        this.setContentDescription(this.input.getName());
        this.setPartName(this.input.getName());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.cics.cm.ui.compare_editor");
        this.addPartListener();
        this.createPopupMenu();
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CompareResourceDefinitionEditor.this.fillContextMenu(manager);
            }
        });
        Menu popupMenu = menuMgr.createContextMenu(this.structureTreeViewer.getControl());
        this.structureTreeViewer.getControl().setMenu(popupMenu);
        ((IEditorSite)this.getSite()).registerContextMenu(menuMgr, (ISelectionProvider)this.structureTreeViewer, false);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("open"));
        manager.add((IContributionItem)new Separator("actions"));
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void createToolbar(Composite masterComposite) {
        this.checksumToolBar = new ToolBar(masterComposite, 0);
        this.checksumToolBar.setLayoutData((Object)new GridData(0x1000008, 128, true, false));
        this.checksumToolItem = new ToolItem(this.checksumToolBar, 4);
        this.menu = new Menu((Control)masterComposite);
        this.checksumToolItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rect = CompareResourceDefinitionEditor.this.checksumToolItem.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = CompareResourceDefinitionEditor.this.checksumToolBar.toDisplay(pt);
                CompareResourceDefinitionEditor.this.menu.setLocation(pt.x, pt.y);
                CompareResourceDefinitionEditor.this.menu.setVisible(true);
            }
        });
        this.checksumToolItem.setText(Messages.getString("CompareResourceDefinitionEditor.1"));
        this.checksumToolItem.setToolTipText(Messages.getString("CompareResourceDefinitionEditor.2"));
        this.checksumToolItem.setEnabled(false);
    }

    private void fillToolbar() {
        MenuItem[] items;
        if (this.menu != null && (items = this.menu.getItems()) != null) {
            MenuItem[] menuItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem menuItem = menuItemArray[n2];
                menuItem.dispose();
                ++n2;
            }
        }
        List<Object> supportedChecksums = this.input.getLeft() instanceof ResourceDefinitionGroup ? ResourceDefinitionGroup.getSupportedChecksums() : (this.input.getLeft() instanceof ResourceList ? ResourceList.getSupportedChecksums() : Arrays.asList("NONE"));
        for (final String supportedChecksum : supportedChecksums) {
            MenuItem item = new MenuItem(this.menu, 16);
            item.setEnabled(true);
            final String checksumDisplayName = Messages.getString("CHECKSUM_" + supportedChecksum);
            item.setText(checksumDisplayName);
            item.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    CompareResourceDefinitionEditor.this.setChecksumType(supportedChecksum);
                    CompareResourceDefinitionEditor.this.setCheckSumToolBarItemText(checksumDisplayName);
                }
            });
            if (supportedChecksum.equals("LIST")) {
                item.setEnabled(false);
            }
            if (!supportedChecksum.equals(this.checksumType)) continue;
            item.setSelection(true);
            this.setCheckSumToolBarItemText(checksumDisplayName);
        }
        this.checksumToolItem.setEnabled(true);
    }

    private void setCheckSumToolBarItemText(String checksumDisplayName) {
        this.checksumToolItem.setText(checksumDisplayName);
        this.checksumToolBar.pack();
        this.checksumToolBar.layout();
        this.checksumToolBar.getParent().layout();
    }

    private void createTopPanel(Composite parent) {
        this.selectionListener = new CompareSelectionListener();
        this.structureTreeViewer = new TreeViewer(parent, 0x10000800);
        this.structureTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this.selectionListener);
        this.structureTreeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof StructureCompareResult) {
                    StructureCompareResult result = (StructureCompareResult)parentElement;
                    return result.getChildren().toArray();
                }
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof CICSCompareEditorInput || element instanceof StructureCompareResult;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement == CompareResourceDefinitionEditor.this.input) {
                    return CompareResourceDefinitionEditor.this.input.getResults().toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        this.structureTreeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof PendingUpdateAdapter) {
                    return Messages.getString("CompareResourceDefinitionEditor.4");
                }
                if (element instanceof CompareResult) {
                    CompareResult result = (CompareResult)element;
                    if (result.getDifferingObject() instanceof ICICSAttribute) {
                        Object id = result.getDifferingObject();
                        return CompareResourceDefinitionEditor.this.input.getInputForResource((ICICSObject)result.getLeft()).getPropertyDescriptor(id).getDisplayName();
                    }
                    if (result.getDifferingObject() instanceof ICICSObject) {
                        return ((ICICSObject)result.getDifferingObject()).getName();
                    }
                    IDeferredWorkbenchAdapter adapter = (IDeferredWorkbenchAdapter)Platform.getAdapterManager().loadAdapter(result.getDifferingObject(), IDeferredWorkbenchAdapter.class.getName());
                    if (adapter != null) {
                        return adapter.getLabel(result.getDifferingObject());
                    }
                }
                return null;
            }

            public Image getImage(Object element) {
                if (element instanceof CompareResult) {
                    CompareResult result = (CompareResult)element;
                    if (result.getDifferingObject() instanceof ICICSAttribute) {
                        return UIActivator.getImage((ImageDescriptor)UIActivator.IMGD_ATTRIBUTE);
                    }
                    if (result.getDifferingObject() instanceof ICICSObject) {
                        ImageDescriptor desc = UIPlugin.getImageDescriptor((String)("icons/" + ((ICICSObject)result.getDifferingObject()).getObjectType().getResourceTableName() + ".GIF"));
                        if (desc != null) {
                            return UIActivator.getImage((ImageDescriptor)desc);
                        }
                    } else {
                        IDeferredWorkbenchAdapter adapter = (IDeferredWorkbenchAdapter)Platform.getAdapterManager().loadAdapter(result.getDifferingObject(), IDeferredWorkbenchAdapter.class.getName());
                        if (adapter != null) {
                            ImageDescriptor desc = adapter.getImageDescriptor(result.getDifferingObject());
                            return UIActivator.getImage((ImageDescriptor)desc);
                        }
                    }
                }
                return null;
            }
        }, decorator));
        this.compareJob = new JobWithCancelingSupport(Messages.getString("CompareResourceDefinitionEditor.7")){
            boolean cancelled;
            {
                this.cancelled = false;
            }

            protected void cancelingSub() {
                this.cancelled = true;
            }

            protected IStatus runSub(IProgressMonitor monitor) {
                if (!this.cancelled) {
                    IDifferenceEngine differ = (IDifferenceEngine)Platform.getAdapterManager().loadAdapter(CompareResourceDefinitionEditor.this.input.getLeft(), IDifferenceEngine.class.getName());
                    if (differ != null) {
                        differ.setTarget(CompareResourceDefinitionEditor.this.input.getRight());
                        List<CompareResult> diff = differ.diff(CompareResourceDefinitionEditor.this.getChecksumType());
                        if (!this.cancelled) {
                            CompareResourceDefinitionEditor.this.input.setResults(diff);
                            return Status.OK_STATUS;
                        }
                        return Status.CANCEL_STATUS;
                    }
                    return Status.CANCEL_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        };
        this.compareJob.addJobChangeListener(new IJobChangeListener(){

            public void aboutToRun(IJobChangeEvent event) {
            }

            public void awake(IJobChangeEvent event) {
            }

            public void done(IJobChangeEvent event) {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!CompareResourceDefinitionEditor.this.compareJob.getResult().equals(Status.CANCEL_STATUS)) {
                            if ((this).CompareResourceDefinitionEditor.this.input.getResults().size() == 0) {
                                MessageDialog.openInformation((Shell)CompareResourceDefinitionEditor.this.getSite().getShell(), (String)Messages.getString("CompareResourceDefinitionEditor.8"), (String)Messages.getString("CompareResourceDefinitionEditor.9"));
                                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)CompareResourceDefinitionEditor.this, true);
                            } else {
                                CompareResourceDefinitionEditor.this.fillToolbar();
                                (this).CompareResourceDefinitionEditor.this.structureTreeViewer.setInput((Object)CompareResourceDefinitionEditor.this.getEditorInput());
                            }
                        }
                    }
                });
            }

            public void running(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void sleeping(IJobChangeEvent event) {
            }
        });
        this.schedule(this.compareJob);
    }

    protected void schedule(Job aJob) {
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(aJob, 0L, true);
    }

    protected void addPartListener() {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.partListener = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference part) {
            }

            public void partBroughtToTop(IWorkbenchPartReference part) {
            }

            public void partClosed(IWorkbenchPartReference part) {
                if (CompareResourceDefinitionEditor.this.compareJob != null) {
                    CompareResourceDefinitionEditor.this.compareJob.cancel();
                }
            }

            public void partDeactivated(IWorkbenchPartReference part) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference part) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }
        };
        workbenchWindow.getPartService().addPartListener(this.partListener);
    }

    static String getLabelForCICSObject(ICICSObject obj) {
        String prettyName = CMUIUtilities.getDescriptiveTypeName((String)obj.getObjectType().getResourceTableName());
        return String.valueOf(prettyName) + " (" + obj.getName() + ")";
    }

    private void createBottomPanel(Composite parent) {
        this.compareEditorComposite = new Composite(parent, 0);
        this.compareEditorComposite.setLayout((Layout)new FillLayout(512));
        IEditorActionBarContributor actionBarContributor = this.getEditorSite().getActionBarContributor();
        if (actionBarContributor == null) {
            actionBarContributor = new EditorActionBarContributor();
            actionBarContributor.init(this.getEditorSite().getActionBars(), null);
        }
        this.propSheet = new CompareEditorPropertySheet(this.compareEditorComposite, actionBarContributor);
        if (this.input.getLeft() instanceof ICICSObject && this.input.getRight() instanceof ICICSObject) {
            ICICSObject leftObject = (ICICSObject)this.input.getLeft();
            ICICSObject rightObject = (ICICSObject)this.input.getRight();
            CompareResourceExplorerEditorInput compareInput = new CompareResourceExplorerEditorInput(this.input.getInputForResource(leftObject), this.input.getInputForResource(rightObject));
            this.propSheet.setInput(compareInput);
        }
    }

    public void setFocus() {
        this.topLevelForm.setFocus();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    protected String getChecksumType() {
        return this.checksumType;
    }

    protected void setChecksumType(String checksumType) {
        if (!this.checksumType.equals(checksumType)) {
            this.checksumType = checksumType;
            this.schedule(this.compareJob);
        }
    }

    class CompareSelectionListener
    implements ISelectionChangedListener {
        CompareSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection ss;
            if (!event.getSelection().isEmpty() && event.getSelection() instanceof IStructuredSelection && (ss = (IStructuredSelection)event.getSelection()).getFirstElement() instanceof CompareResult) {
                CompareResult result = (CompareResult)ss.getFirstElement();
                if (result.getLeft() instanceof ICICSObject) {
                    ICICSObject leftObj = (ICICSObject)result.getLeft();
                    ICICSObject rightObj = (ICICSObject)result.getRight();
                    IExplorerEditorInput leftInput = CompareResourceDefinitionEditor.this.input.getInputForResource(leftObj);
                    IExplorerEditorInput rightInput = CompareResourceDefinitionEditor.this.input.getInputForResource(rightObj);
                    if (rightObj != null) {
                        CompareResourceDefinitionEditor.this.propSheet.setInput(new CompareResourceExplorerEditorInput(leftInput, rightInput));
                        Object obj = result.getDifferingObject();
                        if (obj instanceof ICICSAttribute) {
                            CompareResourceDefinitionEditor.this.propSheet.selectAttribute((ICICSAttribute)obj);
                        }
                    }
                } else if (result.getLeft() instanceof ResourceDefinitionGroup) {
                    if (result.getType() == CompareResult.DifferenceType.CHANGED && result instanceof StructureCompareResult) {
                        CompareResult firstChild = ((StructureCompareResult)result).getChildren().get(0);
                        if (firstChild != null) {
                            ICICSObject leftObj = (ICICSObject)firstChild.getLeft();
                            ICICSObject rightObj = (ICICSObject)firstChild.getRight();
                            if (leftObj != null) {
                                IExplorerEditorInput leftInput = CompareResourceDefinitionEditor.this.input.getInputForResource(leftObj);
                                IExplorerEditorInput rightInput = CompareResourceDefinitionEditor.this.input.getInputForResource(rightObj);
                                CompareResourceDefinitionEditor.this.propSheet.setInput(new CompareResourceExplorerEditorInput(leftInput, rightInput));
                            }
                        }
                    } else if (result.getType() == CompareResult.DifferenceType.ABSENT_FROM_LEFT) {
                        ICICSObject obj = (ICICSObject)result.getDifferingObject();
                        IExplorerEditorInput leftInput = CompareResourceDefinitionEditor.this.input.getInputForResource(obj);
                        CompareResourceDefinitionEditor.this.propSheet.setInput(new CompareResourceExplorerEditorInput(null, leftInput));
                    } else if (result.getType() == CompareResult.DifferenceType.ABSENT_FROM_RIGHT) {
                        ICICSObject obj = (ICICSObject)result.getDifferingObject();
                        IExplorerEditorInput rightInput = CompareResourceDefinitionEditor.this.input.getInputForResource(obj);
                        CompareResourceDefinitionEditor.this.propSheet.setInput(new CompareResourceExplorerEditorInput(rightInput, null));
                    }
                }
            }
        }
    }
}

