/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.compare.ui;

import com.ibm.cics.cm.compare.ui.CompareResourceExplorerEditorInput;
import com.ibm.cics.cm.compare.ui.DualDescriptor;
import com.ibm.cics.core.ui.editors.IExplorerEditorInput;
import com.ibm.cics.model.ICICSAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class CompareEditorContentProvider
implements ITreeContentProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    CompareResourceExplorerEditorInput editorInput = null;

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.editorInput = (CompareResourceExplorerEditorInput)newInput;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof CompareResourceExplorerEditorInput) {
            return this.getFullTree((CompareResourceExplorerEditorInput)parentElement).toArray();
        }
        if (parentElement instanceof CompareTreeCategory) {
            return ((CompareTreeCategory)parentElement).getDescriptors().toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof CompareTreeCategory && this.getChildren(element).length > 0;
    }

    public DualDescriptor getDualDescriptorForAttribute(ICICSAttribute<?> att) {
        Map<ICICSAttribute<?>, IPropertyDescriptor> leftDescriptorMap = this.convertDescriptorsToIdMap(this.editorInput.getLeftInput().getPropertyDescriptors());
        Map<ICICSAttribute<?>, IPropertyDescriptor> rightDescriptorMap = this.convertDescriptorsToIdMap(this.editorInput.getRightInput().getPropertyDescriptors());
        DualDescriptor dualDesc = new DualDescriptor();
        if (leftDescriptorMap != null && rightDescriptorMap != null) {
            if (leftDescriptorMap.containsKey(att)) {
                dualDesc.setLeftDescriptor(leftDescriptorMap.get(att));
            }
            if (rightDescriptorMap.containsKey(att)) {
                dualDesc.setRightDescriptor(rightDescriptorMap.get(att));
            }
        }
        return dualDesc;
    }

    private List<CompareTreeCategory> getFullTree(CompareResourceExplorerEditorInput editorInput) {
        IExplorerEditorInput leftInput = editorInput.getLeftInput();
        IExplorerEditorInput rightInput = editorInput.getRightInput();
        Collection<String> categories = this.getAllCategories(leftInput, rightInput);
        ArrayList<CompareTreeCategory> categoryItems = new ArrayList<CompareTreeCategory>();
        for (String category : categories) {
            categoryItems.add(new CompareTreeCategory(category, this.getDescriptorsForCategory(category, leftInput != null ? leftInput.getPropertyDescriptors() : null, rightInput != null ? rightInput.getPropertyDescriptors() : null)));
        }
        return categoryItems;
    }

    private Collection<DualDescriptor> getDescriptorsForCategory(String category, Collection<IPropertyDescriptor> leftDescriptors, Collection<IPropertyDescriptor> rightDescriptors) {
        DualDescriptor dualDesc;
        ArrayList<DualDescriptor> dualDescriptors = new ArrayList<DualDescriptor>();
        Map<ICICSAttribute<?>, IPropertyDescriptor> leftDescriptorMap = this.convertDescriptorsToIdMap(leftDescriptors);
        Map<ICICSAttribute<?>, IPropertyDescriptor> rightDescriptorMap = this.convertDescriptorsToIdMap(rightDescriptors);
        for (Map.Entry<ICICSAttribute<?>, IPropertyDescriptor> leftEntry : leftDescriptorMap.entrySet()) {
            if (!leftEntry.getValue().getCategory().equals(category)) continue;
            dualDesc = new DualDescriptor();
            dualDescriptors.add(dualDesc);
            dualDesc.setLeftDescriptor(leftEntry.getValue());
            IPropertyDescriptor rightDesc = rightDescriptorMap.get(leftEntry.getKey());
            if (rightDesc == null) continue;
            dualDesc.setRightDescriptor(rightDesc);
            rightDescriptorMap.remove(leftEntry.getKey());
        }
        for (Map.Entry<ICICSAttribute<?>, IPropertyDescriptor> rightEntry : rightDescriptorMap.entrySet()) {
            if (!rightEntry.getValue().getCategory().equals(category)) continue;
            dualDesc = new DualDescriptor();
            dualDescriptors.add(dualDesc);
            dualDesc.setRightDescriptor(rightEntry.getValue());
        }
        return dualDescriptors;
    }

    private Map<ICICSAttribute<?>, IPropertyDescriptor> convertDescriptorsToIdMap(Collection<IPropertyDescriptor> descriptors) {
        HashMap map = new HashMap();
        if (descriptors != null) {
            for (IPropertyDescriptor descriptor : descriptors) {
                map.put((ICICSAttribute)descriptor.getId(), descriptor);
            }
        }
        return map;
    }

    private Collection<String> getAllCategories(IExplorerEditorInput leftInput, IExplorerEditorInput rightInput) {
        HashSet<String> categories = new HashSet<String>();
        IExplorerEditorInput input = leftInput != null ? leftInput : rightInput;
        for (IPropertyDescriptor desc : input.getPropertyDescriptors()) {
            categories.add(desc.getCategory());
        }
        return categories;
    }

    public class CompareTreeCategory {
        static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private String category;
        private Collection<DualDescriptor> descriptors;

        public CompareTreeCategory(String category, Collection<DualDescriptor> descriptors) {
            this.category = category;
            this.descriptors = descriptors;
        }

        public String getCategory() {
            return this.category;
        }

        public Collection<DualDescriptor> getDescriptors() {
            return this.descriptors;
        }
    }
}

