/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.compare.model;

import com.ibm.cics.cm.compare.model.CompareResult;
import com.ibm.cics.cm.compare.model.DetailCompareResult;
import com.ibm.cics.cm.compare.model.DifferenceEngine;
import com.ibm.cics.cm.compare.model.IDifferenceEngine;
import com.ibm.cics.cm.compare.model.StructureCompareResult;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.cm.model.ResourceList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;

final class ResourceListDifferenceEngine
extends DifferenceEngine {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    ResourceListDifferenceEngine(ResourceList base) {
        super(base);
    }

    @Override
    public List<CompareResult> diff(String checksumType) {
        ResourceDefinitionGroup resourceDefinitionGroup;
        if (checksumType.equals("NONE")) {
            checksumType = "FULL";
        }
        ResourceList left = (ResourceList)this.base;
        ResourceList right = (ResourceList)this.target;
        ArrayList<CompareResult> results = new ArrayList<CompareResult>();
        IFilteredCollection rightFiltered = right.getResourceGroupsWithChecksum(checksumType);
        Map<String, ResourceDefinitionGroup> rightMap = this.asMap((IFilteredCollection<ResourceDefinitionGroup>)rightFiltered);
        IFilteredCollection leftFiltered = left.getResourceGroupsWithChecksum(checksumType);
        Map<String, ResourceDefinitionGroup> leftMap = this.asMap((IFilteredCollection<ResourceDefinitionGroup>)leftFiltered);
        for (ResourceDefinitionGroup group : leftFiltered) {
            resourceDefinitionGroup = rightMap.get(group.getName());
            if (resourceDefinitionGroup != null) {
                IDifferenceEngine differ;
                if (!checksumType.equals("NONE") && group.getChecksum().equals(resourceDefinitionGroup.getChecksum()) || (differ = (IDifferenceEngine)Platform.getAdapterManager().loadAdapter((Object)group, IDifferenceEngine.class.getName())) == null) continue;
                differ.setTarget(resourceDefinitionGroup);
                List<CompareResult> groupResults = differ.diff(checksumType);
                if (groupResults.size() <= 0) continue;
                results.add(new StructureCompareResult(left, right, group, CompareResult.DifferenceType.CHANGED, groupResults));
                continue;
            }
            results.add(new DetailCompareResult(left, right, group, CompareResult.DifferenceType.ABSENT_FROM_RIGHT));
        }
        for (ResourceDefinitionGroup group : rightFiltered) {
            resourceDefinitionGroup = leftMap.get(group.getName());
            if (resourceDefinitionGroup != null) continue;
            results.add(new DetailCompareResult(left, right, group, CompareResult.DifferenceType.ABSENT_FROM_LEFT));
        }
        return results;
    }

    private Map<String, ResourceDefinitionGroup> asMap(IFilteredCollection<ResourceDefinitionGroup> leftFiltered) {
        HashMap<String, ResourceDefinitionGroup> map = new HashMap<String, ResourceDefinitionGroup>();
        for (ResourceDefinitionGroup resourceDefinitionGroup : leftFiltered) {
            map.put(resourceDefinitionGroup.getName(), resourceDefinitionGroup);
        }
        return map;
    }
}

