/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.compare.model;

import com.ibm.cics.cm.compare.model.CompareResult;
import com.ibm.cics.cm.compare.model.DetailCompareResult;
import com.ibm.cics.cm.compare.model.DifferenceEngine;
import com.ibm.cics.core.ui.properties.CICSObjectPropertyDescriptor;
import com.ibm.cics.core.ui.properties.CICSObjectPropertySource;
import com.ibm.cics.core.ui.properties.IAttributePropertyDescriptor;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSObject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class CICSDefinitionDifferenceEngine
extends DifferenceEngine {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    CICSDefinitionDifferenceEngine(ICICSObject base) {
        super(base);
    }

    @Override
    public List<CompareResult> diff(String checksumType) {
        DetailCompareResult result;
        Object rightValue;
        Object leftValue;
        ICICSAttribute attr;
        IAttributePropertyDescriptor pd;
        ArrayList<CompareResult> results = new ArrayList<CompareResult>();
        IPropertySourceProvider provider = (IPropertySourceProvider)Platform.getAdapterManager().loadAdapter(this.base, IPropertySourceProvider.class.getName());
        CICSObjectPropertySource leftPropertySource = (CICSObjectPropertySource)provider.getPropertySource(this.base);
        CICSObjectPropertySource rightPropertySource = (CICSObjectPropertySource)provider.getPropertySource(this.target);
        IAttributePropertyDescriptor[] iAttributePropertyDescriptorArray = leftPropertySource.getPropertyDescriptors();
        int n = iAttributePropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            pd = iAttributePropertyDescriptorArray[n2];
            attr = ((CICSObjectPropertyDescriptor)pd).getAttribute();
            leftValue = leftPropertySource.getPropertyValue(pd.getId());
            rightValue = rightPropertySource.getPropertyValue(pd.getId());
            if (!(leftValue.equals(attr.getUnsupportedValue()) && rightValue.equals(attr.getUnsupportedValue()) || leftValue == null && rightValue == null)) {
                if (leftValue.equals(attr.getUnsupportedValue())) {
                    result = new DetailCompareResult(this.base, this.target, attr, CompareResult.DifferenceType.ABSENT_FROM_LEFT);
                    results.add(result);
                } else if (rightValue != null && !rightValue.equals(attr.getUnsupportedValue())) {
                    if (!leftValue.equals(rightValue)) {
                        result = new DetailCompareResult(this.base, this.target, attr, CompareResult.DifferenceType.CHANGED);
                        results.add(result);
                    }
                } else {
                    result = new DetailCompareResult(this.base, this.target, attr, CompareResult.DifferenceType.ABSENT_FROM_RIGHT);
                    results.add(result);
                }
            }
            ++n2;
        }
        iAttributePropertyDescriptorArray = rightPropertySource.getPropertyDescriptors();
        n = iAttributePropertyDescriptorArray.length;
        n2 = 0;
        while (n2 < n) {
            pd = iAttributePropertyDescriptorArray[n2];
            attr = ((CICSObjectPropertyDescriptor)pd).getAttribute();
            leftValue = leftPropertySource.getPropertyValue(pd.getId());
            rightValue = rightPropertySource.getPropertyValue(pd.getId());
            if (!(leftValue.equals(attr.getUnsupportedValue()) && rightValue.equals(attr.getUnsupportedValue()) || leftValue == null && rightValue == null || leftValue != null)) {
                result = new DetailCompareResult(this.base, this.target, attr, CompareResult.DifferenceType.ABSENT_FROM_LEFT);
                results.add(result);
            }
            ++n2;
        }
        return results;
    }
}

