/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.comm;

import com.ibm.cics.cm.comm.CMConstants;
import com.ibm.cics.cm.comm.CMDetails;
import com.ibm.cics.cm.comm.ICMContext;
import com.ibm.cics.cm.comm.IHistoryContext;
import com.ibm.cics.sm.comm.Debug;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.INormalizer;
import com.ibm.cics.sm.comm.NormalizationException;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CMConnectionRecord
extends SMConnectionRecord
implements CMConstants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String TIMEZONE_PAD = "+0000";
    private static final Map<String, INormalizer> NORMALIZERS = new HashMap<String, INormalizer>();
    private static Logger logger = Logger.getLogger("com.ibm.cics.cm.comm");
    private String name;
    private Map<String, String> attributes;
    private boolean isLightweight = true;
    private CMDetails cmDetails;
    private Overrides releaseOverrides;

    static {
        INormalizer dateNormalizer = new INormalizer(){

            public String normalize(String denormalizedValue) throws NormalizationException {
                if (denormalizedValue == null) {
                    if (Debug.DEBUG_RECORD) {
                        logger.logp(Level.FINER, this.getClass().getName(), "normalize", "No date normalization was performed on null input");
                    }
                    return denormalizedValue;
                }
                if ("yyyy-MM-dd'T'HH:mm:ss.SSSZ".endsWith("Z")) {
                    StringBuilder temp = new StringBuilder(denormalizedValue.replace('/', '-').replace(' ', 'T'));
                    temp.append('0');
                    temp.append(CMConnectionRecord.TIMEZONE_PAD);
                    return temp.toString();
                }
                return denormalizedValue;
            }

            public String denormalize(String normalizedValue) throws NormalizationException {
                if (normalizedValue == null) {
                    logger.logp(Level.WARNING, this.getClass().getName(), "denormalize", "Can't perform normalization on null input");
                    return normalizedValue;
                }
                if ("yyyy-MM-dd'T'HH:mm:ss.SSSZ".endsWith("Z")) {
                    return normalizedValue.substring(0, 23);
                }
                return normalizedValue;
            }
        };
        NORMALIZERS.put("DATE_NORMALIZER_KEY", dateNormalizer);
    }

    public Map<String, INormalizer> getNormalizers() {
        return NORMALIZERS;
    }

    public Iterator iterator() {
        return this.attributes.keySet().iterator();
    }

    public CMConnectionRecord(Map<String, String> attributes, Overrides releaseOverrides, IContext context) {
        super(attributes.get("TYPE"), context);
        this.attributes = attributes;
        this.name = attributes.get("NAME");
        if (this.name == null) {
            this.name = attributes.get("CPID");
        }
        this.releaseOverrides = releaseOverrides;
    }

    public void setCMDetails(CMDetails aCMDetails) {
        this.cmDetails = aCMDetails;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getName() {
        return this.name;
    }

    public String get(String attribute) {
        if (this.releaseOverrides != null) {
            String overriddenAttribute = this.releaseOverrides.getCMAttribute(attribute);
            if (overriddenAttribute != null) {
                return this.attributes.get(overriddenAttribute);
            }
            return this.releaseOverrides.getOverride(attribute);
        }
        return this.attributes.get(attribute);
    }

    public String toExternalForm() {
        return this.attributes.toString();
    }

    public IContext getBaseContext() {
        if (this.context instanceof ICMContext || this.context instanceof IHistoryContext) {
            return this.context;
        }
        return super.getBaseContext();
    }

    public static interface Overrides {
        public static final int NEVER = -1;
        public static final int ALWAYS = -2;

        public String getOverride(String var1);

        public String getCMAttribute(String var1);
    }
}

