/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.utilities;

import com.ibm.cics.cm.model.CPSMConfiguration;
import com.ibm.cics.cm.model.CSDConfiguration;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ConfigurationConnection;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.utilities.FetchingContentProposal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

public class ConfigurationContentProposalProvider
implements IContentProposalProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    Thread fetchingThread;
    List<Listener> listeners = new ArrayList<Listener>();
    Configuration[] configurations;

    public void addListener(Listener aListener) {
        this.listeners.add(aListener);
    }

    public void remoteListener(Listener aListener) {
        this.listeners.remove(aListener);
    }

    public IContentProposal[] getProposals(String contents, int position) {
        if (this.configurations == null) {
            if (this.fetchingThread == null) {
                this.fetchingThread = new Thread(){

                    @Override
                    public void run() {
                        ConfigurationContentProposalProvider.this.configurations = ConfigurationContentProposalProvider.this.getConfigurations();
                        for (Listener aListener : ConfigurationContentProposalProvider.this.listeners) {
                            aListener.dataAvailable();
                        }
                    }
                };
                this.fetchingThread.start();
            }
            return new IContentProposal[]{FetchingContentProposal.getSingleton()};
        }
        this.configurations = this.getConfigurations();
        ArrayList<2> result = new ArrayList<2>(this.configurations.length);
        Configuration[] configurationArray = this.configurations;
        int n = this.configurations.length;
        int n2 = 0;
        while (n2 < n) {
            Configuration configuration = configurationArray[n2];
            final Configuration config = configuration;
            if (config.getName().startsWith(contents)) {
                IContentProposal proposal = new IContentProposal(){

                    public String getContent() {
                        return config.getName();
                    }

                    public int getCursorPosition() {
                        return config.getName().length();
                    }

                    public String getDescription() {
                        String returnString = "";
                        if (config instanceof CSDConfiguration) {
                            returnString = String.valueOf(returnString) + Messages.getString("configuration.type.csd");
                            returnString = String.valueOf(returnString) + "\n";
                            returnString = String.valueOf(returnString) + "\n";
                        } else if (config instanceof CPSMConfiguration) {
                            returnString = String.valueOf(returnString) + Messages.getString("configuration.type.cpsm");
                            returnString = String.valueOf(returnString) + "\n";
                            returnString = String.valueOf(returnString) + "\n";
                        }
                        returnString = String.valueOf(returnString) + Messages.getString("configuration.name") + " " + config.getName();
                        String configDesc = config.getDescription();
                        if (configDesc == null || configDesc.isEmpty()) {
                            return null;
                        }
                        returnString = String.valueOf(returnString) + "\n";
                        returnString = String.valueOf(returnString) + Messages.getString("configuration.description") + " " + configDesc;
                        if (config instanceof CSDConfiguration) {
                            CSDConfiguration csdConfig = (CSDConfiguration)config;
                            returnString = String.valueOf(returnString) + "\n";
                            returnString = String.valueOf(returnString) + Messages.getString("configuration.csddatasetname") + " " + csdConfig.getCSDName();
                            returnString = String.valueOf(returnString) + "\n";
                            returnString = String.valueOf(returnString) + Messages.getString("configuration.csdconnections") + " ";
                            List conns = csdConfig.getConnections();
                            if (conns != null && !conns.isEmpty()) {
                                boolean first = true;
                                for (ConfigurationConnection conn : conns) {
                                    if (!first) {
                                        returnString = String.valueOf(returnString) + ", ";
                                    } else {
                                        first = false;
                                    }
                                    returnString = String.valueOf(returnString) + conn.getName();
                                }
                            } else {
                                returnString = String.valueOf(returnString) + Messages.getString("configuration.csdconnections.no");
                            }
                        } else if (config instanceof CPSMConfiguration) {
                            CPSMConfiguration cpsmConfig = (CPSMConfiguration)config;
                            returnString = String.valueOf(returnString) + "\n";
                            returnString = String.valueOf(returnString) + Messages.getString("configuration.cpsmcontext") + " " + cpsmConfig.getCPSMContext();
                        }
                        return returnString;
                    }

                    public String getLabel() {
                        return config.getName();
                    }
                };
                result.add(proposal);
            }
            ++n2;
        }
        Collections.sort(result, new ConfigurationProposalComparator());
        return result.toArray(new IContentProposal[0]);
    }

    private Configuration[] getConfigurations() {
        IFilteredCollection configurationsList;
        HashMap<String, Configuration> configurations = new HashMap<String, Configuration>();
        if (ConfigurationManager.getCurrent().getConnection() != null && ConfigurationManager.getCurrent().getConnection().isConnected() && (configurationsList = ConfigurationManager.getCurrent().getConfigurations()) != null && configurationsList.size() > 0) {
            for (Configuration configuration : configurationsList.getResults()) {
                if (!(configuration instanceof CSDConfiguration) && !(configuration instanceof CPSMConfiguration)) continue;
                configurations.put(configuration.getName(), configuration);
            }
        }
        return configurations.values().toArray(new Configuration[0]);
    }

    private class ConfigurationProposalComparator
    implements Comparator<IContentProposal> {
        private ConfigurationProposalComparator() {
        }

        @Override
        public int compare(IContentProposal prop0, IContentProposal prop1) {
            return prop0.getLabel().compareTo(prop1.getLabel());
        }
    }

    public static interface Listener {
        public void dataAvailable();
    }
}

