/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.utilities;

import com.ibm.cics.cm.model.CSDConnection;
import com.ibm.cics.cm.model.runtime.CMServerListException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.ListMessageResponse;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.utilities.FetchingContentProposal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

public class CSDConnectionContentProposalProvider
implements IContentProposalProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2023 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    Thread fetchingThread;
    List<Listener> listeners = new ArrayList<Listener>();
    CSDConnection[] connections;
    List<String> excludeConnectionNames;

    public CSDConnectionContentProposalProvider(List<String> excludeConnectionNames) {
        this.excludeConnectionNames = excludeConnectionNames;
    }

    public void addListener(Listener aListener) {
        this.listeners.add(aListener);
    }

    public void remoteListener(Listener aListener) {
        this.listeners.remove(aListener);
    }

    public IContentProposal[] getProposals(String contents, int position) {
        if (this.connections == null) {
            if (this.fetchingThread == null) {
                this.fetchingThread = new Thread(){

                    @Override
                    public void run() {
                        CSDConnectionContentProposalProvider.this.connections = CSDConnectionContentProposalProvider.this.getConnections();
                        for (Listener aListener : CSDConnectionContentProposalProvider.this.listeners) {
                            aListener.dataAvailable();
                        }
                    }
                };
                this.fetchingThread.start();
            }
            return new IContentProposal[]{FetchingContentProposal.getSingleton()};
        }
        this.connections = this.getConnections();
        ArrayList<2> result = new ArrayList<2>(this.connections.length);
        CSDConnection[] cSDConnectionArray = this.connections;
        int n = this.connections.length;
        int n2 = 0;
        while (n2 < n) {
            CSDConnection csdConnection = cSDConnectionArray[n2];
            final CSDConnection conn = csdConnection;
            if (conn.getName().startsWith(contents) && this.excludeConnectionNames != null && !this.excludeConnectionNames.contains(conn.getName())) {
                IContentProposal proposal = new IContentProposal(){

                    public String getContent() {
                        return conn.getName();
                    }

                    public int getCursorPosition() {
                        return 0;
                    }

                    public String getDescription() {
                        String returnString = String.valueOf(Messages.getString("csd.connection.name")) + " " + conn.getName();
                        List connDescs = conn.getDescriptions();
                        if (connDescs == null || connDescs.isEmpty()) {
                            return null;
                        }
                        returnString = String.valueOf(returnString) + "\n";
                        returnString = String.valueOf(returnString) + "\n";
                        returnString = connDescs.size() > 1 ? String.valueOf(returnString) + Messages.getString("csd.connection.descriptions") : String.valueOf(returnString) + Messages.getString("csd.connection.description");
                        for (String desc : connDescs) {
                            returnString = String.valueOf(returnString) + "\n" + desc;
                        }
                        return returnString;
                    }

                    public String getLabel() {
                        return conn.getName();
                    }
                };
                result.add(proposal);
            }
            ++n2;
        }
        Collections.sort(result, new ConnectionProposalComparator());
        return result.toArray(new IContentProposal[0]);
    }

    private CSDConnection[] getConnections() {
        HashMap<String, CSDConnection> conns = new HashMap<String, CSDConnection>();
        try {
            ListMessageResponse messageResponse = ConfigurationManager.getCurrent().getRemoteConnections("DESCRIPTION");
            for (Map map : messageResponse) {
                String connName = (String)map.get("NAME");
                String connDesc = (String)map.get("DESCRIPTION");
                CSDConnection conn = (CSDConnection)conns.get(connName);
                if (conn == null) {
                    if (connName == null || connName.trim().isEmpty()) continue;
                    if (connDesc != null && !connDesc.trim().isEmpty()) {
                        conns.put(connName, new CSDConnection(connName, connDesc));
                        continue;
                    }
                    conns.put(connName, new CSDConnection(connName));
                    continue;
                }
                if (connDesc == null || connDesc.trim().isEmpty()) continue;
                conn.addDescription(connDesc);
            }
        }
        catch (CMServerListException cMServerListException) {
            // empty catch block
        }
        return conns.values().toArray(new CSDConnection[0]);
    }

    private class ConnectionProposalComparator
    implements Comparator<IContentProposal> {
        private ConnectionProposalComparator() {
        }

        @Override
        public int compare(IContentProposal prop0, IContentProposal prop1) {
            return prop0.getLabel().compareTo(prop1.getLabel());
        }
    }

    public static interface Listener {
        public void dataAvailable();
    }
}

