/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.utilities;

import com.ibm.cics.cm.model.CPSMConfiguration;
import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.sm.comm.Context;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

public class CICSPlexScopeContentProposalProvider
implements IContentProposalProvider,
Constants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    Thread fetchingThread;
    List<Listener> listeners = new ArrayList<Listener>();
    private CPSMConfiguration configuration;

    public void addListener(Listener aListener) {
        this.listeners.add(aListener);
    }

    public void remoteListener(Listener aListener) {
        this.listeners.remove(aListener);
    }

    public IContentProposal[] getProposals(String contents, int position) {
        if (this.configuration != null && ConfigurationManager.getCurrent().getConnection() != null && ConfigurationManager.getCurrent().getConnection().isConnected()) {
            try {
                Context context = new Context(this.configuration.getPlexName());
                ArrayList<1> result = new ArrayList<1>();
                SMConnectionResponse fetchResponse = ConfigurationManager.getCurrent().getICMSMConnection().getResources("CSYSDEF", (IContext)context);
                int i = 0;
                while (i < fetchResponse.getRecordTotal()) {
                    final String cicsName = fetchResponse.getRecord(i).get("NAME");
                    final String applID = fetchResponse.getRecord(i).get("APPLID");
                    if (cicsName.startsWith(contents)) {
                        IContentProposal proposal = new IContentProposal(){

                            public String getContent() {
                                return cicsName;
                            }

                            public int getCursorPosition() {
                                return cicsName.length();
                            }

                            public String getDescription() {
                                return null;
                            }

                            public String getLabel() {
                                return String.valueOf(cicsName) + " (" + applID + ")";
                            }
                        };
                        result.add(proposal);
                    }
                    ++i;
                }
                Collections.sort(result, new CICSPlexScopeProposalComparator());
                return result.toArray(new IContentProposal[0]);
            }
            catch (ConnectionException ce) {
                System.out.println(ce.getMessage());
            }
        }
        return new IContentProposal[0];
    }

    public void setConfiguration(CPSMConfiguration configuration) {
        this.configuration = configuration;
    }

    private class CICSPlexScopeProposalComparator
    implements Comparator<IContentProposal> {
        private CICSPlexScopeProposalComparator() {
        }

        @Override
        public int compare(IContentProposal prop0, IContentProposal prop1) {
            return prop0.getLabel().compareTo(prop1.getLabel());
        }
    }

    public static interface Listener {
        public void dataAvailable();
    }
}

