/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.zfs;

import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.model.runtime.CMServerListException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.ListMessageResponse;
import com.ibm.cics.cm.model.runtime.LocationCriteria;
import com.ibm.cics.cm.model.runtime.ObjectCriteria;
import com.ibm.cics.cm.model.runtime.RestrictionCriteria;
import com.ibm.cics.cm.model.runtime.RestrictionCriteriaList;
import com.ibm.cics.cm.ui.ImageFactory;
import com.ibm.cics.cm.ui.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ZfsNode {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static ObjectCriteria objectCriteria = ObjectCriteria.newZfsListCriteria();
    private final ZfsNodeType type;
    private final String path;
    private final ZfsNode parent;
    private final LocationCriteria locationCriteria;
    private final TreeViewer viewer;
    private final boolean absoluteDirectoryPath;
    private final List<ZfsNode> children = new ArrayList<ZfsNode>();

    public ZfsNode(TreeViewer viewer, String path, String configName, boolean directoryOnly) {
        this.parent = null;
        this.path = null;
        this.locationCriteria = LocationCriteria.newConfigurationLocationCriteria((String)configName);
        this.type = ZfsNodeType.ROOT;
        this.viewer = viewer;
        this.absoluteDirectoryPath = directoryOnly;
        this.children.add(new ZfsNode(path, ZfsNodeType.DIR, this));
    }

    public ZfsNode(String path, ZfsNodeType type, ZfsNode parent) {
        this.parent = parent;
        this.path = path;
        this.locationCriteria = parent.locationCriteria;
        this.type = type;
        this.viewer = parent.viewer;
        this.absoluteDirectoryPath = parent.absoluteDirectoryPath;
        if (type == ZfsNodeType.DIR && this.getFullPath().length() < 254) {
            this.children.add(new ZfsNode(Messages.getString("FetchingContentProposal.fetching"), ZfsNodeType.FETCHING, this));
        }
    }

    public void error(String message) {
        this.children.add(new ZfsNode(message, ZfsNodeType.ERROR, this));
    }

    public boolean isDirectory() {
        return this.type == ZfsNodeType.DIR;
    }

    public boolean isReal() {
        return this.type == ZfsNodeType.DIR || this.type == ZfsNodeType.FILE;
    }

    public boolean isSelectable() {
        return this.parent.type != ZfsNodeType.ROOT || this.absoluteDirectoryPath;
    }

    public String toString() {
        return this.path;
    }

    public Image getImage() {
        switch (this.type) {
            case DIR: {
                return ImageFactory.getFolderImage();
            }
            case FILE: {
                return ImageFactory.getFileImage();
            }
            case ERROR: {
                return ImageFactory.getErrorImage();
            }
        }
        return null;
    }

    public String getFullPath() {
        return this.getFullPath(this.absoluteDirectoryPath);
    }

    public String getFullPath(boolean leadingAndTrailingSlash) {
        if (this.type == ZfsNodeType.ROOT) {
            return "";
        }
        if (this.parent.type == ZfsNodeType.ROOT) {
            return leadingAndTrailingSlash ? this.path : "";
        }
        String parentPath = this.parent.getFullPath(leadingAndTrailingSlash);
        return String.valueOf(parentPath) + (leadingAndTrailingSlash || parentPath.isEmpty() ? "" : "/") + this.path + (leadingAndTrailingSlash ? "/" : "");
    }

    public ZfsNode getParent() {
        return this.parent;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public List<ZfsNode> getChildren() {
        if (!this.children.isEmpty() && this.children.get((int)0).type == ZfsNodeType.FETCHING) {
            final ZfsNode parent = this;
            Job job = new Job(""){

                protected IStatus run(IProgressMonitor monitor) {
                    String relativePath;
                    RestrictionCriteriaList restrictionCriteriaList = null;
                    if (ZfsNode.this.absoluteDirectoryPath) {
                        restrictionCriteriaList = new RestrictionCriteriaList();
                        restrictionCriteriaList.add(new RestrictionCriteria("FILETYPE", FilterExpression.Operator.EQ, "DIR"));
                    }
                    if (!(relativePath = parent.getFullPath(false)).isEmpty()) {
                        if (restrictionCriteriaList == null) {
                            restrictionCriteriaList = new RestrictionCriteriaList();
                        }
                        restrictionCriteriaList.add(new RestrictionCriteria("RELATIVEPATH", FilterExpression.Operator.EQ, relativePath));
                    }
                    try {
                        ListMessageResponse response = ConfigurationManager.getCurrent().getList(ZfsNode.this.locationCriteria, objectCriteria, restrictionCriteriaList);
                        Iterator iterator = response.getObjects();
                        ArrayList<String> names = new ArrayList<String>();
                        HashMap<String, ZfsNode> nodes = new HashMap<String, ZfsNode>();
                        while (iterator.hasNext()) {
                            Map next = (Map)iterator.next();
                            String name = (String)next.get("FILENAME");
                            names.add(name);
                            nodes.put(name, new ZfsNode(name, "DIR".equals(next.get("FILETYPE")) ? ZfsNodeType.DIR : ZfsNodeType.FILE, parent));
                        }
                        Collections.sort(names);
                        for (String name : names) {
                            ZfsNode.this.children.add((ZfsNode)nodes.get(name));
                        }
                    }
                    catch (CMServerListException e) {
                        parent.error(e.getMessage());
                    }
                    ZfsNode.this.children.remove(0);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!ZfsNode.this.viewer.getTree().isDisposed()) {
                                int childCount = ZfsNode.this.children.size();
                                if (childCount > 0) {
                                    ZfsNode firstChild = (ZfsNode)ZfsNode.this.children.get(0);
                                    ZfsNode.this.viewer.replace((Object)parent, 0, (Object)firstChild);
                                    ZfsNode.this.viewer.setChildCount((Object)firstChild, firstChild.getChildCount());
                                }
                                ZfsNode.this.viewer.setChildCount((Object)parent, childCount);
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
        return this.children;
    }

    private static enum ZfsNodeType {
        DIR,
        FILE,
        ROOT,
        FETCHING,
        ERROR;

    }
}

