/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.wizards;

import com.ibm.cics.cm.model.MigrationScheme;
import com.ibm.cics.cm.model.builder.MigrationSchemeBuilder;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.editors.MigrationSchemeEditorInput;
import com.ibm.cics.cm.ui.views.MigrationSchemesView;
import com.ibm.cics.cm.ui.wizards.NewMigrationSchemePage;
import com.ibm.cics.cm.ui.wizards.NoConnectionPage;
import java.text.MessageFormat;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class NewMigrationSchemeWizard
extends Wizard
implements INewWizard {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected NewMigrationSchemePage page = null;
    protected MigrationScheme newFromMigrationScheme = null;
    private boolean complete = false;
    private boolean openEditor = true;
    private boolean newFrom = false;
    private NoConnectionPage noConnectionPage;

    public NewMigrationSchemeWizard() {
        this.setWindowTitle(Messages.getString("MigrationSchemeWizard.new"));
    }

    public NewMigrationSchemeWizard(MigrationScheme newFromMigrationScheme) {
        this.newFrom = true;
        this.newFromMigrationScheme = newFromMigrationScheme;
        this.setWindowTitle(MessageFormat.format(Messages.getString("MigrationSchemeWizard.newfrom"), newFromMigrationScheme.getName()));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        if (ConfigurationManager.getCurrent().getConnection() == null || !ConfigurationManager.getCurrent().getConnection().isConnected()) {
            this.noConnectionPage = new NoConnectionPage();
            this.addPage((IWizardPage)this.noConnectionPage);
        } else {
            this.page = this.newFrom ? new NewMigrationSchemePage(this.newFromMigrationScheme) : new NewMigrationSchemePage();
            this.addPage((IWizardPage)this.page);
        }
    }

    public boolean canFinish() {
        return this.complete;
    }

    public boolean performFinish() {
        MigrationScheme scheme;
        this.executeFinish();
        final MigrationSchemesView migrationSchemesView = UIActivator.getMigrationSchemesView();
        if (migrationSchemesView != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    migrationSchemesView.refresh(false);
                    IWorkbenchPartSite wPartSite = migrationSchemesView.getSite();
                    if (wPartSite != null && wPartSite instanceof IViewSite) {
                        ((IViewSite)wPartSite).getActionBars().getStatusLineManager().setMessage(null);
                    }
                }
            });
        }
        if (this.openEditor && (scheme = ConfigurationManager.getCurrent().getMigrationScheme(this.page.getMigrationSchemeName())) != null) {
            MigrationSchemeEditorInput input = new MigrationSchemeEditorInput(scheme);
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, "com.ibm.cics.cm.ui.scheme.editor");
            }
            catch (PartInitException pie) {
                throw new RuntimeException(pie);
            }
        }
        return true;
    }

    public boolean needsPreviousAndNextButtons() {
        return false;
    }

    protected void setCanFinish(boolean finish) {
        this.complete = finish;
    }

    protected void setOpenEditor(boolean open) {
        this.openEditor = open;
    }

    private void executeFinish() {
        MigrationSchemeBuilder builder = new MigrationSchemeBuilder();
        builder.setName(this.page.getMigrationSchemeName());
        builder.setDescription(this.page.getMigrationSchemeDescription());
        builder.setApproval(this.page.getApproval());
        builder.setMigrationPaths(this.page.getMigrationPaths());
        builder.setTransformationVariables(this.page.getTransformationVariables());
        builder.create(ConfigurationManager.getCurrent());
    }
}

