/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.wizards;

import com.ibm.cics.cm.model.CSDConfiguration;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.builder.ConfigurationBuilder;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.editors.ConfigurationEditorInput;
import com.ibm.cics.cm.ui.views.ConfigurationsView;
import com.ibm.cics.cm.ui.wizards.NewConfigurationPage;
import com.ibm.cics.cm.ui.wizards.NoConnectionPage;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class NewConfigurationWizard
extends Wizard
implements INewWizard {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected NewConfigurationPage basicPage = null;
    protected ConfigurationType configType = ConfigurationType.NOT_SELECTED;
    protected Configuration newFromConfiguration = null;
    private boolean complete = false;
    private boolean openEditor = true;
    private boolean newFrom = false;
    private NoConnectionPage noConnectionPage;

    public NewConfigurationWizard() {
        this.setWindowTitle(Messages.getString("ConfigurationWizard.new"));
    }

    public NewConfigurationWizard(Configuration newFromConfiguration) {
        this.newFrom = true;
        this.newFromConfiguration = newFromConfiguration;
        this.setWindowTitle(MessageFormat.format(Messages.getString("ConfigurationWizard.newfrom"), newFromConfiguration.getName()));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        if (ConfigurationManager.getCurrent().getConnection() == null || !ConfigurationManager.getCurrent().getConnection().isConnected()) {
            this.noConnectionPage = new NoConnectionPage();
            this.addPage((IWizardPage)this.noConnectionPage);
        } else {
            this.basicPage = this.newFrom ? new NewConfigurationPage(this.newFromConfiguration) : new NewConfigurationPage();
            this.addPage((IWizardPage)this.basicPage);
        }
    }

    public boolean canFinish() {
        return this.complete;
    }

    public boolean performFinish() {
        this.executeFinish();
        if (this.canFinish()) {
            Configuration config;
            final ConfigurationsView configurationsView = UIActivator.getConfigurationsView();
            if (configurationsView != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        configurationsView.refresh(false);
                        IWorkbenchPartSite wPartSite = configurationsView.getSite();
                        if (wPartSite != null && wPartSite instanceof IViewSite) {
                            ((IViewSite)wPartSite).getActionBars().getStatusLineManager().setMessage(null);
                        }
                    }
                });
            }
            if (this.openEditor && (config = ConfigurationManager.getCurrent().getConfiguration(this.basicPage.getConfigName())) != null) {
                ConfigurationEditorInput input = new ConfigurationEditorInput(config);
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, "com.ibm.cics.cm.ui.config.editor");
                }
                catch (PartInitException pie) {
                    throw new RuntimeException(pie);
                }
            }
            return true;
        }
        return false;
    }

    public boolean needsPreviousAndNextButtons() {
        return false;
    }

    protected boolean isCPSM() {
        return this.configType == ConfigurationType.CPSM;
    }

    protected boolean isCSD() {
        return this.configType == ConfigurationType.CSD;
    }

    protected boolean isZFS() {
        return this.configType == ConfigurationType.ZFS;
    }

    protected void setCanFinish(boolean finish) {
        this.complete = finish;
    }

    protected void setConfigurationType(ConfigurationType configType) {
        this.configType = configType;
    }

    protected void setOpenEditor(boolean open) {
        this.openEditor = open;
    }

    private void executeFinish() {
        block17: {
            if (this.isCPSM()) {
                ConfigurationBuilder conf = new ConfigurationBuilder(this.basicPage.getConfigName(), this.basicPage.getConfigCPSMContext());
                conf.setDescription(this.basicPage.getConfigDescription());
                if (this.newFrom) {
                    conf.setTransformationVariables((Map)this.newFromConfiguration.getTransformationVariables());
                }
                try {
                    conf.create(ConfigurationManager.getCurrent());
                }
                catch (CMServerException e) {
                    if (e.isError()) {
                        this.basicPage.setServerError(e);
                    }
                    break block17;
                }
            }
            if (this.isCSD()) {
                ConfigurationBuilder conf = new ConfigurationBuilder(this.basicPage.getConfigName(), this.basicPage.getConfigCSDName(), this.basicPage.getConfigCSDRLS());
                conf.setDescription(this.basicPage.getConfigDescription());
                if (this.newFrom) {
                    if (this.newFromConfiguration instanceof CSDConfiguration) {
                        conf.setMROLinks(((CSDConfiguration)this.newFromConfiguration).getMROlinks());
                    }
                    conf.setTransformationVariables((Map)this.newFromConfiguration.getTransformationVariables());
                }
                try {
                    conf.create(ConfigurationManager.getCurrent());
                }
                catch (CMServerException e) {
                    if (e.isError()) {
                        this.basicPage.setServerError(e);
                    }
                    break block17;
                }
            }
            if (this.isZFS()) {
                String rootDir = this.basicPage.getConfigZfsName();
                if (!rootDir.endsWith("/")) {
                    rootDir = String.valueOf(rootDir) + "/";
                }
                boolean backup = this.basicPage.getConfigZfsBackup();
                String backupDir = this.basicPage.getConfigZfsBackupDir();
                if (backup && !backupDir.endsWith("/")) {
                    backupDir = String.valueOf(backupDir) + "/";
                }
                ConfigurationBuilder conf = new ConfigurationBuilder(this.basicPage.getConfigName(), rootDir, backup, this.basicPage.getConfigZfsBackupCount(), backupDir);
                conf.setDescription(this.basicPage.getConfigDescription());
                if (this.newFrom) {
                    conf.setTransformationVariables((Map)this.newFromConfiguration.getTransformationVariables());
                }
                try {
                    conf.create(ConfigurationManager.getCurrent());
                }
                catch (CMServerException e) {
                    if (!e.isError()) break block17;
                    this.basicPage.setServerError(e);
                }
            }
        }
    }

    protected static enum ConfigurationType {
        CPSM,
        CSD,
        ZFS,
        EXPORT,
        NOT_SELECTED;

    }
}

