/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.wizards;

import com.ibm.cics.cm.model.CMSystemOptions;
import com.ibm.cics.cm.model.ChangePackage;
import com.ibm.cics.cm.model.builder.ChangePackageBuilder;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.MessageResponse;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.editors.ChangePackageEditorInput;
import com.ibm.cics.cm.ui.views.ChangePackagesView;
import com.ibm.cics.cm.ui.wizards.NewChangePackagePage;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.eclipse.common.ViewHelper;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class NewChangePackageWizard
extends Wizard
implements INewWizard {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private NewChangePackagePage basicPage;
    private String packageName;
    private String packageDesc;
    private String externalReference;
    private boolean openEditor = false;
    private ChangePackage newChangePackage;

    public NewChangePackageWizard() {
        this.setWindowTitle(Messages.getString("NewChangePackageWizard.title"));
    }

    public void addPages() {
        this.basicPage = new NewChangePackagePage();
        this.addPage((IWizardPage)this.basicPage);
    }

    public boolean canFinish() {
        String autoNum;
        CMSystemOptions cmSysOpt = ConfigurationManager.getCurrent().getSystemOptions(false);
        boolean autoNumbering = false;
        if (cmSysOpt != null && (autoNum = cmSysOpt.getAttribute("PKGAUTNUM")) != null && autoNum.equalsIgnoreCase("YES")) {
            autoNumbering = true;
        }
        return autoNumbering || !this.basicPage.getPackageName().isEmpty();
    }

    public boolean performFinish() {
        this.packageName = this.basicPage.getPackageName();
        this.packageDesc = this.basicPage.getPackageDescription();
        this.externalReference = this.basicPage.getExternalReference();
        this.openEditor = this.basicPage.getOpenEditor();
        this.executeFinish();
        final ChangePackagesView changePackagesView = UIActivator.getChangePackagesView();
        if (changePackagesView != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    changePackagesView.refresh(false);
                }
            });
        }
        return true;
    }

    private void executeFinish() {
        ChangePackageBuilder packageBuilder = new ChangePackageBuilder();
        packageBuilder.setName(this.packageName.toUpperCase());
        packageBuilder.setDescription(this.packageDesc);
        if (StringUtil.hasContent((String)this.externalReference)) {
            packageBuilder.setAttribute("EXTREF", this.externalReference);
        }
        ChangePackage newPackage = packageBuilder.create(ConfigurationManager.getCurrent());
        MessageResponse lastResponse = packageBuilder.getLastResponse();
        if (lastResponse != null) {
            if (newPackage == null) {
                Status status = new Status(2, "com.ibm.cics.cm.ui", MessageFormat.format(Messages.getString("NewChangePackageWizard.failure"), lastResponse.getReturnResponse()));
                UIActivator.getDefault().getLog().log((IStatus)status);
                ViewHelper.setDeferredStatusErrorMessage((String)status.getMessage());
            } else {
                MessageDialog mBox = new MessageDialog(this.getShell(), Messages.getString("NewChangePackageWizard.success.title"), null, MessageFormat.format(Messages.getString("NewChangePackageWizard.success"), newPackage.getName()), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                mBox.open();
                ViewHelper.setDeferredStatusInformationMessage((String)MessageFormat.format(Messages.getString("NewChangePackageWizard.success"), newPackage.getName()));
                this.newChangePackage = newPackage;
                if (this.openEditor) {
                    ChangePackageEditorInput input = new ChangePackageEditorInput(newPackage);
                    try {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, "com.ibm.cics.cm.ui.chgpkg.editor"));
                    }
                    catch (PartInitException pie) {
                        throw new RuntimeException(pie);
                    }
                }
            }
        }
    }

    public ChangePackage getNewChangePackage() {
        return this.newChangePackage;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

