/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.wizards;

import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.definitions.CICSRegionGroupDefinition;
import com.ibm.cics.cm.model.definitions.CICSRegionGroupMember;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.wizards.CPSMNoGroupDefinitionTreeItem;
import com.ibm.cics.cm.ui.wizards.ChangePackageTopologyWizard;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class CPTopologySelectMembersPage
extends WizardPage
implements Constants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Composite base;
    private ChangePackageTopologyWizard wizard;
    private TreeViewer viewer;
    private ArrayList<CPSMNoGroupDefinitionTreeItem> treeItems;
    private ToolItem expandToolItem;
    private ToolItem collapseToolItem;

    public CPTopologySelectMembersPage(ChangePackageTopologyWizard wizard) {
        super("page.select");
        this.setTitle(Messages.getString("PackageTopologyWizard.page.select.title"));
        this.setMessage(MessageFormat.format(Messages.getString("PackageTopologyWizard.page.select.description"), wizard.getTargetPackage().getName()));
        this.wizard = wizard;
    }

    public void createControl(Composite parent) {
        this.base = new Composite(parent, 0);
        this.base.setLayout((Layout)new GridLayout(1, false));
        ToolBar toolBar = new ToolBar(this.base, 8519744);
        toolBar.setLayoutData((Object)new GridData(131072, 128, true, false));
        this.expandToolItem = new ToolItem(toolBar, 8);
        this.expandToolItem.setEnabled(false);
        this.expandToolItem.setToolTipText(Messages.getString("PackageTopologyWizard.page.select.action.expand.tooltip"));
        this.expandToolItem.setImage(UIActivator.getImage(UIActivator.IMGD_EXPAND));
        this.expandToolItem.setDisabledImage(UIActivator.getImage(UIActivator.IMGD_EXPAND_DISABLED));
        this.expandToolItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CPTopologySelectMembersPage.this.setItemExpandedState(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.collapseToolItem = new ToolItem(toolBar, 8);
        this.collapseToolItem.setEnabled(false);
        this.collapseToolItem.setToolTipText(Messages.getString("PackageTopologyWizard.page.select.action.collapse.tooltip"));
        this.collapseToolItem.setImage(UIActivator.getImage(UIActivator.IMGD_COLLAPSE));
        this.collapseToolItem.setDisabledImage(UIActivator.getImage(UIActivator.IMGD_COLLAPSE_DISABLED));
        this.collapseToolItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CPTopologySelectMembersPage.this.setItemExpandedState(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new ToolItem(toolBar, 2);
        ToolItem expandAllToolItem = new ToolItem(toolBar, 8);
        expandAllToolItem.setToolTipText(Messages.getString("PackageTopologyWizard.page.select.action.expandall.tooltip"));
        expandAllToolItem.setImage(UIActivator.getImage(UIActivator.IMGD_EXPAND_ALL));
        expandAllToolItem.setDisabledImage(UIActivator.getImage(UIActivator.IMGD_EXPAND_ALL_DISABLED));
        expandAllToolItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CPTopologySelectMembersPage.this.expandAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ToolItem collapseAllToolItem = new ToolItem(toolBar, 8);
        collapseAllToolItem.setToolTipText(Messages.getString("PackageTopologyWizard.page.select.action.collapseall.tooltip"));
        collapseAllToolItem.setImage(UIActivator.getImage(UIActivator.IMGD_COLLAPSE_ALL));
        collapseAllToolItem.setDisabledImage(UIActivator.getImage(UIActivator.IMGD_COLLAPSE_ALL_DISABLED));
        collapseAllToolItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CPTopologySelectMembersPage.this.collapseAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        MembersPatternFilter filter = new MembersPatternFilter();
        FilteredTree tree = new FilteredTree(this.base, 68354, (PatternFilter)filter, true);
        this.viewer = tree.getViewer();
        this.createColumn(CPSMNoGroupDefinitionTreeItem.ColumnInformation.DEFINITIONS, this.viewer);
        TreeViewerColumn editable = this.createColumn(CPSMNoGroupDefinitionTreeItem.ColumnInformation.ADD, this.viewer);
        Tree baseTree = this.viewer.getTree();
        baseTree.setLinesVisible(true);
        baseTree.setHeaderVisible(true);
        baseTree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = false;
                StructuredSelection selection = CPTopologySelectMembersPage.this.getViewerSelection();
                if (selection != null && selection.size() == 1 && CPTopologySelectMembersPage.this.viewer.isExpandable(selection.getFirstElement())) {
                    enabled = true;
                }
                CPTopologySelectMembersPage.this.expandToolItem.setEnabled(enabled);
                CPTopologySelectMembersPage.this.collapseToolItem.setEnabled(enabled);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new MembersTreeContentProvider());
        baseTree.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                super.getName(event);
                event.result = String.valueOf(CPSMNoGroupDefinitionTreeItem.ColumnInformation.DEFINITIONS.getTitle()) + event.result;
            }
        });
        MemberEditingSupport editing = new MemberEditingSupport(editable.getViewer(), this.viewer);
        editable.setEditingSupport((EditingSupport)editing);
        this.createPopupMenu();
        this.createKeyListeners();
        this.base.layout();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), this.getHelpContextID());
        this.setControl((Control)this.base);
    }

    private StructuredSelection getViewerSelection() {
        if (this.viewer != null && this.viewer.getSelection() instanceof StructuredSelection) {
            return (StructuredSelection)this.viewer.getSelection();
        }
        return null;
    }

    private void expandAll() {
        if (this.viewer != null) {
            this.viewer.expandAll();
        }
    }

    private void collapseAll() {
        if (this.viewer != null) {
            this.viewer.collapseAll();
        }
    }

    private void setItemExpandedState(boolean expanded) {
        StructuredSelection selection = this.getViewerSelection();
        if (selection != null && selection.size() == 1 && this.viewer.isExpandable(selection.getFirstElement())) {
            this.viewer.setExpandedState(selection.getFirstElement(), expanded);
        }
    }

    private void createKeyListeners() {
        Tree tree = this.viewer.getTree();
        tree.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                switch (e.keyCode) {
                    case 0x1000004: {
                        CPTopologySelectMembersPage.this.setItemExpandedState(true);
                        break;
                    }
                    case 0x1000003: {
                        CPTopologySelectMembersPage.this.setItemExpandedState(false);
                        break;
                    }
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    private TreeViewerColumn createColumn(CPSMNoGroupDefinitionTreeItem.ColumnInformation info, TreeViewer tv) {
        TreeViewerColumn column = new TreeViewerColumn(tv, 0);
        column.getColumn().setWidth(info.getDefaultWidth());
        column.getColumn().setResizable(true);
        column.getColumn().setMoveable(false);
        column.getColumn().setText(info.getTitle());
        column.setLabelProvider((CellLabelProvider)new SelectMembersColumnLabelProvider(info.getIndex()));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)column.getViewer());
        return column;
    }

    private void createPopupMenu() {
        final MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                StructuredSelection selection = CPTopologySelectMembersPage.this.getViewerSelection();
                if (selection != null) {
                    if (selection.size() > 0) {
                        boolean allSysGrps = CPTopologySelectMembersPage.this.isAllSelectedSystemGroups(selection);
                        if (!menuMgr.isEmpty()) {
                            menuMgr.add((IContributionItem)new Separator());
                        }
                        MenuManager addMenu = new MenuManager(Messages.getString("PackageTopologyWizard.page.select.menu.add"));
                        menuMgr.add((IContributionItem)addMenu);
                        addMenu.add((IAction)new Action(){

                            public String getText() {
                                return Messages.getString("PackageTopologyWizard.page.select.menu.add.selected.none");
                            }

                            public void run() {
                                CPTopologySelectMembersPage.this.setSelectedItemsState(CPTopologySelectMembersPage.this.getViewerSelection(), CPSMNoGroupDefinitionTreeItem.SelectedState.NONE);
                            }

                            public ImageDescriptor getImageDescriptor() {
                                return null;
                            }

                            public ImageDescriptor getDisabledImageDescriptor() {
                                return null;
                            }
                        });
                        addMenu.add((IAction)new Action(){

                            public String getText() {
                                return Messages.getString("PackageTopologyWizard.page.select.menu.add.selected.definitions");
                            }

                            public void run() {
                                CPTopologySelectMembersPage.this.setSelectedItemsState(CPTopologySelectMembersPage.this.getViewerSelection(), CPSMNoGroupDefinitionTreeItem.SelectedState.DEFINITION);
                            }

                            public ImageDescriptor getImageDescriptor() {
                                return null;
                            }

                            public ImageDescriptor getDisabledImageDescriptor() {
                                return null;
                            }
                        });
                        if (!allSysGrps) {
                            addMenu.add((IAction)new Action(){

                                public String getText() {
                                    return Messages.getString("PackageTopologyWizard.page.select.menu.add.selected.associations");
                                }

                                public void run() {
                                    CPTopologySelectMembersPage.this.setSelectedItemsState(CPTopologySelectMembersPage.this.getViewerSelection(), CPSMNoGroupDefinitionTreeItem.SelectedState.ASSOCIATION);
                                }

                                public ImageDescriptor getImageDescriptor() {
                                    return null;
                                }

                                public ImageDescriptor getDisabledImageDescriptor() {
                                    return null;
                                }
                            });
                        }
                        if (!allSysGrps) {
                            addMenu.add((IAction)new Action(){

                                public String getText() {
                                    return Messages.getString("PackageTopologyWizard.page.select.menu.add.selected.definitionsandassociations");
                                }

                                public void run() {
                                    CPTopologySelectMembersPage.this.setSelectedItemsState(CPTopologySelectMembersPage.this.getViewerSelection(), CPSMNoGroupDefinitionTreeItem.SelectedState.DEFINITION_AND_ASSOCIATION);
                                }

                                public ImageDescriptor getImageDescriptor() {
                                    return null;
                                }

                                public ImageDescriptor getDisabledImageDescriptor() {
                                    return null;
                                }
                            });
                        }
                    }
                    if (selection.size() == 1) {
                        Object selectedObject;
                        if (!menuMgr.isEmpty()) {
                            menuMgr.add((IContributionItem)new Separator());
                        }
                        if ((selectedObject = selection.getFirstElement()) instanceof CPSMNoGroupDefinitionTreeItem && !((CPSMNoGroupDefinitionTreeItem)selectedObject).getChildren().isEmpty()) {
                            menuMgr.add((IAction)new Action(){

                                public String getText() {
                                    return Messages.getString("PackageTopologyWizard.page.select.action.expand.menu.text");
                                }

                                public String getToolTipText() {
                                    return Messages.getString("PackageTopologyWizard.page.select.action.expand.tooltip");
                                }

                                public void run() {
                                    CPTopologySelectMembersPage.this.setItemExpandedState(true);
                                }

                                public ImageDescriptor getImageDescriptor() {
                                    return UIActivator.IMGD_EXPAND;
                                }

                                public ImageDescriptor getDisabledImageDescriptor() {
                                    return UIActivator.IMGD_EXPAND_DISABLED;
                                }
                            });
                            menuMgr.add((IAction)new Action(){

                                public String getText() {
                                    return Messages.getString("PackageTopologyWizard.page.select.action.collapse.menu.text");
                                }

                                public String getToolTipText() {
                                    return Messages.getString("PackageTopologyWizard.page.select.action.collapse.tooltip");
                                }

                                public void run() {
                                    CPTopologySelectMembersPage.this.setItemExpandedState(false);
                                }

                                public ImageDescriptor getImageDescriptor() {
                                    return UIActivator.IMGD_COLLAPSE;
                                }

                                public ImageDescriptor getDisabledImageDescriptor() {
                                    return UIActivator.IMGD_COLLAPSE_DISABLED;
                                }
                            });
                        }
                    }
                    if (selection.size() > 0) {
                        if (!menuMgr.isEmpty()) {
                            menuMgr.add((IContributionItem)new Separator());
                        }
                        menuMgr.add((IAction)new Action(){

                            public String getText() {
                                return Messages.getString("PackageTopologyWizard.page.select.action.expandall.menu.text");
                            }

                            public String getToolTipText() {
                                return Messages.getString("PackageTopologyWizard.page.select.action.expandall.tooltip");
                            }

                            public void run() {
                                CPTopologySelectMembersPage.this.expandAll();
                            }

                            public ImageDescriptor getImageDescriptor() {
                                return UIActivator.IMGD_EXPAND_ALL;
                            }

                            public ImageDescriptor getDisabledImageDescriptor() {
                                return UIActivator.IMGD_EXPAND_ALL_DISABLED;
                            }
                        });
                        menuMgr.add((IAction)new Action(){

                            public String getText() {
                                return Messages.getString("PackageTopologyWizard.page.select.action.collapseall.menu.text");
                            }

                            public String getToolTipText() {
                                return Messages.getString("PackageTopologyWizard.page.select.action.collapseall.tooltip");
                            }

                            public void run() {
                                CPTopologySelectMembersPage.this.collapseAll();
                            }

                            public ImageDescriptor getImageDescriptor() {
                                return UIActivator.IMGD_COLLAPSE_ALL;
                            }

                            public ImageDescriptor getDisabledImageDescriptor() {
                                return UIActivator.IMGD_COLLAPSE_ALL_DISABLED;
                            }
                        });
                    }
                }
            }
        });
        Menu popupMenu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(popupMenu);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.treeItems = this.wizard.getTreeItems();
            this.viewer.setInput(this.treeItems);
        }
        this.viewer.refresh();
        if (this.viewer.getTree().getItemCount() > 0) {
            this.viewer.getTree().select(this.viewer.getTree().getItem(0));
        }
        this.viewer.getTree().setFocus();
    }

    public void setSelectedItemsState(StructuredSelection selection, CPSMNoGroupDefinitionTreeItem.SelectedState state) {
        for (Object obj : selection.toList()) {
            if (obj instanceof CPSMNoGroupDefinitionTreeItem) {
                CPSMNoGroupDefinitionTreeItem item = (CPSMNoGroupDefinitionTreeItem)obj;
                if (item.getParent() == null) {
                    if (state == CPSMNoGroupDefinitionTreeItem.SelectedState.DEFINITION || state == CPSMNoGroupDefinitionTreeItem.SelectedState.DEFINITION_AND_ASSOCIATION) {
                        item.setState(CPSMNoGroupDefinitionTreeItem.SelectedState.DEFINITION);
                    } else if (state == CPSMNoGroupDefinitionTreeItem.SelectedState.NONE) {
                        item.setState(CPSMNoGroupDefinitionTreeItem.SelectedState.NONE);
                    }
                } else {
                    item.setState(state);
                }
            }
            this.viewer.update(obj, null);
        }
    }

    private boolean isAllSelectedSystemGroups(StructuredSelection selection) {
        for (Object obj : selection.toList()) {
            if (!(obj instanceof CPSMNoGroupDefinitionTreeItem) || ((CPSMNoGroupDefinitionTreeItem)obj).getDefinition().getType().equals("CSYSGRP")) continue;
            return false;
        }
        return true;
    }

    private CPSMNoGroupDefinitionTreeItem.SelectedState getSelectedStateFromMessage(String message) {
        if (message.equals(Messages.getString("PackageTopologyWizard.page.select.item.both"))) {
            return CPSMNoGroupDefinitionTreeItem.SelectedState.DEFINITION_AND_ASSOCIATION;
        }
        if (message.equals(Messages.getString("PackageTopologyWizard.page.select.item.definition"))) {
            return CPSMNoGroupDefinitionTreeItem.SelectedState.DEFINITION;
        }
        if (message.equals(Messages.getString("PackageTopologyWizard.page.select.item.association"))) {
            return CPSMNoGroupDefinitionTreeItem.SelectedState.ASSOCIATION;
        }
        return CPSMNoGroupDefinitionTreeItem.SelectedState.NONE;
    }

    public IWizardPage getNextPage() {
        this.wizard.setTreeItems(this.treeItems);
        return super.getNextPage();
    }

    public IWizardPage getPreviousPage() {
        return null;
    }

    protected String getHelpContextID() {
        return "com.ibm.cics.cm.ui.wizardPage_packageSysGrpSelect";
    }

    private class MemberEditingSupport
    extends EditingSupport {
        private ComboBoxViewerCellEditor groupEditor;
        private ComboBoxViewerCellEditor memberEditor;
        private TreeViewer viewer;

        public MemberEditingSupport(ColumnViewer viewer, TreeViewer membersViewer) {
            super(viewer);
            this.groupEditor = null;
            this.memberEditor = null;
            this.viewer = null;
            this.viewer = membersViewer;
            this.groupEditor = new ComboBoxViewerCellEditor((Composite)this.getViewer().getControl(), 8);
            this.groupEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.groupEditor.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            this.groupEditor.setInput((Object)new String[]{CPSMNoGroupDefinitionTreeItem.SelectedState.NONE.toString(), CPSMNoGroupDefinitionTreeItem.SelectedState.DEFINITION.toString()});
            this.memberEditor = new ComboBoxViewerCellEditor((Composite)this.getViewer().getControl(), 8);
            this.memberEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.memberEditor.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            this.memberEditor.setInput((Object)new String[]{CPSMNoGroupDefinitionTreeItem.SelectedState.NONE.toString(), CPSMNoGroupDefinitionTreeItem.SelectedState.DEFINITION.toString(), CPSMNoGroupDefinitionTreeItem.SelectedState.ASSOCIATION.toString(), CPSMNoGroupDefinitionTreeItem.SelectedState.DEFINITION_AND_ASSOCIATION.toString()});
        }

        protected CellEditor getCellEditor(Object element) {
            if (element instanceof CPSMNoGroupDefinitionTreeItem) {
                CPSMNoGroupDefinitionTreeItem item = (CPSMNoGroupDefinitionTreeItem)element;
                if (item.getDefinition() instanceof CICSRegionGroupDefinition) {
                    return this.groupEditor;
                }
                if (item.getDefinition() instanceof CICSRegionGroupMember) {
                    return this.memberEditor;
                }
            }
            return null;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            if (element instanceof CPSMNoGroupDefinitionTreeItem) {
                return ((CPSMNoGroupDefinitionTreeItem)element).getState().toString();
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            if (value instanceof String && element instanceof CPSMNoGroupDefinitionTreeItem) {
                ((CPSMNoGroupDefinitionTreeItem)element).setState(CPTopologySelectMembersPage.this.getSelectedStateFromMessage((String)value));
            }
            this.viewer.update(element, null);
        }
    }

    private class MembersPatternFilter
    extends PatternFilter {
        private MembersPatternFilter() {
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            if (element instanceof CPSMNoGroupDefinitionTreeItem) {
                CPSMNoGroupDefinitionTreeItem item = (CPSMNoGroupDefinitionTreeItem)element;
                return this.wordMatches(item.getText(CPSMNoGroupDefinitionTreeItem.ColumnInformation.DEFINITIONS.getIndex())) || this.wordMatches(item.getText(CPSMNoGroupDefinitionTreeItem.ColumnInformation.ADD.getIndex()));
            }
            return false;
        }
    }

    private class MembersTreeContentProvider
    implements ITreeContentProvider {
        private MembersTreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ArrayList) {
                ArrayList elements = (ArrayList)inputElement;
                return elements.toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<CPSMNoGroupDefinitionTreeItem> children = null;
            if (parentElement instanceof CPSMNoGroupDefinitionTreeItem) {
                children = ((CPSMNoGroupDefinitionTreeItem)parentElement).getChildren();
            }
            if (children == null || children.isEmpty()) {
                return null;
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof CPSMNoGroupDefinitionTreeItem) {
                return ((CPSMNoGroupDefinitionTreeItem)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            ArrayList<CPSMNoGroupDefinitionTreeItem> children = null;
            if (element instanceof CPSMNoGroupDefinitionTreeItem) {
                children = ((CPSMNoGroupDefinitionTreeItem)element).getChildren();
            }
            return children != null && !children.isEmpty();
        }
    }

    private class SelectMembersColumnLabelProvider
    extends ColumnLabelProvider {
        private int column;

        public SelectMembersColumnLabelProvider(int column) {
            this.column = column;
        }

        public String getToolTipText(Object element) {
            if (element instanceof CPSMNoGroupDefinitionTreeItem) {
                return ((CPSMNoGroupDefinitionTreeItem)element).getToolTipText(this.column, CPTopologySelectMembersPage.this.wizard.getTargetPackage());
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof CPSMNoGroupDefinitionTreeItem) {
                return ((CPSMNoGroupDefinitionTreeItem)element).getImage(this.column);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof CPSMNoGroupDefinitionTreeItem) {
                return ((CPSMNoGroupDefinitionTreeItem)element).getText(this.column);
            }
            return null;
        }
    }
}

