/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.wizards;

import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.definitions.ResourceDefinition;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.wizards.CPSMNoGroupDefinitionTreeItem;
import com.ibm.cics.cm.ui.wizards.ChangePackageTopologyWizard;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class CPTopologyConfirmMembersPage
extends WizardPage
implements Constants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Composite base;
    private ChangePackageTopologyWizard wizard;
    private TableViewer viewer;
    private ArrayList<ResourceDefinition> contents;

    public CPTopologyConfirmMembersPage(ChangePackageTopologyWizard wizard) {
        super("page.select");
        this.setTitle(Messages.getString("PackageTopologyWizard.page.confirm.title"));
        this.setMessage(Messages.getString("PackageTopologyWizard.page.confirm.description"));
        this.wizard = wizard;
    }

    public void createControl(Composite parent) {
        this.base = new Composite(parent, 0);
        this.base.setLayout((Layout)new GridLayout(1, false));
        Table table = new Table(this.base, 67586);
        this.viewer = new TableViewer(table);
        TableColumn col_name = new TableColumn(table, 0);
        col_name.setText(Messages.getString("PackageTopologyWizard.page.confirm.column.def_name"));
        col_name.setWidth(90);
        TableColumn col_type = new TableColumn(table, 0);
        col_type.setText(Messages.getString("PackageTopologyWizard.page.confirm.column.def_type"));
        col_type.setWidth(90);
        TableColumn col_desc = new TableColumn(table, 0);
        col_desc.setText(Messages.getString("PackageTopologyWizard.page.confirm.column.def_description"));
        col_desc.setWidth(240);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setLayout((Layout)new GridLayout());
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.addLabelProvider(this.viewer);
        this.addContentProvider(this.viewer);
        this.base.layout();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), this.getHelpContextID());
        this.setControl((Control)this.base);
    }

    private void addContentProvider(TableViewer viewer) {
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
    }

    private void addLabelProvider(TableViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                ResourceDefinition item = null;
                if (!(element instanceof ResourceDefinition)) {
                    return null;
                }
                item = (ResourceDefinition)element;
                if (columnIndex == 0) {
                    return item.getName();
                }
                if (columnIndex == 1) {
                    return item.getType();
                }
                if (columnIndex == 2) {
                    return item.getDescription();
                }
                return null;
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.contents = new ArrayList();
            for (CPSMNoGroupDefinitionTreeItem treeItem : this.wizard.getTreeItems()) {
                if (treeItem.getState() == CPSMNoGroupDefinitionTreeItem.SelectedState.DEFINITION || treeItem.getState() == CPSMNoGroupDefinitionTreeItem.SelectedState.DEFINITION_AND_ASSOCIATION) {
                    this.contents.add(treeItem.createDefinition());
                } else if (treeItem.getState() == CPSMNoGroupDefinitionTreeItem.SelectedState.ASSOCIATION || treeItem.getState() == CPSMNoGroupDefinitionTreeItem.SelectedState.DEFINITION_AND_ASSOCIATION) {
                    this.contents.add(treeItem.createAssociation());
                }
                if (treeItem.getTreeItemType() != CPSMNoGroupDefinitionTreeItem.TreeItemType.GROUP) continue;
                this.contents.addAll(treeItem.getChildrenResourceDefinitions());
            }
            this.viewer.setInput((Object)this.contents.toArray());
        }
    }

    protected String getHelpContextID() {
        return "com.ibm.cics.cm.ui.wizardPage_packageSysGrpConfirm";
    }

    public ArrayList<ResourceDefinition> getDefinitions() {
        return this.contents;
    }
}

