/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.wizards;

import com.ibm.cics.cm.model.MigrationScheme;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.chgpkg.ChangePackageCommand;
import com.ibm.cics.cm.ui.chgpkg.MigrationSchemeLabelProvider;
import com.ibm.cics.cm.ui.wizards.ChangePackageWizardPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;

public class CPSchemeActionPage
extends ChangePackageWizardPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Composite base;
    private FilteredList list;
    private Text text;

    public CPSchemeActionPage(ChangePackageCommand changePackageCommand) {
        super("choose.scheme", changePackageCommand);
        this.setMessage(Messages.getString("ChangePackageActionWizard.choose.scheme"));
    }

    public void createControl(Composite parent) {
        this.base = new Composite(parent, 0);
        this.base.setLayout((Layout)new GridLayout(2, false));
        Label filterLabel = new Label(this.base, 0);
        filterLabel.setText(Messages.getString("ChangePackageActionWizard.filter"));
        filterLabel.setLayoutData((Object)new GridData());
        this.setPageComplete(false);
        this.text = this.createFilterText(this.base);
        MigrationSchemeLabelProvider labelProvider = new MigrationSchemeLabelProvider();
        labelProvider.setIncludeDescription(true);
        this.list = this.createFilteredList(this.base, labelProvider);
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                if (CPSchemeActionPage.this.list.getSelectionIndex() != -1) {
                    CPSchemeActionPage.this.setPageComplete(true);
                } else {
                    CPSchemeActionPage.this.setPageComplete(false);
                }
            }
        });
        this.linkTextToFilteredList(this.text, this.list);
        Object[] schemeArray = ConfigurationManager.getCurrent().getMigrationSchemes().getResults().toArray();
        this.list.setElements(schemeArray);
        MigrationScheme selectedScheme = this.getCPWizard().getMigrationScheme();
        if (selectedScheme != null) {
            int selectedIndex = -1;
            int i = 0;
            while (i < schemeArray.length) {
                if (((MigrationScheme)schemeArray[i]).getName().equals(selectedScheme.getName())) {
                    selectedIndex = i;
                }
                ++i;
            }
            if (selectedIndex > -1 && selectedIndex < schemeArray.length) {
                this.list.setSelection(new int[]{selectedIndex});
            }
        }
        this.setControl((Control)this.base);
    }

    @Override
    protected String getHelpContextID() {
        return "com.ibm.cics.cm.ui.wizard_cp_actions_scheme";
    }

    public IWizardPage getNextPage() {
        ChangePackageCommand command;
        Object[] selection = this.list.getSelection();
        if (selection.length == 1) {
            this.setMigrationScheme((MigrationScheme)selection[0]);
        }
        if ((command = this.getCPWizard().getPackageCommand()) != null && command.equals((Object)ChangePackageCommand.BACKOUT)) {
            return this.getCPWizard().backoutPage;
        }
        return this.getCPWizard().confirmPage;
    }

    private void setMigrationScheme(MigrationScheme ms) {
        this.getCPWizard().setMigrationScheme(ms);
    }
}

