/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.wizards;

import com.ibm.cics.cm.model.ChangePackage;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.definitions.CICSRegionGroupDefinition;
import com.ibm.cics.cm.model.definitions.CICSRegionGroupMember;
import com.ibm.cics.cm.model.definitions.CPSMNoGroupDefinition;
import com.ibm.cics.cm.model.definitions.ICICSRegionGroupDefinition;
import com.ibm.cics.cm.model.definitions.ResourceDefinition;
import com.ibm.cics.cm.model.definitions.ResourceDefinitionFactory;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.swt.graphics.Image;

public class CPSMNoGroupDefinitionTreeItem
implements Constants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private CPSMNoGroupDefinition definition;
    private SelectedState state;
    private CPSMNoGroupDefinitionTreeItem parent;
    private ArrayList<CPSMNoGroupDefinitionTreeItem> children;
    private TreeItemType type;

    public CPSMNoGroupDefinitionTreeItem(CPSMNoGroupDefinition definition, SelectedState initialState, CPSMNoGroupDefinitionTreeItem parent) {
        this.definition = definition;
        this.state = initialState;
        this.parent = parent;
        this.type = definition instanceof CICSRegionGroupDefinition || definition instanceof CICSRegionGroupMember && ((CICSRegionGroupMember)definition).getType().equals("CSGLCGCG") ? TreeItemType.GROUP : TreeItemType.SYSTEM;
    }

    public CPSMNoGroupDefinition getDefinition() {
        return this.definition;
    }

    public SelectedState getState() {
        return this.state;
    }

    public CPSMNoGroupDefinitionTreeItem getParent() {
        return this.parent;
    }

    public TreeItemType getTreeItemType() {
        return this.type;
    }

    public void setState(SelectedState newState) {
        this.state = newState;
    }

    public ArrayList<CPSMNoGroupDefinitionTreeItem> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
            ArrayList childDefs = new ArrayList();
            if (this.definition instanceof ICICSRegionGroupDefinition && this.type == TreeItemType.GROUP) {
                childDefs.addAll(((ICICSRegionGroupDefinition)this.definition).getMembers(true));
            }
            for (CICSRegionGroupMember def : childDefs) {
                CPSMNoGroupDefinitionTreeItem treeItem = new CPSMNoGroupDefinitionTreeItem((CPSMNoGroupDefinition)def, SelectedState.NONE, this);
                this.children.add(treeItem);
                treeItem.getChildren();
            }
        }
        return this.children;
    }

    public String getText(int column) {
        if (column == ColumnInformation.DEFINITIONS.getIndex()) {
            if (this.definition instanceof CICSRegionGroupDefinition) {
                return (String)((CICSRegionGroupDefinition)this.definition).getAttributes().get("GROUP");
            }
            if (this.definition instanceof CICSRegionGroupMember) {
                CICSRegionGroupMember member = (CICSRegionGroupMember)this.definition;
                return this.getTreeItemType() == TreeItemType.GROUP ? (String)member.getAttributes().get("GROUP") : (String)member.getAttributes().get("CICSNAME");
            }
        } else if (column == ColumnInformation.ADD.getIndex()) {
            return this.getState().toString();
        }
        return null;
    }

    public Image getImage(int column) {
        if (column == ColumnInformation.DEFINITIONS.getIndex()) {
            if (this.type == TreeItemType.GROUP) {
                return UIActivator.getImage(UIActivator.IMGD_CSYSGRP);
            }
            return UIActivator.getImage(UIActivator.IMGD_CSYSDEF);
        }
        return null;
    }

    public String getToolTipText(int column, ChangePackage targetPackage) {
        if (column == ColumnInformation.DEFINITIONS.getIndex()) {
            CPSMNoGroupDefinition def = this.getDefinition();
            if (def instanceof CICSRegionGroupDefinition) {
                return MessageFormat.format(Messages.getString("PackageTopologyWizard.page.select.tooltip.definition.group.0"), ((CICSRegionGroupDefinition)def).getAttributes().get("GROUP"));
            }
            if (def instanceof CICSRegionGroupMember) {
                CICSRegionGroupMember member = (CICSRegionGroupMember)def;
                String memberName = member.getType().equals("CSGLCGCS") ? (String)member.getAttributes().get("CICSNAME") : (String)member.getAttributes().get("GROUP");
                String associationName = member.getName();
                String parentName = member.getType().equals("CSGLCGCS") ? (String)member.getAttributes().get("GROUP") : (String)member.getAttributes().get("TOGROUP");
                String tooltip = "";
                tooltip = member.getType().equals("CSGLCGCS") ? Messages.getString("PackageTopologyWizard.page.select.tooltip.definition.member.0") : Messages.getString("PackageTopologyWizard.page.select.tooltip.definition.member.1");
                return MessageFormat.format(tooltip, memberName, associationName, memberName, parentName);
            }
        } else if (column == ColumnInformation.ADD.getIndex()) {
            CPSMNoGroupDefinition def = this.getDefinition();
            if (def instanceof CICSRegionGroupDefinition) {
                CICSRegionGroupDefinition group = (CICSRegionGroupDefinition)def;
                SelectedState state = this.getState();
                String tooltip = "";
                if (state == SelectedState.DEFINITION) {
                    tooltip = Messages.getString("PackageTopologyWizard.page.select.tooltip.add.group.0");
                } else if (state == SelectedState.NONE) {
                    tooltip = Messages.getString("PackageTopologyWizard.page.select.tooltip.add.group.1");
                }
                return MessageFormat.format(tooltip, group.getAttributes().get("GROUP"), targetPackage.getName());
            }
            if (def instanceof CICSRegionGroupMember) {
                CICSRegionGroupMember member = (CICSRegionGroupMember)def;
                SelectedState state = this.getState();
                String memberName = member.getType().equals("CSGLCGCS") ? (String)member.getAttributes().get("CICSNAME") : (String)member.getAttributes().get("GROUP");
                String associationName = member.getName();
                String changePackageName = targetPackage.getName();
                String parentName = member.getType().equals("CSGLCGCS") ? (String)member.getAttributes().get("GROUP") : (String)member.getAttributes().get("TOGROUP");
                String tooltip = "";
                if (state == SelectedState.DEFINITION_AND_ASSOCIATION) {
                    tooltip = member.getType().equals("CSGLCGCS") ? Messages.getString("PackageTopologyWizard.page.select.tooltip.add.member.0") : Messages.getString("PackageTopologyWizard.page.select.tooltip.add.member.1");
                    return MessageFormat.format(tooltip, memberName, associationName, memberName, parentName, changePackageName);
                }
                if (state == SelectedState.DEFINITION) {
                    tooltip = member.getType().equals("CSGLCGCS") ? Messages.getString("PackageTopologyWizard.page.select.tooltip.add.member.2") : Messages.getString("PackageTopologyWizard.page.select.tooltip.add.member.3");
                    return MessageFormat.format(tooltip, memberName, changePackageName, associationName, memberName, parentName, changePackageName, parentName, memberName);
                }
                if (state == SelectedState.ASSOCIATION) {
                    tooltip = member.getType().equals("CSGLCGCS") ? Messages.getString("PackageTopologyWizard.page.select.tooltip.add.member.4") : Messages.getString("PackageTopologyWizard.page.select.tooltip.add.member.5");
                    return MessageFormat.format(tooltip, associationName, memberName, parentName, changePackageName, memberName, changePackageName, parentName, memberName);
                }
                if (state == SelectedState.NONE) {
                    tooltip = member.getType().equals("CSGLCGCS") ? Messages.getString("PackageTopologyWizard.page.select.tooltip.add.member.6") : Messages.getString("PackageTopologyWizard.page.select.tooltip.add.member.7");
                    return MessageFormat.format(tooltip, memberName, associationName, memberName, parentName, changePackageName, parentName, memberName);
                }
            }
        }
        return null;
    }

    public ArrayList<ResourceDefinition> getChildrenResourceDefinitions() {
        ArrayList<ResourceDefinition> defs = new ArrayList<ResourceDefinition>();
        for (CPSMNoGroupDefinitionTreeItem child : this.getChildren()) {
            if (child.getState() == SelectedState.DEFINITION || child.getState() == SelectedState.DEFINITION_AND_ASSOCIATION) {
                defs.add(child.createDefinition());
            }
            if (child.getState() == SelectedState.ASSOCIATION || child.getState() == SelectedState.DEFINITION_AND_ASSOCIATION) {
                defs.add(child.createAssociation());
            }
            if (child.getTreeItemType() != TreeItemType.GROUP) continue;
            defs.addAll(child.getChildrenResourceDefinitions());
        }
        return defs;
    }

    public ResourceDefinition createDefinition() {
        String name = "";
        String type = "";
        String description = "";
        if (this.definition instanceof CICSRegionGroupDefinition) {
            name = (String)this.definition.getAttributes().get("GROUP");
            type = "CSYSGRP";
            description = Messages.getString("PackageTopologyWizard.page.confirm.item.systemGroupDefinition");
        } else if (this.definition instanceof CICSRegionGroupMember) {
            if (this.type == TreeItemType.GROUP) {
                name = (String)this.definition.getAttributes().get("GROUP");
                type = "CSYSGRP";
                description = Messages.getString("PackageTopologyWizard.page.confirm.item.systemGroupDefinition");
            } else {
                name = (String)this.definition.getAttributes().get("CICSNAME");
                type = "CSYSDEF";
                description = Messages.getString("PackageTopologyWizard.page.confirm.item.systemDefinition");
            }
        } else {
            return null;
        }
        return this.createResourceDefinition(name, type, description);
    }

    public ResourceDefinition createAssociation() {
        String name = "";
        String type = "";
        String description = "";
        if (this.definition instanceof CICSRegionGroupMember) {
            if (this.type == TreeItemType.GROUP) {
                name = this.definition.getName();
                type = "CSGLCGCG";
                description = String.valueOf((String)this.definition.getAttributes().get("GROUP")) + " <-> " + (String)this.definition.getAttributes().get("TOGROUP") + " " + Messages.getString("PackageTopologyWizard.page.confirm.item.association");
            } else {
                name = this.definition.getName();
                type = "CSGLCGCS";
                description = String.valueOf((String)this.definition.getAttributes().get("CICSNAME")) + " <-> " + (String)this.definition.getAttributes().get("GROUP") + " " + Messages.getString("PackageTopologyWizard.page.confirm.item.association");
            }
        } else {
            return null;
        }
        return this.createResourceDefinition(name, type, description);
    }

    public ResourceDefinition createResourceDefinition(String name, String type, String description) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (type.equals("CSYSGRP")) {
            attributes.put("GROUP", name);
            attributes.put("NAME", name);
        } else {
            attributes.put("NAME", name);
        }
        attributes.put("TYPE", type);
        attributes.put("DESCRIPTION", description);
        ICMObject tempDef = ResourceDefinitionFactory.getObject((Configuration)this.getDefinition().getConfiguration(), attributes);
        if (tempDef instanceof ResourceDefinition) {
            return (ResourceDefinition)tempDef;
        }
        return null;
    }

    public static enum ColumnInformation {
        DEFINITIONS(Messages.getString("PackageTopologyWizard.page.select.column.members"), 0, 250),
        ADD(Messages.getString("PackageTopologyWizard.page.select.column.add_member"), 1, 110);

        private String title;
        private int index;
        private int defaultWidth;

        private ColumnInformation(String title, int index, int defaultWidth) {
            this.title = title;
            this.index = index;
            this.defaultWidth = defaultWidth;
        }

        public String getTitle() {
            return this.title;
        }

        public int getIndex() {
            return this.index;
        }

        public int getDefaultWidth() {
            return this.defaultWidth;
        }
    }

    public static enum SelectedState {
        NONE(Messages.getString("PackageTopologyWizard.page.select.item.none")),
        DEFINITION(Messages.getString("PackageTopologyWizard.page.select.item.definition")),
        ASSOCIATION(Messages.getString("PackageTopologyWizard.page.select.item.association")),
        DEFINITION_AND_ASSOCIATION(Messages.getString("PackageTopologyWizard.page.select.item.both"));

        private String message;

        private SelectedState(String message) {
            this.message = message;
        }

        public String toString() {
            return this.message;
        }
    }

    public static enum TreeItemType {
        GROUP,
        SYSTEM;

    }
}

