/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.wizards;

import com.ibm.cics.cm.model.ChangePackage;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.MigrationScheme;
import com.ibm.cics.cm.model.PackageScheme;
import com.ibm.cics.cm.model.PackageSchemeEvent;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.chgpkg.ChangePackageCommand;
import com.ibm.cics.cm.ui.chgpkg.PackageSchemeEventLabelProvider;
import com.ibm.cics.cm.ui.wizards.ChangePackageWizardPage;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;

public class CPBackoutActionPage
extends ChangePackageWizardPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Composite base;
    private FilteredList list;
    private Text text;
    private MigrationScheme lastScheme = null;
    private Set<String> backoutCommands = new HashSet<String>();

    public CPBackoutActionPage(ChangePackageCommand changePackageCommand) {
        super("choose.backout", changePackageCommand);
        this.setMessage(Messages.getString("ChangePackageActionWizard.choose.backout"));
        this.backoutCommands.add("MIGRATE");
        this.backoutCommands.add("BACKOUT");
    }

    public void createControl(Composite parent) {
        this.base = new Composite(parent, 0);
        this.base.setLayout((Layout)new GridLayout(2, false));
        Label filterLabel = new Label(this.base, 0);
        filterLabel.setText(Messages.getString("ChangePackageActionWizard.filter"));
        filterLabel.setLayoutData((Object)new GridData());
        this.text = this.createFilterText(this.base);
        PackageSchemeEventLabelProvider labelProvider = new PackageSchemeEventLabelProvider();
        this.list = this.createFilteredList(this.base, labelProvider);
        this.list.setComparator((Comparator)new Comparator<String>(){

            @Override
            public int compare(String object1, String object2) {
                return object2.compareTo(object1);
            }
        });
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                Object[] selection = CPBackoutActionPage.this.list.getSelection();
                if (selection.length == 1) {
                    CPBackoutActionPage.this.setBackoutEvent((PackageSchemeEvent)selection[0]);
                }
            }
        });
        this.linkTextToFilteredList(this.text, this.list);
        this.setInput();
        this.base.layout();
        this.setControl((Control)this.base);
    }

    @Override
    protected String getHelpContextID() {
        return "com.ibm.cics.cm.ui.wizard_cp_actions_backout";
    }

    private void setInput() {
        IFilteredCollection packageSchemes;
        ChangePackage changePackage = this.getCPWizard().getChangePackage();
        this.lastScheme = this.getCPWizard().getMigrationScheme();
        if (changePackage != null && this.lastScheme != null && (packageSchemes = changePackage.getPackageSchemes(this.lastScheme)).size() == 1) {
            PackageScheme packageScheme = (PackageScheme)packageSchemes.getResults().get(0);
            List events = packageScheme.getEvents();
            events = PackageSchemeEvent.filterEventsByCommand((List)events, this.backoutCommands);
            Object[] eventArray = events.toArray();
            this.list.setElements(eventArray);
        }
    }

    public void setVisible(boolean visible) {
        MigrationScheme currentScheme = this.getCPWizard().getMigrationScheme();
        if (this.lastScheme == null || !this.lastScheme.getName().equals(currentScheme.getName())) {
            this.setInput();
        }
        super.setVisible(visible);
    }

    public IWizardPage getNextPage() {
        Object[] selection = this.list.getSelection();
        if (selection.length == 1) {
            this.setBackoutEvent((PackageSchemeEvent)selection[0]);
        }
        return super.getNextPage();
    }

    protected void setBackoutEvent(PackageSchemeEvent packageSchemeEvent) {
        this.getCPWizard().setBackoutEvent(packageSchemeEvent);
    }
}

