/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.views;

import com.ibm.cics.cm.model.CPSMConfiguration;
import com.ibm.cics.cm.model.CSDConfiguration;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.model.FilteredCollection;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.ZfsConfiguration;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.RestrictionCriteria;
import com.ibm.cics.cm.model.runtime.RestrictionCriteriaList;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.actions.NewDefinitionWizardDropdownAction;
import com.ibm.cics.cm.ui.views.CMViewPart;
import com.ibm.cics.cm.ui.views.FilteredTableComposite;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import java.util.HashMap;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.handlers.IHandlerService;

public class ConfigurationsView
extends CMViewPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2008, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String ID = "com.ibm.cics.cm.view.configurations";
    private FilteredTableComposite filteredTableComposite;
    private TableViewer viewer;
    private ConfigurationFilter filter;
    private JobWithCancelingSupport job;
    private HashMap<Configuration, Configuration.ConfigurationListener> configurationListeners;

    @Override
    protected Control createControl(Composite parent) {
        this.configurationListeners = new HashMap();
        this.filteredTableComposite = new FilteredTableComposite(parent, 67584, this.getViewSite().getActionBars().getToolBarManager(), true);
        this.filteredTableComposite.addListener(new FilteredTableComposite.Listener(){

            @Override
            public void searchRequested(String string) {
                ConfigurationsView.this.refresh(string);
            }
        });
        Table table = this.filteredTableComposite.getTable();
        this.viewer = new TableViewer(table);
        TableColumn nameColumn = new TableColumn(table, 0);
        nameColumn.setText(Messages.getString("ConfigurationsView.columnHeading.name"));
        TableColumn contextCSDColumn = new TableColumn(table, 0);
        contextCSDColumn.setText(Messages.getString("ConfigurationsView.columnHeading.context"));
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60));
        this.filteredTableComposite.getTable().setLinesVisible(true);
        this.filteredTableComposite.getTable().setHeaderVisible(true);
        this.filteredTableComposite.setSite(this.getSite());
        this.addLabelProvider(this.viewer);
        this.addContentProvider(this.viewer);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IHandlerService handlerService = (IHandlerService)ConfigurationsView.this.getSite().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("com.ibm.cics.cm.ui.configuration.command.open", null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.filter = new ConfigurationFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        return this.filteredTableComposite;
    }

    private void addLabelProvider(TableViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                Configuration item = null;
                if (!(element instanceof Configuration)) {
                    return null;
                }
                item = (Configuration)element;
                if (columnIndex == 0) {
                    return item.getName();
                }
                if (columnIndex == 1) {
                    if (item instanceof CSDConfiguration) {
                        return ((CSDConfiguration)item).getCSDName();
                    }
                    if (item instanceof CPSMConfiguration) {
                        return ((CPSMConfiguration)item).getCPSMContext();
                    }
                    if (item instanceof ZfsConfiguration) {
                        return ((ZfsConfiguration)item).getZfsRootDir();
                    }
                } else {
                    return null;
                }
                return null;
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    if (element instanceof Configuration) {
                        return UIActivator.getImage((Configuration)element);
                    }
                    return null;
                }
                return null;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    private void addContentProvider(TableViewer viewer) {
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                FilteredCollection elements = (FilteredCollection)inputElement;
                return elements.getResults().toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
    }

    @Override
    protected void fillContextMenu(IMenuManager aMenuManager, boolean isCICSConfiguration) {
        aMenuManager.add((IAction)new NewDefinitionWizardDropdownAction("com.ibm.cics.cm.ui.config.newwizard", isCICSConfiguration));
        aMenuManager.add((IContributionItem)new Separator("new"));
        aMenuManager.add((IContributionItem)new Separator("open"));
        aMenuManager.add((IContributionItem)new Separator("actions"));
        aMenuManager.add((IContributionItem)new Separator("commonActions"));
        aMenuManager.add((IContributionItem)new Separator("clipboard"));
        aMenuManager.add((IContributionItem)new Separator("additions"));
    }

    @Override
    protected String getHelpContextID() {
        return "com.ibm.cics.cm.ui.view_configurations";
    }

    @Override
    public void refresh(boolean isUser) {
        this.refresh(this.filteredTableComposite.getSearchString());
    }

    protected void refresh(final String searchString) {
        IWorkbenchPartSite wPartSite;
        if (this.job != null) {
            this.job.cancel();
            this.job = null;
        }
        if ((wPartSite = this.getSite()) != null && wPartSite instanceof IViewSite) {
            ((IViewSite)wPartSite).getActionBars().getStatusLineManager().setMessage(null);
        }
        this.job = new CMViewPart.FillTableFromFilteredCollectionJob(this, Messages.getString("ConfigurationsView.fetchingMessage"), this.filteredTableComposite.getTable()){

            @Override
            protected void fillTableFrom(IFilteredCollection cmObjects) {
                IFilteredCollection configurations = cmObjects;
                ConfigurationsView.this.viewer.setInput((Object)configurations);
                ConfigurationsView.this.filter.setSearchString(searchString);
                ConfigurationsView.this.viewer.refresh();
                ConfigurationsView.this.filteredTableComposite.setTotalsCount(cmObjects.size(), Messages.getString("CMObjects.Configurations"));
                if (cmObjects.size() > 0) {
                    ConfigurationsView.this.viewer.getTable().setSelection(0);
                }
                ConfigurationsView.this.viewer.getTable().setFocus();
            }

            protected IFilteredCollection<Configuration> getCMObjects() {
                IFilteredCollection configurations = ConfigurationManager.getCurrent().getConfigurations();
                RestrictionCriteria noExportConfigs = new RestrictionCriteria("FILETYPE", FilterExpression.Operator.NE, "EXPORT");
                RestrictionCriteriaList restrictions = new RestrictionCriteriaList();
                restrictions.add(noExportConfigs);
                configurations.setRestrictionCriteriaList(restrictions);
                configurations.getResults();
                for (Configuration config : configurations) {
                    if (ConfigurationsView.this.configurationListeners.containsKey(config)) continue;
                    Configuration configuration = config;
                    configuration.getClass();
                    Configuration.ConfigurationListener newListener = new Configuration.ConfigurationListener(configuration, config){

                        public void notify(boolean changed, final Configuration source) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (source.isDeleted()) {
                                        ConfigurationsView.this.viewer.remove((Object)source);
                                    } else {
                                        ConfigurationsView.this.viewer.update((Object)source, null);
                                    }
                                }
                            });
                        }
                    };
                    config.addListener(newListener);
                    ConfigurationsView.this.configurationListeners.put(config, newListener);
                }
                return configurations;
            }
        };
        this.filteredTableComposite.reset();
        this.filteredTableComposite.beginFetch();
        this.schedule((Job)this.job);
    }

    public void refreshViewer() {
        if (this.viewer != null) {
            this.viewer.refresh();
        }
    }

    @Override
    public void disconnected() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ConfigurationsView.super.disconnected();
                if (ConfigurationsView.this.job != null) {
                    ConfigurationsView.this.job.cancel();
                    ConfigurationsView.this.job = null;
                }
                ConfigurationsView.this.filteredTableComposite.reset();
            }
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    protected void setInput(Object input) {
        if (input instanceof Configuration) {
            this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(null);
        }
    }

    @Override
    protected boolean canLinkToSelection() {
        return false;
    }

    @Override
    protected Control getPrimaryControl() {
        return this.filteredTableComposite.getTable();
    }

    @Override
    protected ISelectionProvider getSelectionProvider() {
        return this.filteredTableComposite.getSelectionProvider();
    }

    private class ConfigurationFilter
    extends ViewerFilter {
        private String searchString;

        private ConfigurationFilter() {
        }

        public void setSearchString(String searchString) {
            this.searchString = searchString != null ? searchString : "";
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.searchString == null || this.searchString.trim().length() == 0) {
                return true;
            }
            Configuration config = (Configuration)element;
            return config.getName().contains(this.searchString);
        }
    }
}

