/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.views;

import com.ibm.cics.cm.model.ChangePackage;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.actions.NewDefinitionWizardDropdownAction;
import com.ibm.cics.cm.ui.chgpkg.ChangePackageLabelProvider;
import com.ibm.cics.cm.ui.chgpkg.ChangePackageTreeContentProvider;
import com.ibm.cics.cm.ui.views.CMViewPart;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.eclipse.common.ui.DelegateLabelProvider;
import com.ibm.cics.eclipse.common.ui.TextInput;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class ChangePackagesView
extends CMViewPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String ID = "com.ibm.cics.cm.view.changepackages";
    private TreeViewer packageTreeViewer;
    private boolean groupResourceTypes = true;
    private boolean showPackageChildren = false;
    private ChangePackageTreeContentProvider content;
    private List<ChangePackage.ChangePackageListener> listeners = new ArrayList<ChangePackage.ChangePackageListener>();
    private TreeViewerColumn treeColumn;
    private ChangePackageComparator comparator;
    private List<ViewerFilter> filters = new ArrayList<ViewerFilter>();
    private PackageFilter stringFilter;
    private Label totalsLabel;

    @Override
    protected void setInput(Object input) {
    }

    private void linkFilterTextToViewer(final Text filterText) {
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                ChangePackagesView.this.stringFilter.setValue(filterText.getText());
            }
        };
        filterText.addListener(24, listener);
        filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    ChangePackagesView.this.packageTreeViewer.getTree().setFocus();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    @Override
    protected Control createControl(Composite aComposite) {
        Composite controls = new Composite(aComposite, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 5;
        layout.verticalSpacing = 0;
        controls.setLayout((Layout)layout);
        this.createTotalsLabel(controls);
        this.packageTreeViewer = new TreeViewer(controls, 67584);
        this.packageTreeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.content = new ChangePackageTreeContentProvider();
        this.content.setGroupByResourceType(this.groupResourceTypes);
        this.content.setShowPackageChildren(this.showPackageChildren);
        this.packageTreeViewer.setContentProvider((IContentProvider)this.content);
        this.comparator = new ChangePackageComparator();
        this.packageTreeViewer.setComparator((ViewerComparator)this.comparator);
        this.stringFilter = new PackageFilter();
        this.filters.add(this.stringFilter);
        this.packageTreeViewer.setFilters(this.filters.toArray(new ViewerFilter[0]));
        ChangePackageFilterControl filterBox = new ChangePackageFilterControl(this.stringFilter, this.packageTreeViewer);
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        if (toolBarManager.find("ADDITIONS") == null) {
            Separator filterGroup = new Separator("ADDITIONS");
            toolBarManager.add((IContributionItem)filterGroup);
        }
        toolBarManager.appendToGroup("ADDITIONS", (IContributionItem)filterBox);
        this.getSite().setSelectionProvider((ISelectionProvider)this.packageTreeViewer);
        ChangePackageLabelProvider labels = new ChangePackageLabelProvider();
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        TreeViewerColumn column = this.createColumn(Messages.getString("ChangePackagesView.column.packages"), "CPID", this.packageTreeViewer, true, false, 100, 0);
        column.setLabelProvider((CellLabelProvider)new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DelegateLabelProvider((ILabelProvider)labels), decorator, null));
        this.treeColumn = column;
        this.createAdditionalColumns(this.packageTreeViewer);
        this.packageTreeViewer.getTree().setHeaderVisible(true);
        this.packageTreeViewer.getTree().setLinesVisible(true);
        this.packageTreeViewer.getTree().setSortColumn(this.treeColumn.getColumn());
        this.packageTreeViewer.getTree().setSortDirection(1024);
        this.refresh(false);
        this.packageTreeViewer.getControl().setLayoutData((Object)new GridData(1808));
        Action showPackageContentsAction = new Action(Messages.getString("ChangePackagesView.option.showContents"), 2){

            public void run() {
                if (ChangePackagesView.this.showPackageChildren != this.isChecked()) {
                    ChangePackagesView.this.showPackageChildren = this.isChecked();
                    ChangePackagesView.this.content.setShowPackageChildren(ChangePackagesView.this.showPackageChildren);
                    ChangePackagesView.this.refresh(true);
                }
            }
        };
        IMenuManager dropDownMenu = this.getViewSite().getActionBars().getMenuManager();
        dropDownMenu.add((IAction)showPackageContentsAction);
        this.packageTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IHandlerService handlerService = (IHandlerService)ChangePackagesView.this.getSite().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("com.ibm.cics.cm.ui.chgpkg.command.open", null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.packageTreeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                ChangePackagesView.this.packColumns(ChangePackagesView.this.packageTreeViewer.getTree());
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                ChangePackagesView.this.packColumns(ChangePackagesView.this.packageTreeViewer.getTree());
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.packageTreeViewer);
        this.createPopupMenu();
        return controls;
    }

    @Override
    protected void fillContextMenu(IMenuManager aMenuManager, boolean isCICSConfiguration) {
        aMenuManager.add((IAction)new NewDefinitionWizardDropdownAction("com.ibm.cics.cm.ui.chgpkg.newwizard", isCICSConfiguration));
        aMenuManager.add((IContributionItem)new Separator("new"));
        aMenuManager.add((IContributionItem)new Separator("open"));
        aMenuManager.add((IContributionItem)new Separator("actions"));
        aMenuManager.add((IContributionItem)new Separator("commonActions"));
        aMenuManager.add((IContributionItem)new Separator("clipboard"));
        aMenuManager.add((IContributionItem)new Separator("additions"));
    }

    private void createAdditionalColumns(TreeViewer tv) {
        this.createColumn(Messages.getString("ChangePackagesView.column.description"), "DESCRIPTION", tv, true, true, 200, 2);
        this.createColumn(Messages.getString("ChangePackagesView.column.lastAction"), "LC_APICMD", tv, true, true, 100, 3);
        this.createColumn(Messages.getString("ChangePackagesView.column.changetime"), "LC_DATIME", tv, true, true, 200, 4);
        this.createColumn(Messages.getString("ChangePackagesView.column.lastUser"), "LC_USERID", tv, true, true, 100, 5);
        this.createColumn(Messages.getString("ChangePackagesView.column.lastScheme"), "LC_SCHEME", tv, true, true, 100, 6);
        this.createColumn(Messages.getString("ChangePackagesView.column.lastReturnCode"), "LC_RC", tv, true, true, 120, 7);
        this.createColumn(Messages.getString("ChangePackagesView.column.lastReasonCode"), "LC_RSN", tv, true, true, 120, 8);
        this.createColumn(Messages.getString("ChangePackagesView.column.externalRef"), "EXTREF", tv, true, true, 100, 9);
    }

    private TreeViewerColumn createColumn(String text, String attribute, TreeViewer tv, boolean resize, boolean moveable, int width, int columnIDnum) {
        TreeViewerColumn column = new TreeViewerColumn(tv, 0);
        column.getColumn().setWidth(width);
        column.getColumn().setResizable(resize);
        column.getColumn().setMoveable(moveable);
        column.getColumn().setText(text);
        column.setLabelProvider((CellLabelProvider)new CustomColumnLabelProvider(attribute));
        column.getColumn().addSelectionListener((SelectionListener)this.getSortListener(column, attribute));
        return column;
    }

    private SelectionAdapter getSortListener(final TreeViewerColumn column, final String columnID) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangePackagesView.this.comparator.setColumn(columnID);
                boolean sortAscending = ChangePackagesView.this.comparator.isSortAscending();
                ChangePackagesView.this.packageTreeViewer.getTree().setSortColumn(column.getColumn());
                ChangePackagesView.this.packageTreeViewer.getTree().setSortDirection(sortAscending ? 1024 : 128);
                ChangePackagesView.this.packageTreeViewer.refresh();
            }
        };
        return listener;
    }

    private void packColumns(final Tree tree) {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                TreeColumn[] treeColumnArray = tree.getColumns();
                int n = treeColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeColumn next = treeColumnArray[n2];
                    next.pack();
                    ++n2;
                }
            }
        });
    }

    private Object getInput() {
        IFilteredCollection changePackages = ConfigurationManager.getCurrent().getChangePackages();
        Iterator iterator = changePackages.iterator();
        while (iterator.hasNext()) {
            ChangePackage next;
            ChangePackage changePackage = next = (ChangePackage)iterator.next();
            changePackage.getClass();
            ChangePackage.ChangePackageListener newListener = new ChangePackage.ChangePackageListener(changePackage, next){

                public void notify(boolean changed, ChangePackage source) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ChangePackagesView.this.refresh(false);
                        }
                    });
                }
            };
            this.listeners.add(newListener);
            next.addListener(newListener);
        }
        return changePackages;
    }

    @Override
    protected Control getPrimaryControl() {
        return this.packageTreeViewer.getControl();
    }

    @Override
    protected ISelectionProvider getSelectionProvider() {
        return this.packageTreeViewer;
    }

    @Override
    protected String getHelpContextID() {
        return "com.ibm.cics.cm.ui.view_changepackages";
    }

    @Override
    public void refresh(boolean isUser) {
        for (ChangePackage.ChangePackageListener next : this.listeners) {
            next.dispose();
        }
        Object input = this.getInput();
        this.packageTreeViewer.setInput(input);
        this.packColumns(this.packageTreeViewer.getTree());
        this.setTotalsCount(((IFilteredCollection)input).size(), Messages.getString("CMObjects.ChangePackages"));
    }

    protected void createTotalsLabel(Composite aComposite) {
        this.totalsLabel = new Label(aComposite, 64);
        GridData data = new GridData(4, 128, true, false);
        data.widthHint = 100;
        this.totalsLabel.setLayoutData((Object)data);
        this.totalsLabel.setText("");
    }

    public void setTotalsCount(int size, String objectType) {
        String connectionName = Messages.getString("ChangePackagesView.label.notConnected");
        if (ConfigurationManager.getCurrent() != null && ConfigurationManager.getCurrent().getICMSMConnection() != null && ConfigurationManager.getCurrent().getICMSMConnection().getConfiguration() != null && ConfigurationManager.getCurrent().getICMSMConnection().getConfiguration().getName() != null) {
            connectionName = ConfigurationManager.getCurrent().getICMSMConnection().getConfiguration().getName();
        }
        String totals = MessageFormat.format(Messages.getString("FilteredTableComposite.label.description"), connectionName, objectType, size);
        this.totalsLabel.setText(totals);
        this.totalsLabel.getParent().layout();
        this.totalsLabel.setEnabled(true);
    }

    public void dispose() {
        for (ChangePackage.ChangePackageListener listener : this.listeners) {
            listener.dispose();
        }
        super.dispose();
    }

    @Override
    protected boolean canLinkToSelection() {
        return false;
    }

    private class ChangePackageComparator
    extends ViewerComparator {
        private boolean ascending = true;
        private String columnIndex = "CPID";

        private ChangePackageComparator() {
        }

        public boolean isSortAscending() {
            return this.ascending;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof ChangePackage & e2 instanceof ChangePackage) {
                ChangePackage cp1 = (ChangePackage)e1;
                ChangePackage cp2 = (ChangePackage)e2;
                int result = ((String)cp1.getAttributes().get(this.columnIndex)).compareTo((String)cp2.getAttributes().get(this.columnIndex));
                return this.ascending ? result : -result;
            }
            return 0;
        }

        public void setColumn(String columnID) {
            if (this.columnIndex.matches(columnID)) {
                this.ascending = !this.ascending;
            } else {
                this.columnIndex = columnID;
                this.ascending = true;
            }
        }
    }

    private class ChangePackageFilterControl
    extends ControlContribution {
        private final String EMPTY_BOX_HINT;
        private PackageFilter packageFilter;
        private TreeViewer treeViewer;

        protected ChangePackageFilterControl(PackageFilter pf, TreeViewer tv) {
            super("com.ibm.cics.cm.changepackagefilter");
            this.EMPTY_BOX_HINT = Messages.getString("ChangePackageFilterControl.emptyBoxHint");
            this.packageFilter = pf;
            this.treeViewer = tv;
        }

        protected Control createControl(Composite parent) {
            Composite thisComp = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            thisComp.setLayout((Layout)layout);
            Label filterLabel = new Label(thisComp, 0);
            filterLabel.setText(Messages.getString("ChangePackagesView.label.filter"));
            final Text filterText = new Text(thisComp, 132);
            TextInput.setAccessibleLabel((Text)filterText, (Label)filterLabel);
            GridData data = new GridData(128, 128, true, true);
            filterText.setLayoutData((Object)data);
            filterText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    AccessibleEvent i = e;
                    i.toString();
                    e.result = Messages.getString("ChangePackagesView.tooltip.filter");
                }
            });
            filterText.addListener(24, new Listener(){

                public void handleEvent(Event e) {
                    String filterValue = filterText.getText();
                    if (filterValue.matches(ChangePackageFilterControl.this.EMPTY_BOX_HINT)) {
                        filterValue = "";
                    }
                    ChangePackageFilterControl.this.packageFilter.setValue(filterValue);
                    ChangePackageFilterControl.this.treeViewer.refresh();
                }
            });
            filterText.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 0x1000002) {
                        ChangePackageFilterControl.this.treeViewer.getTree().setFocus();
                    }
                }

                public void keyReleased(KeyEvent e) {
                }
            });
            return thisComp;
        }
    }

    private class CustomColumnLabelProvider
    extends ColumnLabelProvider {
        private String attribute;

        public CustomColumnLabelProvider(String attribute) {
            this.attribute = attribute;
        }

        public String getText(Object element) {
            ChangePackage thing;
            String string;
            StringBuffer result = new StringBuffer();
            if (element instanceof ChangePackage && (string = (String)(thing = (ChangePackage)element).getAttributes().get(this.attribute)) != null) {
                result.append(string);
            }
            return result.toString();
        }
    }

    private class PackageFilter
    extends ViewerFilter {
        private String filterValue = "";

        private PackageFilter() {
        }

        public void setValue(String filterValue) {
            this.filterValue = filterValue;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ChangePackage && StringUtil.hasContent((String)this.filterValue)) {
                boolean match = false;
                ChangePackage cp = (ChangePackage)element;
                Map attributes = cp.getAttributes();
                Collection values = attributes.values();
                for (String next : values) {
                    if (!next.contains(this.filterValue)) continue;
                    match = true;
                }
                return match;
            }
            return true;
        }
    }
}

