/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.search;

import com.ibm.cics.cm.model.CICSFilterAttribute;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ConfigurationOverrides;
import com.ibm.cics.cm.model.FilterAttribute;
import com.ibm.cics.cm.model.FilterAttributeDescriptorComparator;
import com.ibm.cics.cm.model.runtime.RestrictionCriteriaList;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.search.CMDialogSearchQuery;
import com.ibm.cics.cm.ui.search.CMSearchInGroupsQuery;
import com.ibm.cics.cm.ui.search.Messages;
import com.ibm.cics.cm.ui.search.SearchTabGeneric;
import com.ibm.cics.core.model.CICSTypes;
import com.ibm.cics.core.ui.properties.CICSTypePropertySource;
import com.ibm.cics.core.ui.properties.IAttributePropertyDescriptor;
import com.ibm.cics.core.ui.properties.ICICSObjectPropertyDescriptor;
import com.ibm.cics.model.ICICSType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class SearchTabResourceDefinitions
extends SearchTabGeneric {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<CICSFilterAttribute> selectedFilterAttributes = new ArrayList<CICSFilterAttribute>();

    @Override
    protected void createUI() {
        this.tabComposite.setText(Messages.getString("CMSearchDialog.definitionsTab"));
        this.contentComposite = new Composite((Composite)this.parent, 0);
        this.tabComposite.setControl((Control)this.contentComposite);
        GridLayout layout = new GridLayout(3, false);
        this.contentComposite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        this.contentComposite.setLayoutData((Object)data);
        this.searchGroup = new Group(this.contentComposite, 0);
        layout = new GridLayout(3, false);
        this.searchGroup.setLayout((Layout)layout);
        this.searchGroup.setText(Messages.getString("CMSearchDialog.searchCompositeText"));
        data = new GridData(4, 4, true, true);
        this.searchGroup.setLayoutData((Object)data);
        this.addResourceFilters(this.contentComposite, true);
        this.addResourceDefinitionSearch((Composite)this.searchGroup);
        this.addConfigurationSearch((Composite)this.searchGroup, -1);
        this.addGroupSearch((Composite)this.searchGroup, false, -1);
    }

    @Override
    protected void setActiveTab() {
        super.setActiveTab();
        this.dialog.setTitle(Messages.getString("CMSearchDialog.definitionsTitle"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.parent.getShell(), "com.ibm.cics.cm.ui.dialog_search");
    }

    @Override
    protected void okPressed() {
        try {
            String resourceTypeName;
            String name = this.resourceTextBox.getText().trim();
            RestrictionCriteriaList restrictionCriteriaList = null;
            if (this.getType() == null) {
                resourceTypeName = "*";
            } else {
                resourceTypeName = this.getType().getResourceTableName();
                restrictionCriteriaList = this.getRestrictionCriteriaList();
            }
            StringBuffer buffer = new StringBuffer();
            boolean first = true;
            for (String configurationName : this.selectedConfigurations.keySet()) {
                if (!first) {
                    buffer.append(',');
                    buffer.append(' ');
                } else {
                    first = false;
                }
                buffer.append(configurationName);
            }
            String description = MessageFormat.format(Messages.getString("CMSearchDialog.searchDefinitionsDesc"), name, resourceTypeName, buffer.toString());
            CMDialogSearchQuery query = this.selectedGroups.isEmpty() || this.selectedGroups.size() == this.availableGroups.size() ? new CMDialogSearchQuery(description, name, resourceTypeName, restrictionCriteriaList, new ArrayList<Configuration>(this.selectedConfigurations.values())) : new CMSearchInGroupsQuery(description, name, resourceTypeName, restrictionCriteriaList, new ArrayList<Configuration>(this.selectedConfigurations.values()), this.selectedGroups.values());
            UIActivator.executeSearch(query);
            this.selectedConfigurations.clear();
        }
        catch (Exception e) {
            UIActivator.getDefault().logError(Messages.getString("CMSearchDialog.ErrorCouldNotRunSearchQuery"), e);
        }
    }

    @Override
    protected void addListeners() {
        this.addResourceTextListener();
        this.addResourceDropdownListeners();
        if (this.addFilterListener == null) {
            this.addFilterDropdownSelectionListener();
        }
    }

    @Override
    protected void updateFilterAttributes(boolean enabled) {
        this.selectedFilters.clear();
        TableItem[] tableItemArray = this.expressionsTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            tableItem.dispose();
            ++n2;
        }
        this.setCurrentTableItem(null);
        tableItemArray = this.attributesMenu.getItems();
        n = tableItemArray.length;
        n2 = 0;
        while (n2 < n) {
            TableItem menuItem = tableItemArray[n2];
            menuItem.dispose();
            ++n2;
        }
        this.selectedFilterAttributes.clear();
        if (this.addFilterToolItem != null) {
            this.addFilterToolItem.setEnabled(enabled);
        }
        if (enabled) {
            this.setFilterAttributes();
        }
    }

    @Override
    protected void populateFromSelection() {
        this.populateConfigurations();
        this.populateGroups();
        this.populateResourceType();
    }

    @Override
    protected FilterAttribute[] getFilterAttributes() {
        ICICSType cicsType = CICSTypes.findForResourceTableName((String)this.getTypeName());
        CICSTypePropertySource typePropertySource = new CICSTypePropertySource(cicsType);
        IAttributePropertyDescriptor[] propertyDescriptors = typePropertySource.getPropertyDescriptors();
        ConfigurationOverrides overrides = ConfigurationOverrides.getOverrides(null, (String)cicsType.getResourceTableName());
        ArrayList<CICSFilterAttribute> filterAttributes = new ArrayList<CICSFilterAttribute>();
        IAttributePropertyDescriptor[] iAttributePropertyDescriptorArray = propertyDescriptors;
        int n = propertyDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IAttributePropertyDescriptor attributeDescriptor = iAttributePropertyDescriptorArray[n2];
            ICICSObjectPropertyDescriptor descriptor = (ICICSObjectPropertyDescriptor)attributeDescriptor;
            if (overrides.getCMAttribute(descriptor.getAttribute().getCicsName()) != null) {
                filterAttributes.add(new CICSFilterAttribute(descriptor.getAttribute(), descriptor.getDescription(), descriptor.getDisplayName()));
            }
            ++n2;
        }
        Collections.sort(filterAttributes, new FilterAttributeDescriptorComparator());
        return filterAttributes.toArray(new FilterAttribute[filterAttributes.size()]);
    }

    @Override
    protected void addSelectedFilterAttribute(FilterAttribute attribute) {
        if (attribute instanceof CICSFilterAttribute) {
            this.selectedFilterAttributes.add((CICSFilterAttribute)attribute);
        }
    }

    @Override
    protected void removeSelectedFilterAttribute(FilterAttribute attribute) {
        if (attribute instanceof CICSFilterAttribute) {
            this.selectedFilterAttributes.remove((CICSFilterAttribute)attribute);
        }
    }
}

