/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.search;

import com.ibm.cics.cm.cpsm.comm.CMSMConnection;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.FilterAttribute;
import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.cm.model.definitions.ResourceDefinitionFactory;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.RestrictionCriteriaList;
import com.ibm.cics.cm.model.runtime.RestrictionElementList;
import com.ibm.cics.cm.ui.CMUIUtilities;
import com.ibm.cics.cm.ui.ImageFactory;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.composites.FilterComposite;
import com.ibm.cics.cm.ui.composites.FilterCompositeFactory;
import com.ibm.cics.cm.ui.search.CMSearchDialog;
import com.ibm.cics.cm.ui.search.Messages;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.eclipse.common.editor.EditorHelper;
import com.ibm.cics.eclipse.common.ui.TextInput;
import com.ibm.cics.eclipse.common.ui.Utilities;
import com.ibm.cics.model.ICICSType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class SearchTabGeneric {
    private static final Debug debug = new Debug(SearchTabGeneric.class);
    public static final int NOLIMIT = -1;
    public static final int LIMIT_SINGLE = 1;
    protected CMSearchDialog dialog;
    protected TabFolder parent;
    protected TabItem tabComposite;
    protected Composite contentComposite;
    protected Group searchGroup;
    protected Map<Widget, String> errorMessageMap;
    private ConnectionServiceListener connectionListener;
    protected Text resourceTextBox;
    protected ToolBar resourceTypeDropdown;
    protected SelectionAdapter selectTypeListener;
    protected ToolBar typesToolBar;
    protected ToolItem typeToolItem;
    protected Menu typesMenu;
    protected HashMap<ICICSType<?>, String> typesToDescriptiveNames;
    protected ICICSType resourceType;
    protected int configSelectionLimit = -1;
    protected Text configurationsText;
    protected ArrayList<Text> configurationsTextBoxes;
    protected Button chooseConfigsButton;
    protected static Map<String, Configuration> availableConfigurations;
    protected Map<String, Configuration> selectedConfigurations = new HashMap<String, Configuration>();
    protected int groupsSelectionLimit = -1;
    private boolean groupsEditable;
    protected Text groupsText;
    protected Button chooseGroupsButton;
    protected SelectionListener chooseGroupsDialogListener;
    protected Map<String, ResourceDefinitionGroup> selectedGroups = new HashMap<String, ResourceDefinitionGroup>();
    protected Map<String, ResourceDefinitionGroup> availableGroups = new TreeMap<String, ResourceDefinitionGroup>();
    protected Text queryNameText;
    protected Group filterGroup;
    protected FilterCompositeFactory filterCompositeFactory;
    protected FilterComposite filterComposite;
    protected Map<Widget, TableItem> selectedFilters = new HashMap<Widget, TableItem>();
    protected ToolItem addFilterToolItem;
    protected ToolItem delFilterToolItem;
    protected Table expressionsTable;
    protected Menu attributesMenu;
    protected SelectionListener addFilterListener;
    protected Group valueComposite;
    protected StackLayout expressionsStack;
    protected Composite defaultComposite;
    protected TableItem currentTableItem;
    protected FilterComposite.Listener filterCompositeListener;
    protected Composite topValueComposite;
    private float ratio;

    protected abstract void createUI();

    protected abstract void addListeners();

    protected abstract void populateFromSelection();

    protected abstract void okPressed();

    protected TabItem buildTab(TabFolder tabbedPane) {
        this.parent = tabbedPane;
        this.tabComposite = new TabItem(this.parent, 0);
        this.createUI();
        this.errorMessageMap = new HashMap<Widget, String>();
        this.tabComposite.setData("ERRORS", this.errorMessageMap);
        return this.tabComposite;
    }

    protected void connectionChecks() {
        if (ConfigurationManager.getCurrent() == null || ConfigurationManager.getCurrent().getConnection() == null || !ConfigurationManager.getCurrent().getConnection().isConnected()) {
            this.updateErrorStatus((Widget)this.dialog.getButtonCustom(0), Messages.getString("CMSearchDialog.notConnectedError"));
            availableConfigurations.clear();
            this.availableGroups.clear();
        } else {
            this.updateErrorStatus((Widget)this.dialog.getButtonCustom(0), null);
        }
        if (ConfigurationManager.getCurrent() != null) {
            this.connectionListener = new MyConnectionServiceListener();
            ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(this.connectionListener);
        }
    }

    protected void removeGlobalListeners() {
        this.connectionListener.makeStale();
    }

    protected void setDialog(CMSearchDialog dialog) {
        this.dialog = dialog;
    }

    protected void setActiveTab() {
        this.setExistingError();
    }

    protected Composite addResourceDefinitionSearch(Composite parentComposite) {
        Composite resourceSearchComp = new Composite(parentComposite, 0);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        resourceSearchComp.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(2, false);
        resourceSearchComp.setLayout((Layout)layout);
        this.resourceTextBox = this.addResourceNameField(resourceSearchComp);
        this.resourceTypeDropdown = this.addResourceTypeDropdown(resourceSearchComp);
        return resourceSearchComp;
    }

    protected Text addResourceNameField(Composite parent) {
        Label nameLabel = new Label(parent, 0);
        nameLabel.setText(Messages.getString("CMSearchDialog.resourceNameLabel"));
        GridData data = new GridData(4, 4, false, false);
        nameLabel.setLayoutData((Object)data);
        Text resourceTextBox = new Text(parent, 2048);
        TextInput.setAccessibleLabel((Text)resourceTextBox, (Label)nameLabel);
        data = new GridData(4, 4, true, false);
        resourceTextBox.setLayoutData((Object)data);
        resourceTextBox.setText("*");
        resourceTextBox.setToolTipText(Messages.getString("CMSearchDialog.resourceNameLabelToolTip"));
        return resourceTextBox;
    }

    protected ToolBar addResourceTypeDropdown(Composite parent) {
        String[] descriptiveTypeNames;
        int typeWidth;
        Label typeLabel = new Label(parent, 0);
        typeLabel.setText(Messages.getString("CMSearchDialog.resourceTypeLabel"));
        GridData data = new GridData(4, 0x1000000, false, false);
        typeLabel.setLayoutData((Object)data);
        this.typesToolBar = new ToolBar(parent, 0x800000);
        data = new GridData(4, 0x1000000, true, false);
        this.typesToolBar.setLayoutData((Object)data);
        this.typeToolItem = new ToolItem(this.typesToolBar, 0x800004);
        this.typeToolItem.setToolTipText(Messages.getString("CMSearchDialog.resourceTypeLabelToolTip"));
        this.typesMenu = new Menu((Decorations)parent.getShell(), 8);
        this.addResourceDropdownSelectionListener();
        MenuItem menuItem = new MenuItem(this.typesMenu, 8);
        menuItem.setText("*");
        menuItem.addSelectionListener((SelectionListener)this.selectTypeListener);
        menuItem.setData(null);
        this.typesToDescriptiveNames = CMUIUtilities.getTypesToDescriptiveNames();
        String longestName = this.getLongestName(this.typesToDescriptiveNames.values());
        this.typeToolItem.setText(longestName);
        data.minimumWidth = typeWidth = this.typeToolItem.getBounds().width;
        this.typesToolBar.setLayoutData((Object)data);
        String[] stringArray = descriptiveTypeNames = CMUIUtilities.getDescriptiveTypeNames();
        int n = descriptiveTypeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String descriptiveTypeName = stringArray[n2];
            menuItem = new MenuItem(this.typesMenu, 8);
            ICICSType iCICSType = CMUIUtilities.getTypeFromDescriptiveName(descriptiveTypeName);
            menuItem.setData((Object)iCICSType);
            menuItem.setText(descriptiveTypeName);
            menuItem.addSelectionListener((SelectionListener)this.selectTypeListener);
            if (iCICSType.equals(this.dialog.getSeededResourceType())) {
                this.setType(iCICSType);
            }
            ++n2;
        }
        this.setType(null);
        return this.typesToolBar;
    }

    protected Composite addConfigurationSearch(Composite parentComposite, int limit) {
        this.configSelectionLimit = limit;
        this.addConfigurationChooseDialogListener();
        Group configSearchComp = new Group(parentComposite, 0);
        if (this.configSelectionLimit != 1) {
            configSearchComp.setText(Messages.getString("CMSearchDialog.configurationsCompositeTextMultiple"));
        } else {
            configSearchComp.setText(Messages.getString("CMSearchDialog.configurationsCompositeTextSingle"));
        }
        GridData data = new GridData(4, 4, true, false);
        data.horizontalSpan = 3;
        configSearchComp.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(1, false);
        configSearchComp.setLayout((Layout)layout);
        this.configurationsText = new Text((Composite)configSearchComp, 2048);
        this.configurationsText.setEditable(false);
        data = new GridData(4, 4, true, false);
        data.widthHint = 150;
        this.configurationsText.setLayoutData((Object)data);
        if (this.configurationsTextBoxes == null) {
            this.configurationsTextBoxes = new ArrayList();
        }
        this.configurationsTextBoxes.add(this.configurationsText);
        this.chooseConfigsButton = new Button((Composite)configSearchComp, 8);
        this.chooseConfigsButton.setText(Messages.getString("CMSearchDialog.chooseButtonText"));
        data = new GridData(131072, 4, false, false);
        this.chooseConfigsButton.setLayoutData((Object)data);
        this.chooseConfigsButton.addSelectionListener(this.addConfigurationChooseDialogListener());
        return configSearchComp;
    }

    protected Composite addGroupSearch(Composite parentComposite, boolean editable, int limit) {
        this.groupsSelectionLimit = limit;
        this.addGroupsChooseDialogListener();
        this.groupsEditable = editable;
        Group groupSearchComp = new Group(parentComposite, 0);
        this.addGroupSearchText(groupSearchComp);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalSpan = 3;
        groupSearchComp.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(1, false);
        groupSearchComp.setLayout((Layout)layout);
        this.groupsText = new Text((Composite)groupSearchComp, 2048);
        this.groupsText.setEditable(editable);
        data = new GridData(4, 4, true, false);
        data.widthHint = 150;
        this.groupsText.setLayoutData((Object)data);
        this.addGroupToolTipText(this.groupsText);
        this.chooseGroupsButton = new Button((Composite)groupSearchComp, 8);
        this.chooseGroupsButton.setText(Messages.getString("CMSearchDialog.chooseButtonText"));
        data = new GridData(131072, 4, false, false);
        this.chooseGroupsButton.setLayoutData((Object)data);
        this.chooseGroupsButton.addSelectionListener(this.chooseGroupsDialogListener);
        return groupSearchComp;
    }

    protected void addGroupSearchText(Group groupSearchComp) {
        groupSearchComp.setText(Messages.getString("CMSearchDialog.groupsCompositeText"));
    }

    protected void addGroupToolTipText(Text groupsText2) {
    }

    protected Text addGroupWildcardSearch(Composite parentComposite) {
        Label nameLabel = new Label(parentComposite, 0);
        nameLabel.setText(Messages.getString("CMSearchDialog.groupSearchField"));
        GridData data = new GridData(4, 4, false, false);
        nameLabel.setLayoutData((Object)data);
        this.queryNameText = new Text(parentComposite, 2048);
        data = new GridData(4, 4, true, false);
        this.queryNameText.setLayoutData((Object)data);
        this.queryNameText.setText("*");
        this.queryNameText.setToolTipText(Messages.getString("CMSearchDialog.groupSearchFieldToolTip"));
        return this.queryNameText;
    }

    protected Text addListWildcardSearch(Composite parentComposite) {
        Label nameLabel = new Label(parentComposite, 0);
        nameLabel.setText(Messages.getString("CMSearchDialog.listSearchField"));
        GridData data = new GridData(4, 4, false, false);
        nameLabel.setLayoutData((Object)data);
        this.queryNameText = new Text(parentComposite, 2048);
        data = new GridData(4, 4, true, false);
        this.queryNameText.setLayoutData((Object)data);
        this.queryNameText.setText("*");
        this.queryNameText.setToolTipText(Messages.getString("CMSearchDialog.listSearchFieldToolTip"));
        return this.queryNameText;
    }

    protected void addResourceFilters(Composite parent, boolean visible) {
        Group ft = this.addFilterTable(parent);
        Group vt = this.addValueTable(parent);
        ft.setVisible(visible);
        vt.setVisible(visible);
    }

    protected Group addFilterTable(Composite parentComposite) {
        Label testLabel = new Label(this.contentComposite, 0);
        String testText = "A";
        testLabel.setText(testText);
        Point testLabelSize = testLabel.computeSize(-1, -1);
        testLabel.dispose();
        this.ratio = (float)testLabelSize.x / (float)testText.length();
        this.filterGroup = new Group(parentComposite, 0);
        this.filterGroup.setText(Messages.getString("CMSearchDialog.filterGroupTitle"));
        this.filterGroup.setLayout((Layout)new GridLayout(1, false));
        GridData data = new GridData(4, 4, true, true);
        this.filterGroup.setLayoutData((Object)data);
        final ToolBar toolBar = new ToolBar((Composite)this.filterGroup, 0x800000);
        data = new GridData(4, 4, true, false);
        toolBar.setLayoutData((Object)data);
        this.addFilterToolItem = new ToolItem(toolBar, 0x800004);
        this.addFilterToolItem.setImage(ImageFactory.getAddImage());
        this.addFilterToolItem.setToolTipText(Messages.getString("CMSearchDialog.newToolItem"));
        final Menu menu = new Menu((Decorations)parentComposite.getShell(), 8);
        this.addFilterToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Rectangle rect = SearchTabGeneric.this.addFilterToolItem.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = toolBar.toDisplay(pt);
                menu.setLocation(pt.x, pt.y);
                menu.setVisible(true);
            }
        });
        this.addFilterToolItem.setEnabled(this.getType() != null);
        this.attributesMenu = menu;
        this.delFilterToolItem = new ToolItem(toolBar, 8);
        this.delFilterToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selections;
                TableItem[] tableItemArray = selections = SearchTabGeneric.this.expressionsTable.getSelection();
                int n = selections.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    SearchTabGeneric.this.selectedFilters.values().remove(tableItem);
                    SearchTabGeneric.this.updateErrorStatus((Widget)tableItem, null);
                    FilterAttribute selectedFilterAttribute = (FilterAttribute)tableItem.getData();
                    SearchTabGeneric.this.removeSelectedFilterAttribute(selectedFilterAttribute);
                    tableItem.dispose();
                    ++n2;
                }
                SearchTabGeneric.this.setCurrentTableItem(null);
            }
        });
        this.delFilterToolItem.setImage(ImageFactory.getDeleteImage());
        this.delFilterToolItem.setDisabledImage(ImageFactory.getDeleteImage_DISABLED());
        this.delFilterToolItem.setEnabled(false);
        this.delFilterToolItem.setToolTipText(Messages.getString("CMSearchDialog.deleteToolItem"));
        FormToolkit toolkit = EditorHelper.getFormToolkit();
        this.expressionsTable = toolkit.createTable((Composite)this.filterGroup, 67842);
        this.expressionsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SearchTabGeneric.this.expressionsTable.getSelectionCount() == 1) {
                    TableItem tableItem = SearchTabGeneric.this.expressionsTable.getSelection()[0];
                    SearchTabGeneric.this.setCurrentTableItem(tableItem);
                }
            }
        });
        TableLayout tableLayout = new TableLayout();
        this.expressionsTable.setLayout((Layout)tableLayout);
        data = new GridData(4, 4, true, true);
        data.heightHint = 175;
        data.widthHint = 200;
        this.expressionsTable.setLayoutData((Object)data);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        this.expressionsTable.layout();
        return this.filterGroup;
    }

    protected Group addValueTable(Composite parentComposite) {
        this.valueComposite = new Group(parentComposite, 0);
        this.expressionsStack = new StackLayout();
        this.valueComposite.setLayout((Layout)this.expressionsStack);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 0;
        data.heightHint = 0;
        this.valueComposite.setLayoutData((Object)data);
        this.filterCompositeFactory = new FilterCompositeFactory((Composite)this.valueComposite);
        this.defaultComposite = new Composite((Composite)this.valueComposite, 0);
        this.defaultComposite.setLayout((Layout)new FillLayout());
        return this.valueComposite;
    }

    protected String getLongestName(Collection<String> names) {
        String longestName = "";
        for (String name : names) {
            if (longestName.length() >= name.length()) continue;
            longestName = name;
        }
        return longestName;
    }

    protected void updateConfigurationText() {
        if (availableConfigurations != null && availableConfigurations.size() > 0) {
            if (this.selectedConfigurations.size() == availableConfigurations.size()) {
                for (Text t : this.configurationsTextBoxes) {
                    t.setText("*");
                }
            } else {
                for (Text t : this.configurationsTextBoxes) {
                    this.update(t, this.selectedConfigurations.keySet());
                }
            }
        } else {
            for (Text t : this.configurationsTextBoxes) {
                t.setText("");
            }
        }
    }

    protected void checkConfigs() {
        if (this.selectedConfigurations.size() < 1) {
            this.updateErrorStatus((Widget)this.chooseConfigsButton, Messages.getString("CMSearchDialog.configurationsButtonErrorMessage"));
        } else if (this.configSelectionLimit == 1 && this.selectedConfigurations.size() > this.configSelectionLimit) {
            this.updateErrorStatus((Widget)this.chooseConfigsButton, Messages.getString("CMSearchDialog.configurationsSelectedOverLimit"));
        } else {
            this.updateErrorStatus((Widget)this.chooseConfigsButton, null);
        }
    }

    protected void updateGroupText() {
        if (this.availableGroups != null && this.selectedGroups.size() == this.availableGroups.size()) {
            this.groupsText.setText("*");
        } else {
            this.update(this.groupsText, this.selectedGroups.keySet());
        }
    }

    private void update(Text text, Set<String> selections) {
        StringBuffer buffer = new StringBuffer();
        int count = 0;
        for (String selection : selections) {
            buffer.append(selection);
            if (++count >= selections.size()) continue;
            buffer.append(", ");
        }
        text.setText(buffer.toString());
    }

    protected void checkGroups() {
        if (this.chooseGroupsButton != null) {
            boolean isCMCPSMType = this.isCMCPSMType();
            this.chooseGroupsButton.setEnabled(this.selectedConfigurations != null && this.selectedConfigurations.size() == 1 && !isCMCPSMType);
            if (isCMCPSMType) {
                this.clearGroups();
            } else if (this.groupsText != null && this.groupsText.getText().isEmpty()) {
                this.groupsText.setText("*");
            }
        }
    }

    protected boolean isCMCPSMType() {
        return this.resourceType != null ? ResourceDefinitionFactory.isCMCPSMResourceDefinitionType((String)this.resourceType.getResourceTableName()) || ResourceDefinitionFactory.isCMCPSMResourceAssociationType((String)this.resourceType.getResourceTableName()) : false;
    }

    protected void clearCachedData() {
        this.clearConfigurations();
        this.clearGroups();
    }

    protected void clearConfigurations() {
        availableConfigurations.clear();
        this.selectedConfigurations.clear();
        if (this.configurationsText != null) {
            this.configurationsText.setText("");
        }
    }

    protected void clearGroups() {
        this.availableGroups.clear();
        this.selectedGroups.clear();
        if (this.groupsText != null) {
            if (this.isCMCPSMType()) {
                this.groupsText.setText("");
            } else {
                this.groupsText.setText("*");
            }
        }
    }

    protected RestrictionCriteriaList getRestrictionCriteriaList() {
        if (this.expressionsTable.getItemCount() == 0) {
            return null;
        }
        RestrictionCriteriaList restrictionCriteriaList = new RestrictionCriteriaList();
        RestrictionElementList restrictionElementList = new RestrictionElementList();
        TableItem[] tableItemArray = this.expressionsTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            FilterExpression filterExpression = (FilterExpression)tableItem.getData("FILTEREXPRESSION");
            if (filterExpression != null && filterExpression.getValue() != null) {
                restrictionElementList.addUnique(filterExpression.getRestrictionCriteria());
            }
            ++n2;
        }
        restrictionCriteriaList.add(restrictionElementList);
        return restrictionCriteriaList;
    }

    protected void updateErrorStatus(Widget widget, String errorMessage) {
        if (errorMessage == null) {
            this.errorMessageMap.remove(widget);
            this.setExistingError();
        } else {
            this.errorMessageMap.put(widget, errorMessage);
            this.dialog.setErrorMessage(errorMessage);
            if (this.dialog.getButtonCustom(0) != null) {
                this.dialog.getButtonCustom(0).setEnabled(false);
            }
        }
    }

    private void setExistingError() {
        if (this.errorMessageMap != null && this.dialog.getButtonCustom(0) != null) {
            Iterator<Map.Entry<Widget, String>> iterator = this.errorMessageMap.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<Widget, String> next = iterator.next();
                this.dialog.setErrorMessage(next.getValue());
                this.dialog.getButtonCustom(0).setEnabled(false);
            } else {
                this.dialog.setErrorMessage(null);
                this.dialog.getButtonCustom(0).setEnabled(true);
            }
        }
    }

    final void updateOKStatus() {
        this.dialog.getButtonCustom(0).setEnabled(!this.isInError());
    }

    private boolean isInError() {
        return !this.errorMessageMap.isEmpty();
    }

    protected ICICSType getType() {
        return this.resourceType;
    }

    protected void setType(ICICSType aCICSType) {
        if (this.addFilterListener == null) {
            this.addFilterDropdownSelectionListener();
        }
        this.resourceType = aCICSType;
        if (this.resourceType != null) {
            if (this.addFilterToolItem != null) {
                this.addFilterToolItem.setEnabled(true);
            }
            this.typeToolItem.setText(this.typesToDescriptiveNames.get(this.resourceType));
            this.updateFilterAttributes(true);
        } else {
            this.updateFilterAttributes(false);
            this.typeToolItem.setText("*");
        }
        this.forceLayout(false);
        this.checkGroups();
    }

    protected abstract void updateFilterAttributes(boolean var1);

    protected void setFilterAttributes() {
        FilterAttribute[] filterAttributes = this.getFilterAttributes();
        MenuItem[] menuItemArray = this.attributesMenu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = menuItemArray[n2];
            menuItem.dispose();
            ++n2;
        }
        int i = 0;
        while (i < filterAttributes.length) {
            MenuItem menuItem = new MenuItem(this.attributesMenu, 8);
            menuItem.setData((Object)filterAttributes[i]);
            menuItem.setText(filterAttributes[i].getDisplayName());
            menuItem.addSelectionListener(this.addFilterListener);
            ++i;
        }
    }

    protected abstract FilterAttribute[] getFilterAttributes();

    protected String getTypeName() {
        if (this.resourceType == null) {
            return "*";
        }
        return this.resourceType.getResourceTableName();
    }

    protected void forceLayout(boolean valueCompositeOnly) {
        if (this.dialog.getButtonBarCustom() != null) {
            String text = this.valueComposite.getText();
            if (Utilities.hasContent((String)text)) {
                this.valueComposite.setVisible(false);
                this.valueComposite.layout(true, true);
                Point preferredSize = this.valueComposite.computeSize(-1, -1);
                int valueCompositePreferredWidth = preferredSize.x;
                int noCharsNeeded = (int)((float)valueCompositePreferredWidth / this.ratio);
                StringBuffer buffer = new StringBuffer();
                int i = 0;
                while (i < noCharsNeeded) {
                    buffer.append('A');
                    ++i;
                }
                this.valueComposite.setText(buffer.toString());
            }
            this.valueComposite.layout(true, true);
            if (!valueCompositeOnly) {
                this.searchGroup.layout(true, true);
                this.parent.getShell().layout(true, true);
            }
            this.parent.getShell().pack();
            this.valueComposite.setText(text);
            this.valueComposite.setVisible(true);
        }
    }

    protected void setCurrentTableItem(TableItem aTableItem) {
        this.currentTableItem = aTableItem;
        this.delFilterToolItem.setEnabled(aTableItem != null);
        this.showValueComposite(aTableItem);
        this.showFilterComposite(this.expressionsTable.getSelectionCount() > 0);
        this.forceLayout(true);
    }

    protected void showFilterComposite(boolean b) {
        if (!b) {
            this.expressionsStack.topControl = this.defaultComposite;
            this.valueComposite.setText("");
        }
        this.valueComposite.setVisible(b);
    }

    private void showValueComposite(TableItem tableItem) {
        this.valueComposite.setVisible(false);
        if (this.filterComposite != null) {
            this.filterComposite.removeListener(this.filterCompositeListener);
        }
        if (tableItem == null) {
            this.showFilterComposite(false);
            this.filterComposite = null;
        } else {
            if (this.filterCompositeListener == null) {
                this.filterCompositeListener = new FilterComposite.Listener(){

                    @Override
                    public void filterValueChanged(FilterExpression filterExpression) {
                        SearchTabGeneric.this.currentTableItem.setData("FILTEREXPRESSION", (Object)filterExpression);
                        String filterValueString = filterExpression.getDisplayString();
                        SearchTabGeneric.this.currentTableItem.setText(filterValueString);
                    }

                    @Override
                    public void errorMessageChanged(String errorMessage) {
                        SearchTabGeneric.this.updateErrorStatus((Widget)SearchTabGeneric.this.currentTableItem, errorMessage);
                    }
                };
            }
            FilterAttribute attribute = (FilterAttribute)tableItem.getData();
            this.valueComposite.setText(attribute.getDescriptiveName());
            this.filterComposite = this.filterCompositeFactory.createComposite(attribute);
            this.filterComposite.setFilterExpression((FilterExpression)tableItem.getData("FILTEREXPRESSION"));
            this.filterComposite.addListener(this.filterCompositeListener);
            this.filterComposite.initialize();
            this.topValueComposite = this.filterComposite.getComposite();
            this.expressionsStack.topControl = this.topValueComposite;
            this.topValueComposite.layout(true, true);
        }
        this.valueComposite.layout(true, true);
    }

    protected void addResourceTextListener() {
        this.resourceTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!UIActivator.hasContent(SearchTabGeneric.this.resourceTextBox)) {
                    SearchTabGeneric.this.updateErrorStatus((Widget)SearchTabGeneric.this.resourceTextBox, Messages.getString("CMSearchDialog.resourceNameMustBeEnteredWarning"));
                } else {
                    SearchTabGeneric.this.updateErrorStatus((Widget)SearchTabGeneric.this.resourceTextBox, null);
                }
            }
        });
    }

    protected void addResourceDropdownListeners() {
        this.addResourceDropdownDisplayListener();
    }

    protected void addResourceDropdownDisplayListener() {
        this.typeToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Rectangle rect = ((ToolItem)event.widget).getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = SearchTabGeneric.this.typesToolBar.toDisplay(pt);
                SearchTabGeneric.this.typesMenu.setLocation(pt.x, pt.y);
                SearchTabGeneric.this.typesMenu.setVisible(true);
            }
        });
    }

    protected void addResourceDropdownSelectionListener() {
        this.selectTypeListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem selectedMenuItem = (MenuItem)e.getSource();
                ICICSType selectedType = (ICICSType)selectedMenuItem.getData();
                if (selectedType != SearchTabGeneric.this.getType() || selectedType == null || !selectedType.equals(SearchTabGeneric.this.getType())) {
                    if (!SearchTabGeneric.this.errorMessageMap.isEmpty()) {
                        Collection<TableItem> oldFilters = SearchTabGeneric.this.selectedFilters.values();
                        for (TableItem item : oldFilters) {
                            if (!SearchTabGeneric.this.errorMessageMap.containsKey(item)) continue;
                            SearchTabGeneric.this.updateErrorStatus((Widget)item, null);
                        }
                    }
                    SearchTabGeneric.this.setType(selectedType);
                }
            }
        };
    }

    protected void addFilterDropdownSelectionListener() {
        this.addFilterListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem selectedMenuItem = (MenuItem)e.getSource();
                if (!SearchTabGeneric.this.selectedFilters.containsKey(selectedMenuItem)) {
                    TableItem newlyCreatedItem = new TableItem(SearchTabGeneric.this.expressionsTable, 0);
                    FilterAttribute selectedFilterAttribute = (FilterAttribute)selectedMenuItem.getData();
                    newlyCreatedItem.setData((Object)selectedFilterAttribute);
                    newlyCreatedItem.setText(selectedMenuItem.getText());
                    newlyCreatedItem.setImage(ImageFactory.getColumnImage());
                    SearchTabGeneric.this.expressionsTable.setSelection(newlyCreatedItem);
                    SearchTabGeneric.this.setCurrentTableItem(newlyCreatedItem);
                    SearchTabGeneric.this.selectedFilters.put((Widget)selectedMenuItem, newlyCreatedItem);
                    SearchTabGeneric.this.addSelectedFilterAttribute(selectedFilterAttribute);
                } else {
                    TableItem existingItem = SearchTabGeneric.this.selectedFilters.get(selectedMenuItem);
                    SearchTabGeneric.this.expressionsTable.setSelection(existingItem);
                    SearchTabGeneric.this.setCurrentTableItem(existingItem);
                }
            }
        };
    }

    protected SelectionListener addConfigurationChooseDialogListener() {
        SelectionAdapter chooseConfigsDialogListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchTabGeneric.this.getAvailableConfigurations();
                Object[] elements = availableConfigurations.keySet().toArray();
                LabelProvider labelProvider = new LabelProvider(){

                    public String getText(Object element) {
                        if (element instanceof ICMObject) {
                            return ((ICMObject)element).getName();
                        }
                        return super.getText(element);
                    }
                };
                ListSelectionDialog selectionDialog = new ListSelectionDialog(SearchTabGeneric.this.dialog.getShell(), (Object)elements, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)labelProvider, Messages.getString("CMSearchDialog.configurationsDialogTitle"));
                selectionDialog.setHelpAvailable(false);
                Object[] selectedElements = SearchTabGeneric.this.selectedConfigurations.keySet().toArray();
                selectionDialog.setInitialSelections(selectedElements);
                selectionDialog.setTitle(Messages.getString("CMSearchDialog.configurationsDialogTitle"));
                if (selectionDialog.open() == 0) {
                    Object[] results = selectionDialog.getResult();
                    Configuration[] configs = SearchTabGeneric.this.selectedConfigurations.values().toArray(new Configuration[SearchTabGeneric.this.selectedConfigurations.values().size()]);
                    if (!(results.length == 1 && configs.length == 1 && configs[0].equals((Object)availableConfigurations.get(results[0])) || SearchTabGeneric.this.groupsEditable)) {
                        SearchTabGeneric.this.clearGroups();
                    }
                    SearchTabGeneric.this.selectedConfigurations.clear();
                    int i = 0;
                    while (i < results.length) {
                        SearchTabGeneric.this.selectedConfigurations.put((String)results[i], availableConfigurations.get(results[i]));
                        ++i;
                    }
                    SearchTabGeneric.this.checkGroups();
                    SearchTabGeneric.this.checkConfigs();
                    SearchTabGeneric.this.updateConfigurationText();
                    SearchTabGeneric.this.updateOKStatus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                new ElementListSelectionDialog(SearchTabGeneric.this.dialog.getShell(), null);
            }
        };
        return chooseConfigsDialogListener;
    }

    protected void addGroupsChooseDialogListener() {
        this.chooseGroupsDialogListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementListSelectionDialog selectionDialog;
                if (SearchTabGeneric.this.availableGroups.isEmpty()) {
                    try {
                        Configuration[] configs = SearchTabGeneric.this.selectedConfigurations.values().toArray(new Configuration[SearchTabGeneric.this.selectedConfigurations.values().size()]);
                        IFilteredCollection resourceGroups = configs[0].getResourceGroups();
                        for (ResourceDefinitionGroup resourceGroup : resourceGroups) {
                            SearchTabGeneric.this.availableGroups.put(resourceGroup.getName(), resourceGroup);
                        }
                    }
                    catch (Exception e2) {
                        SearchTabGeneric.this.updateErrorStatus((Widget)SearchTabGeneric.this.chooseGroupsButton, Messages.getString("CMSearchDialog.errorRetrievingGroupsMessage"));
                        debug.error("widgetSelected", (Throwable)e2);
                        return;
                    }
                    SearchTabGeneric.this.updateErrorStatus((Widget)SearchTabGeneric.this.chooseGroupsButton, null);
                }
                Object[] elements = SearchTabGeneric.this.availableGroups.keySet().toArray();
                LabelProvider labelProvider = new LabelProvider(){

                    public String getText(Object element) {
                        if (element instanceof ICMObject) {
                            return ((ICMObject)element).getName();
                        }
                        return super.getText(element);
                    }
                };
                if (SearchTabGeneric.this.groupsSelectionLimit != 1) {
                    selectionDialog = new ListSelectionDialog(SearchTabGeneric.this.dialog.getShell(), (Object)elements, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)labelProvider, Messages.getString("CMSearchDialog.groupsDialogTitle"));
                } else {
                    selectionDialog = new ElementListSelectionDialog(SearchTabGeneric.this.dialog.getShell(), (ILabelProvider)labelProvider);
                    selectionDialog.setElements(elements);
                    if (SearchTabGeneric.this.groupsText.getText().length() > 0) {
                        selectionDialog.setFilter(SearchTabGeneric.this.groupsText.getText());
                    }
                }
                Object[] selectedElements = SearchTabGeneric.this.selectedGroups.keySet().toArray();
                selectionDialog.setInitialSelections(selectedElements);
                selectionDialog.setHelpAvailable(false);
                selectionDialog.setTitle(Messages.getString("CMSearchDialog.groupsDialogTitle"));
                if (selectionDialog.open() == 0) {
                    Object[] results = selectionDialog.getResult();
                    SearchTabGeneric.this.selectedGroups.clear();
                    int i = 0;
                    while (i < results.length) {
                        SearchTabGeneric.this.selectedGroups.put((String)results[i], SearchTabGeneric.this.availableGroups.get(results[i]));
                        ++i;
                    }
                    SearchTabGeneric.this.updateGroupText();
                    SearchTabGeneric.this.updateOKStatus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                new ElementListSelectionDialog(SearchTabGeneric.this.dialog.getShell(), null);
            }
        };
    }

    protected void addGroupsTextListener() {
        this.queryNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!UIActivator.hasContent(SearchTabGeneric.this.queryNameText)) {
                    SearchTabGeneric.this.updateErrorStatus((Widget)SearchTabGeneric.this.queryNameText, Messages.getString("CMSearchDialog.groupNameMustBeEnteredWarning"));
                } else {
                    SearchTabGeneric.this.updateErrorStatus((Widget)SearchTabGeneric.this.queryNameText, null);
                }
            }
        });
    }

    protected void getAvailableConfigurations() {
        if (availableConfigurations == null) {
            availableConfigurations = new HashMap<String, Configuration>();
        }
        if (availableConfigurations.isEmpty()) {
            try {
                for (Configuration configuration : ConfigurationManager.getCurrent().getConfigurations().getResults()) {
                    availableConfigurations.put(configuration.getName(), configuration);
                }
            }
            catch (Exception e2) {
                this.updateErrorStatus((Widget)this.chooseConfigsButton, Messages.getString("CMSearchDialog.errorRetrievingConfigurationsMessage"));
                debug.error("getAvailableConfigurations", (Throwable)e2);
                return;
            }
            this.updateErrorStatus((Widget)this.chooseConfigsButton, null);
        }
    }

    protected void populateConfigurations() {
        this.selectedConfigurations = (Map)((HashMap)this.dialog.selectedConfigurations).clone();
        if (this.selectedConfigurations != null) {
            this.checkGroups();
        }
        this.getAvailableConfigurations();
        this.updateConfigurationText();
        this.checkConfigs();
    }

    protected void populateGroups() {
        this.selectedGroups = this.groupsSelectionLimit != 1 ? this.dialog.selectedGroups : (this.dialog.selectedGroups.size() == 1 ? this.dialog.selectedGroups : new HashMap<String, ResourceDefinitionGroup>());
        this.updateGroupText();
    }

    protected void populateResourceType() {
        this.setType(this.dialog.getSeededResourceType());
    }

    protected abstract void addSelectedFilterAttribute(FilterAttribute var1);

    protected abstract void removeSelectedFilterAttribute(FilterAttribute var1);

    private class MyConnectionServiceListener
    extends ConnectionServiceListener {
        static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2008, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        private MyConnectionServiceListener() {
        }

        public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
            if (event.getConnectionCategoryId().equals(CMSMConnection.ID)) {
                if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                    SearchTabGeneric.this.updateOKStatus();
                } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                    SearchTabGeneric.this.updateOKStatus();
                    SearchTabGeneric.this.clearCachedData();
                }
            }
        }
    }
}

