/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.search;

import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.cm.model.ResourceList;
import com.ibm.cics.cm.model.definitions.ResourceDefinition;
import com.ibm.cics.cm.model.definitions.ResourceDefinitionFactory;
import com.ibm.cics.cm.ui.CMUIUtilities;
import com.ibm.cics.cm.ui.ImageFactory;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.search.CMSearchQuery;
import com.ibm.cics.cm.ui.search.Messages;
import com.ibm.cics.cm.utilities.Utilities;
import com.ibm.cics.core.ui.UIPlugin;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;

public class SearchResultTreeBuilder {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2020 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<String> configurations = new ArrayList<String>();
    private Map<String, TreeItem> configurationsToTreeItems = new HashMap<String, TreeItem>();
    private Map<String, Map<String, TreeItem>> configurationsToTypes = new TreeMap<String, Map<String, TreeItem>>();
    private Map<String, Map<String, Map<String, TreeItem>>> configurationsToGroupsToTypes = new TreeMap<String, Map<String, Map<String, TreeItem>>>();
    private Map<TreeItem, Map<String, TreeItem>> typesToResources = new HashMap<TreeItem, Map<String, TreeItem>>();
    private Map<ResourceDefinition, TreeItem> allResourceTreeItems = new HashMap<ResourceDefinition, TreeItem>();
    private List<ICMObject> resources = new ArrayList<ICMObject>();
    private Map<String, Map<String, TreeItem>> configurationsToResourceGroups = new TreeMap<String, Map<String, TreeItem>>();
    private Map<String, Map<String, TreeItem>> configurationsToResourceLists = new TreeMap<String, Map<String, TreeItem>>();
    private Map<TreeItem, Map<String, TreeItem>> groupsToResources = new HashMap<TreeItem, Map<String, TreeItem>>();
    private Map<TreeItem, Map<String, TreeItem>> configurationsToResources = new HashMap<TreeItem, Map<String, TreeItem>>();
    private Map<String, TreeItem> allResources = new TreeMap<String, TreeItem>();
    private Queue<ICMObject> queue = new LinkedList<ICMObject>();
    private Tree tree;
    private ResourceDefinition selection;
    private boolean updating;
    private CMSearchQuery currentSearch;
    private CMSearchQuery.Listener searchListener;
    protected String NAME = "NAME";
    private String COUNT = "COUNT";
    private List<TotalsListener> listeners = new ArrayList<TotalsListener>();
    private int total;
    private boolean showGroups;
    private boolean cancelled;

    public SearchResultTreeBuilder(Tree aTree) {
        this.tree = aTree;
        this.searchListener = new CMSearchQuery.Listener(){

            @Override
            public void addResults(List results) {
                for (Object definition : results) {
                    if (!SearchResultTreeBuilder.this.currentSearch.isRunning()) continue;
                    if (definition instanceof ICMObject) {
                        SearchResultTreeBuilder.this.addToTree((ICMObject)definition);
                        continue;
                    }
                    return;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToTree(ICMObject aResourceDefinition) {
        this.resources.add(aResourceDefinition);
        SearchResultTreeBuilder searchResultTreeBuilder = this;
        synchronized (searchResultTreeBuilder) {
            this.queue.add(aResourceDefinition);
        }
        if (!this.updating) {
            this.updateTree();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTree() {
        while (!this.queue.isEmpty()) {
            ICMObject icmObject;
            this.updating = true;
            SearchResultTreeBuilder searchResultTreeBuilder = this;
            synchronized (searchResultTreeBuilder) {
                icmObject = this.queue.poll();
            }
            Configuration configuration = this.getConfiguration(icmObject);
            Tree parent = this.tree;
            Map<String, TreeItem> resources = null;
            if (this.currentSearch.hasMultipleSources()) {
                String configurationName = configuration.getName();
                TreeItem configurationTreeItem = this.configurationsToTreeItems.get(configurationName);
                if (configurationTreeItem == null) {
                    this.insertIntoTree(this.tree, (ICMObject)configuration, this.configurations, this.configurationsToTreeItems);
                    configurationTreeItem = this.configurationsToTreeItems.get(configurationName);
                }
                if (this.cancelled) {
                    return;
                }
                parent = configurationTreeItem;
            }
            if (this.currentSearch.hasLists()) {
                TreeItem resourceListTreeItem;
                ResourceList resourceList = this.getResourceList(icmObject);
                Map<String, TreeItem> resourceListsToTreeItem = this.configurationsToResourceLists.get(configuration.getName());
                if (resourceListsToTreeItem == null) {
                    resourceListsToTreeItem = new TreeMap<String, TreeItem>();
                    this.configurationsToResourceLists.put(configuration.getName(), resourceListsToTreeItem);
                }
                if ((resourceListTreeItem = resourceListsToTreeItem.get(resourceList.getName())) == null) {
                    this.insertTreeItem((Widget)parent, resourceList, new ArrayList<String>(resourceListsToTreeItem.keySet()), resourceListsToTreeItem);
                    resourceListTreeItem = resourceListsToTreeItem.get(resourceList.getName());
                }
                if (this.cancelled) {
                    return;
                }
            }
            Map<String, TreeItem> sourcesToTypes = null;
            if (this.showGroups && this.currentSearch.hasGroups()) {
                TreeItem resourceGroupTreeItem;
                ResourceDefinitionGroup resourceGroup = this.getResourceGroup(icmObject);
                Map<String, TreeItem> resourceGroupsToTreeItem = this.configurationsToResourceGroups.get(configuration.getName());
                if (resourceGroupsToTreeItem == null) {
                    resourceGroupsToTreeItem = new TreeMap<String, TreeItem>();
                    this.configurationsToResourceGroups.put(configuration.getName(), resourceGroupsToTreeItem);
                }
                if ((resourceGroupTreeItem = resourceGroupsToTreeItem.get(resourceGroup.getName())) == null) {
                    this.insertTreeItem((Widget)parent, resourceGroup, new ArrayList<String>(resourceGroupsToTreeItem.keySet()), resourceGroupsToTreeItem);
                    resourceGroupTreeItem = resourceGroupsToTreeItem.get(resourceGroup.getName());
                }
                if (this.cancelled) {
                    return;
                }
                parent = resourceGroupTreeItem;
                Map<String, Map<String, TreeItem>> groupsToTypes = this.configurationsToGroupsToTypes.get(configuration.getName());
                if (groupsToTypes == null) {
                    groupsToTypes = new TreeMap<String, Map<String, TreeItem>>();
                    this.configurationsToGroupsToTypes.put(configuration.getName(), groupsToTypes);
                }
                if (this.currentSearch.hasMultipleTypes()) {
                    sourcesToTypes = groupsToTypes.get(resourceGroup.getName());
                    if (sourcesToTypes == null) {
                        sourcesToTypes = new TreeMap<String, TreeItem>();
                        groupsToTypes.put(resourceGroup.getName(), sourcesToTypes);
                    }
                } else {
                    resources = this.groupsToResources.get((TreeItem)parent);
                    if (resources == null) {
                        resources = new TreeMap<String, TreeItem>();
                        this.groupsToResources.put((TreeItem)parent, resources);
                    }
                }
            } else if (this.currentSearch.hasMultipleTypes()) {
                sourcesToTypes = this.configurationsToTypes.get(configuration.getName());
                if (sourcesToTypes == null) {
                    sourcesToTypes = new TreeMap<String, TreeItem>();
                    this.configurationsToTypes.put(configuration.getName(), sourcesToTypes);
                }
            } else if (parent instanceof TreeItem) {
                resources = this.configurationsToResources.get((TreeItem)parent);
                if (resources == null) {
                    resources = new TreeMap<String, TreeItem>();
                    this.configurationsToResources.put((TreeItem)parent, resources);
                }
            } else {
                resources = this.allResources;
                if (resources == null) {
                    this.allResources = resources = new TreeMap<String, TreeItem>();
                }
            }
            if (this.currentSearch.hasMultipleTypes()) {
                String typeName = ((ResourceDefinition)icmObject).getType();
                TreeItem typeTreeItem = sourcesToTypes.get(typeName);
                if (typeTreeItem == null) {
                    this.insertTypeTreeItem((Widget)parent, typeName, new ArrayList<String>(sourcesToTypes.keySet()), sourcesToTypes);
                    typeTreeItem = sourcesToTypes.get(typeName);
                }
                if (this.cancelled) {
                    return;
                }
                parent = typeTreeItem;
                resources = this.typesToResources.get(typeTreeItem);
                if (resources == null) {
                    resources = new TreeMap<String, TreeItem>();
                    this.typesToResources.put(typeTreeItem, resources);
                }
            }
            if (this.currentSearch.hasResources()) {
                this.insertTreeItem((Widget)parent, (ResourceDefinition)icmObject, new ArrayList<String>(resources.keySet()), resources, this.allResourceTreeItems);
            }
            if (this.cancelled) {
                return;
            }
            if (!icmObject.equals(this.selection)) continue;
            final TreeItem treeItem = this.allResourceTreeItems.get(icmObject);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (SearchResultTreeBuilder.this.cancelled) {
                        return;
                    }
                    SearchResultTreeBuilder.this.tree.setSelection(treeItem);
                }
            });
        }
        this.updating = false;
    }

    private ResourceList getResourceList(ICMObject icmObject) {
        if (icmObject instanceof ResourceList) {
            return (ResourceList)icmObject;
        }
        return null;
    }

    private ResourceDefinitionGroup getResourceGroup(ICMObject icmObject) {
        if (icmObject instanceof ResourceDefinitionGroup) {
            return (ResourceDefinitionGroup)icmObject;
        }
        if (icmObject instanceof ResourceDefinition) {
            return ((ResourceDefinition)icmObject).getResourceGroup();
        }
        return null;
    }

    private Configuration getConfiguration(ICMObject icmObject) {
        if (icmObject instanceof ResourceList) {
            return ((ResourceList)icmObject).getConfiguration();
        }
        if (icmObject instanceof ResourceDefinitionGroup) {
            return ((ResourceDefinitionGroup)icmObject).getConfiguration();
        }
        if (icmObject instanceof ResourceDefinition) {
            return ((ResourceDefinition)icmObject).getConfiguration();
        }
        return null;
    }

    private void insertTreeItem(final Widget parent, final ResourceDefinition resourceDefinition, final ArrayList<String> existingElements, final Map<String, TreeItem> existingResources, final Map<ResourceDefinition, TreeItem> allResourceTreeItems) {
        final int indexToInsert = Utilities.getIndexForEBCDICSortedTreeItem(existingElements, resourceDefinition.getName());
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!existingElements.contains(resourceDefinition.getName())) {
                    String tempStr;
                    if (SearchResultTreeBuilder.this.cancelled) {
                        return;
                    }
                    TreeItem treeItem = parent instanceof TreeItem ? new TreeItem((TreeItem)parent, 0, indexToInsert) : new TreeItem((Tree)parent, 0, indexToInsert);
                    String text = resourceDefinition.getName();
                    String type = resourceDefinition.getType();
                    if ((ResourceDefinitionFactory.isCMCPSMResourceAssociationType((String)type) || ResourceDefinitionFactory.isCMCPSMResourceDefinitionType((String)type)) && (tempStr = CMUIUtilities.getDescriptiveNameForCPSMNoGroupResource((ICMDefinition)resourceDefinition)) != null) {
                        text = tempStr;
                    }
                    treeItem.setText(text);
                    treeItem.setData((Object)resourceDefinition);
                    allResourceTreeItems.put(resourceDefinition, treeItem);
                    existingResources.put(resourceDefinition.getName(), treeItem);
                    treeItem.setData(SearchResultTreeBuilder.this.NAME, (Object)resourceDefinition.getName());
                    treeItem.setData(SearchResultTreeBuilder.this.COUNT, (Object)new Integer(1));
                    if (type.equals("CSGLCGCS")) {
                        type = "CSYSDEF";
                    } else if (type.equals("CSGLCGCG")) {
                        type = "CSYSGRP";
                    } else if (type.equals("LNKSWSCS")) {
                        type = "WLMSPEC";
                    } else if (type.equals("LNKSWSCG")) {
                        type = "WLMSPEC";
                    } else if (type.equals("WLMINSPC")) {
                        type = "WLMGROUP";
                    } else if (type.equals("WLMINGRP")) {
                        type = "WLMDEF";
                    } else if (type.equals("DTRINGRP")) {
                        type = "TRANGRP";
                    }
                    ImageDescriptor imageDescriptor = UIPlugin.getImageDescriptor((String)("icons/" + type + ".GIF"));
                    if (imageDescriptor != null) {
                        treeItem.setImage(UIActivator.getImage(imageDescriptor));
                    } else {
                        treeItem.setImage(ImageFactory.getGeneralImage());
                    }
                } else {
                    TreeItem subTreeItem;
                    TreeItem treeItem = (TreeItem)existingResources.get(resourceDefinition.getName());
                    if (SearchResultTreeBuilder.this.cancelled) {
                        return;
                    }
                    Object data = treeItem.getData();
                    if (data != null) {
                        ResourceDefinition definition = (ResourceDefinition)data;
                        if (SearchResultTreeBuilder.this.cancelled) {
                            return;
                        }
                        subTreeItem = new TreeItem(treeItem, 0);
                        String subItemText = SearchResultTreeBuilder.this.getInGroupText(definition);
                        if (subItemText.isEmpty()) {
                            subItemText = SearchResultTreeBuilder.this.getVersionText(definition);
                        }
                        subTreeItem.setText(subItemText);
                        subTreeItem.setData((Object)definition);
                        ImageDescriptor imageDescriptor = UIPlugin.getImageDescriptor((String)("icons/" + resourceDefinition.getType() + ".GIF"));
                        if (imageDescriptor != null) {
                            subTreeItem.setImage(UIActivator.getImage(imageDescriptor));
                        } else {
                            subTreeItem.setImage(ImageFactory.getGeneralImage());
                        }
                    }
                    if (SearchResultTreeBuilder.this.cancelled) {
                        return;
                    }
                    subTreeItem = new TreeItem(treeItem, 0);
                    String subItemText = SearchResultTreeBuilder.this.getInGroupText(resourceDefinition);
                    if (subItemText.isEmpty()) {
                        subItemText = SearchResultTreeBuilder.this.getVersionText(resourceDefinition);
                    }
                    subTreeItem.setText(subItemText);
                    subTreeItem.setData((Object)resourceDefinition);
                    ImageDescriptor imageDescriptor = UIPlugin.getImageDescriptor((String)("icons/" + resourceDefinition.getType() + ".GIF"));
                    if (imageDescriptor != null) {
                        subTreeItem.setImage(UIActivator.getImage(imageDescriptor));
                    } else {
                        subTreeItem.setImage(ImageFactory.getGeneralImage());
                    }
                    if (SearchResultTreeBuilder.this.cancelled) {
                        return;
                    }
                    Integer count = (Integer)treeItem.getData(SearchResultTreeBuilder.this.COUNT);
                    count = count + 1;
                    treeItem.setData(SearchResultTreeBuilder.this.COUNT, (Object)count);
                    treeItem.setData(null);
                    SearchResultTreeBuilder.this.updateTreeItemText(treeItem);
                }
                SearchResultTreeBuilder.this.updateParentTotal(parent);
            }
        });
        existingElements.add(indexToInsert, resourceDefinition.getName());
    }

    protected String getInGroupText(ResourceDefinition resourceDefinition) {
        ResourceDefinitionGroup resourceGroup = resourceDefinition.getResourceGroup();
        if (resourceGroup == null) {
            return "";
        }
        return MessageFormat.format(Messages.getString("SearchResultTreeBuilder.InGroup"), resourceDefinition.getName(), resourceGroup.getName());
    }

    protected String getVersionText(ResourceDefinition resourceDefinition) {
        Map attributes = resourceDefinition.getAttributes();
        if (attributes.containsKey("DEFVER")) {
            String version = (String)attributes.get("DEFVER");
            return MessageFormat.format(Messages.getString("SearchResultTreeBuilder.Version"), resourceDefinition.getName(), version);
        }
        return "";
    }

    private void insertTypeTreeItem(final Widget parent, final String typeName, List<String> existingElements, final Map<String, TreeItem> typesToTreeItems) {
        final int indexToInsert = Utilities.getIndexForEBCDICSortedTreeItem(existingElements, typeName);
        existingElements.add(indexToInsert, typeName);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (SearchResultTreeBuilder.this.cancelled) {
                    return;
                }
                TreeItem treeItem = parent instanceof Tree ? new TreeItem((Tree)parent, 0, indexToInsert) : new TreeItem((TreeItem)parent, 0, indexToInsert);
                typesToTreeItems.put(typeName, treeItem);
                String name = CMUIUtilities.getDescriptiveTypeName(typeName);
                if (name == null) {
                    name = typeName;
                }
                treeItem.setText(name);
                treeItem.setData(SearchResultTreeBuilder.this.NAME, (Object)name);
                treeItem.setImage(ImageFactory.getFolderImage());
            }
        });
    }

    private void insertTreeItem(final Widget parent, final ResourceDefinitionGroup resourceGroup, ArrayList<String> existingElements, final Map<String, TreeItem> resourceGroupsToTreeItem) {
        final int indexToInsert = Utilities.getIndexForEBCDICSortedTreeItem(existingElements, resourceGroup.getName());
        existingElements.add(indexToInsert, resourceGroup.getName());
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (SearchResultTreeBuilder.this.cancelled) {
                    return;
                }
                TreeItem treeItem = parent instanceof Tree ? new TreeItem((Tree)parent, 0, indexToInsert) : new TreeItem((TreeItem)parent, 0, indexToInsert);
                resourceGroupsToTreeItem.put(resourceGroup.getName(), treeItem);
                treeItem.setText(resourceGroup.getName());
                treeItem.setData(SearchResultTreeBuilder.this.NAME, (Object)resourceGroup.getName());
                treeItem.setData((Object)resourceGroup);
                treeItem.setImage(UIActivator.getImage(SearchResultTreeBuilder.this.getAdapter(resourceGroup).getImageDescriptor((Object)resourceGroup)));
                if (!SearchResultTreeBuilder.this.currentSearch.hasResources()) {
                    SearchResultTreeBuilder.this.updateParentTotal(parent);
                }
            }
        });
    }

    private void insertTreeItem(final Widget parent, final ResourceList resourceList, ArrayList<String> existingElements, final Map<String, TreeItem> resourceListsToTreeItem) {
        final int indexToInsert = Utilities.getIndexForEBCDICSortedTreeItem(existingElements, resourceList.getName());
        existingElements.add(indexToInsert, resourceList.getName());
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (SearchResultTreeBuilder.this.cancelled) {
                    return;
                }
                TreeItem treeItem = parent instanceof Tree ? new TreeItem((Tree)parent, 0, indexToInsert) : new TreeItem((TreeItem)parent, 0, indexToInsert);
                resourceListsToTreeItem.put(resourceList.getName(), treeItem);
                treeItem.setText(resourceList.getName());
                treeItem.setData(SearchResultTreeBuilder.this.NAME, (Object)resourceList.getName());
                treeItem.setData((Object)resourceList);
                treeItem.setImage(UIActivator.getImage(SearchResultTreeBuilder.this.getAdapter(resourceList).getImageDescriptor((Object)resourceList)));
                if (!SearchResultTreeBuilder.this.currentSearch.hasResources()) {
                    SearchResultTreeBuilder.this.updateParentTotal(parent);
                }
            }
        });
    }

    private void insertIntoTree(final Tree parent, final ICMObject anICMObject, List<String> existingElements, Map<String, TreeItem> configurationsToTreeItems2) {
        final int indexToInsert = Utilities.getIndexForEBCDICSortedTreeItem(existingElements, anICMObject.getName());
        existingElements.add(indexToInsert, anICMObject.getName());
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (SearchResultTreeBuilder.this.cancelled) {
                    return;
                }
                TreeItem treeItem = new TreeItem(parent, 0, indexToInsert);
                treeItem.setText(anICMObject.getName());
                treeItem.setData((Object)anICMObject);
                SearchResultTreeBuilder.this.configurationsToTreeItems.put(anICMObject.getName(), treeItem);
                treeItem.setData(SearchResultTreeBuilder.this.NAME, (Object)anICMObject.getName());
                treeItem.setImage(UIActivator.getImage(SearchResultTreeBuilder.this.getAdapter(anICMObject).getImageDescriptor((Object)anICMObject)));
            }
        });
    }

    protected void updateTreeItemText(TreeItem treeItem) {
        StringBuffer buffer = new StringBuffer((String)treeItem.getData(this.NAME));
        buffer.append(' ');
        buffer.append('(');
        buffer.append((Integer)treeItem.getData(this.COUNT));
        buffer.append(')');
        treeItem.setText(buffer.toString());
    }

    private IDeferredWorkbenchAdapter getAdapter(Object adaptable) {
        String adapterTypeName = IDeferredWorkbenchAdapter.class.getName();
        IDeferredWorkbenchAdapter adapter = (IDeferredWorkbenchAdapter)Platform.getAdapterManager().loadAdapter(adaptable, adapterTypeName);
        return adapter;
    }

    protected void updateParentTotal(Widget widget) {
        if (widget instanceof TreeItem) {
            TreeItem parent = (TreeItem)widget;
            StringBuffer buffer = new StringBuffer((String)parent.getData(this.NAME));
            Integer parentCount = (Integer)parent.getData(this.COUNT);
            if (parentCount == null) {
                parentCount = new Integer(0);
            }
            parentCount = parentCount + 1;
            buffer.append(' ');
            buffer.append('(');
            buffer.append(parentCount);
            buffer.append(')');
            parent.setText(buffer.toString());
            parent.setData(this.COUNT, (Object)parentCount);
            TreeItem parentItem = parent.getParentItem();
            if (parentItem != null) {
                this.updateParentTotal((Widget)parentItem);
            } else {
                this.updateTotalsLabel();
            }
        } else {
            this.updateTotalsLabel();
        }
    }

    private void updateTotalsLabel() {
        ++this.total;
        for (TotalsListener listener : this.listeners) {
            listener.totalChanged(this.total);
        }
    }

    public void setSelection(ResourceDefinition selection) {
        this.selection = selection;
    }

    public void cancelSearch(CMSearchQuery query) {
        query.removeListener(this.searchListener);
        this.queue.clear();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TreeItem[] items;
                if (SearchResultTreeBuilder.this.tree.isDisposed()) {
                    return;
                }
                TreeItem[] treeItemArray = items = SearchResultTreeBuilder.this.tree.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem treeItem = treeItemArray[n2];
                    if (!treeItem.isDisposed()) {
                        treeItem.dispose();
                    }
                    ++n2;
                }
                if (SearchResultTreeBuilder.this.tree.isDisposed()) {
                    return;
                }
                SearchResultTreeBuilder.this.tree.removeAll();
            }
        });
        this.configurations.clear();
        this.allResourceTreeItems.clear();
        this.configurationsToTreeItems.clear();
        this.configurationsToTypes.clear();
        this.typesToResources.clear();
        this.configurationsToGroupsToTypes.clear();
        this.configurationsToResourceGroups.clear();
        this.configurationsToResourceLists.clear();
        this.groupsToResources.clear();
        this.configurationsToResources.clear();
        this.allResources.clear();
        this.resources.clear();
        this.total = 0;
        this.cancelled = true;
    }

    public void startSearch(CMSearchQuery query) {
        this.updating = false;
        this.cancelled = false;
        this.currentSearch = query;
        query.addListener(this.searchListener);
        query.start();
    }

    public void addTotalResultsListener(TotalsListener listener) {
        this.listeners.add(listener);
    }

    public void setShowGroups(boolean show) {
        this.showGroups = show;
    }

    public static interface TotalsListener {
        public void totalChanged(int var1);
    }
}

