/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.search;

import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.eclipse.common.ui.JobWithCancelingSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public abstract class CMSearchQuery {
    protected String description;
    protected ArrayList<Listener> listeners = new ArrayList();
    protected List<QueryJob> jobs;
    private List<CompletionListener> completionListeners;
    protected int status = 0;
    public static final int RUNNING = 1;
    public static final int CANCELLED = 2;
    public static final int COMPLETE = 3;
    protected List<Configuration> configurations;
    private List<ICMDefinition> totalResults = new ArrayList<ICMDefinition>();
    private IWorkbenchSiteProgressService siteService;

    public CMSearchQuery(String aDescription) {
        this.description = aDescription;
    }

    public void setWorkbenchPSiterogressService(IWorkbenchSiteProgressService aSiteService) {
        this.siteService = aSiteService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.jobs = Collections.synchronizedList(new ArrayList());
        if (this.hasRun() || this.cancelled()) {
            QueryJob job = new QueryJob(this, this.description){

                @Override
                protected void getResults() {
                    this.notifyListeners(totalResults);
                }
            };
            if (this.siteService != null) {
                this.siteService.schedule((Job)job, 0L, true);
            } else {
                job.schedule();
            }
            List<QueryJob> list = this.jobs;
            synchronized (list) {
                this.jobs.add(job);
            }
            return;
        }
        this.status = 1;
        for (final Configuration configuration : this.configurations) {
            QueryJob job = new QueryJob(this, this.description){

                @Override
                protected void getResults() {
                    List results = this.getDefinitions(configuration);
                    if (!this.cancelled()) {
                        totalResults.addAll(results);
                        this.notifyListeners(results);
                    }
                }
            };
            if (this.siteService != null) {
                this.siteService.schedule((Job)job, 0L, true);
            } else {
                job.schedule();
            }
            List<QueryJob> list = this.jobs;
            synchronized (list) {
                this.jobs.add(job);
            }
        }
    }

    protected abstract List getDefinitions(Configuration var1);

    public void addListener(Listener searchListener) {
        this.listeners.add(searchListener);
    }

    protected void notifyListeners(List<ICMDefinition> results) {
        ArrayList copyOfListeners = (ArrayList)this.listeners.clone();
        for (Listener listener : copyOfListeners) {
            listener.addResults(results);
        }
    }

    public void removeListener(Listener searchListener) {
        this.listeners.remove(searchListener);
    }

    public void addCompletionListener(CompletionListener completionListener) {
        if (this.completionListeners == null) {
            this.completionListeners = new ArrayList<CompletionListener>();
        }
        this.completionListeners.add(completionListener);
    }

    public void removeCompletionListener(CompletionListener completionListener) {
        this.completionListeners.remove(completionListener);
    }

    public String getDescription() {
        return this.description;
    }

    protected void signalDone() {
        if (this.hasRun() && this.completionListeners != null) {
            for (CompletionListener listener : this.completionListeners) {
                listener.complete();
            }
        }
    }

    public boolean hasRun() {
        return this.status == 3;
    }

    public boolean isRunning() {
        ArrayList<QueryJob> clonedList = new ArrayList<QueryJob>(this.jobs);
        for (JobWithCancelingSupport jobWithCancelingSupport : clonedList) {
            if (jobWithCancelingSupport.getState() != 4 && jobWithCancelingSupport.getState() != 2) continue;
            return true;
        }
        return false;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean cancelled() {
        return this.status == 2;
    }

    public boolean hasMultipleSources() {
        return this.configurations.size() > 1;
    }

    public abstract boolean hasMultipleTypes();

    public boolean hasGroups() {
        return true;
    }

    public boolean hasLists() {
        return false;
    }

    public boolean hasResources() {
        return true;
    }

    public boolean showGroups() {
        return false;
    }

    public void cancel() {
        ArrayList<QueryJob> clonedJobs = new ArrayList<QueryJob>();
        if (this.jobs != null) {
            clonedJobs.addAll(this.jobs);
        }
        for (QueryJob job : clonedJobs) {
            job.cancel();
        }
    }

    public boolean allowGroups() {
        return true;
    }

    public static interface CompletionListener {
        public void complete();
    }

    public static interface Listener {
        public static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        public void addResults(List var1);
    }

    protected abstract class QueryJob
    extends JobWithCancelingSupport {
        protected QueryJob(String desciption) {
            super(desciption);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cancelingSub() {
            List<QueryJob> list = CMSearchQuery.this.jobs;
            synchronized (list) {
                CMSearchQuery.this.jobs.remove((Object)this);
            }
            CMSearchQuery.this.signalDone();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    UIActivator.cancelSearch();
                    ((QueryJob)QueryJob.this).CMSearchQuery.this.status = 2;
                }
            });
            ArrayList<QueryJob> clonedList = new ArrayList<QueryJob>(CMSearchQuery.this.jobs);
            for (QueryJob job : clonedList) {
                if (job == this || job.getState() != 4 && job.getState() != 2) continue;
                job.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus runSub(IProgressMonitor monitor) {
            try {
                monitor.beginTask(CMSearchQuery.this.description, -1);
                this.getResults();
                List<QueryJob> list = CMSearchQuery.this.jobs;
                synchronized (list) {
                    CMSearchQuery.this.jobs.remove((Object)this);
                }
                if (CMSearchQuery.this.jobs.isEmpty()) {
                    CMSearchQuery.this.status = 3;
                }
                CMSearchQuery.this.signalDone();
            }
            catch (Exception e) {
                this.cancelingSub();
                CMSearchQuery.this.signalDone();
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }

        protected abstract void getResults();
    }
}

