/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.search;

import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.cm.model.runtime.RestrictionCriteriaList;
import com.ibm.cics.cm.ui.search.CMDialogSearchQuery;
import com.ibm.cics.cm.ui.search.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CMSearchInGroupsQuery
extends CMDialogSearchQuery {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Collection<ResourceDefinitionGroup> resourceGroups;

    public CMSearchInGroupsQuery(String description, String resourceName, String resourceType, RestrictionCriteriaList restrictionCriteriaList, List<Configuration> configurationList, Collection<ResourceDefinitionGroup> resourceGroups) {
        super(description, resourceName, resourceType, restrictionCriteriaList, configurationList);
        this.resourceGroups = resourceGroups;
    }

    public CMSearchInGroupsQuery(String description, String resourceName, String resourceType, RestrictionCriteriaList restrictionCriteriaList, Configuration configuration, ResourceDefinitionGroup resourceGroup) {
        super(description, resourceName, resourceType, restrictionCriteriaList, configuration);
        this.resourceGroups = new ArrayList<ResourceDefinitionGroup>();
        this.resourceGroups.add(resourceGroup);
    }

    @Override
    protected synchronized List<ICMDefinition> getDefinitions(Configuration configuration) {
        ArrayList results = (ArrayList)this.configurationsToResults.get(configuration);
        if (results == null) {
            results = new ArrayList();
            for (ResourceDefinitionGroup resourceGroup : this.resourceGroups) {
                IFilteredCollection definitions = resourceGroup.getDefinitions();
                definitions.setObjectName(this.resourceName);
                definitions.setObjectType(this.resourceType);
                if (this.restrictionCriteriaList != null) {
                    definitions.setRestrictionCriteriaList(this.copyRestrictionCriteriaList(this.restrictionCriteriaList));
                }
                results.addAll(definitions.getResults());
            }
        }
        return results;
    }

    @Override
    public String getDescription() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.getDescription());
        buffer.append(" ");
        if (this.resourceGroups.size() > 1) {
            buffer.append(Messages.getString("CMGroupSearchQuery.SearchDescriptionGroups"));
        } else {
            buffer.append(Messages.getString("CMGroupSearchQuery.SearchDescriptionGroup"));
        }
        buffer.append(' ');
        int count = 0;
        for (ResourceDefinitionGroup resourceGroup : this.resourceGroups) {
            buffer.append(resourceGroup.getName());
            if (++count < this.resourceGroups.size()) {
                buffer.append(Messages.getString("CMGroupSearchQuery.SearchDescriptionSeparator"));
            }
            buffer.append(" ");
        }
        return buffer.toString();
    }
}

