/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.search;

import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.cm.ui.search.CMSearchQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CMSearchForGroupsQuery
extends CMSearchQuery {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String searchString;
    protected List<Pattern> searchPatterns;

    public CMSearchForGroupsQuery(String description, String searchString, List<Configuration> configurationList) {
        super(description);
        this.searchString = searchString;
        this.configurations = configurationList;
        this.parseSearchTerms();
    }

    @Override
    protected synchronized List<ResourceDefinitionGroup> getDefinitions(Configuration configuration) {
        List allGroups = configuration.getResourceGroups().getResults();
        ArrayList<ResourceDefinitionGroup> matchedGroups = new ArrayList<ResourceDefinitionGroup>();
        block0: for (ResourceDefinitionGroup group : allGroups) {
            for (Pattern p : this.searchPatterns) {
                Matcher m = p.matcher(group.getName());
                if (!m.matches()) continue;
                matchedGroups.add(group);
                continue block0;
            }
        }
        return matchedGroups;
    }

    @Override
    public String getDescription() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.getDescription());
        return buffer.toString();
    }

    @Override
    public boolean hasMultipleTypes() {
        return false;
    }

    @Override
    public boolean hasResources() {
        return false;
    }

    @Override
    public boolean showGroups() {
        return true;
    }

    private void parseSearchTerms() {
        if (this.searchPatterns != null) {
            this.searchPatterns.clear();
        } else {
            this.searchPatterns = new ArrayList<Pattern>();
        }
        this.searchString = this.searchString.replaceAll(" ", "");
        String[] temp = this.searchString.split(",");
        int i = 0;
        while (i < temp.length) {
            temp[i] = temp[i].trim();
            temp[i] = temp[i].replaceAll("\\+", ".");
            temp[i] = temp[i].replaceAll("\\*", ".*");
            Pattern p = Pattern.compile(temp[i]);
            this.searchPatterns.add(p);
            ++i;
        }
    }

    @Override
    public boolean allowGroups() {
        return false;
    }
}

