/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.search;

import com.ibm.cics.cm.model.CMUtilities;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.cm.ui.ImageFactory;
import com.ibm.cics.cm.ui.adapters.SMCMResourceGroupAdapterFactory;
import com.ibm.cics.cm.ui.search.Messages;
import com.ibm.cics.cm.ui.search.SearchTabGeneric;
import com.ibm.cics.cm.ui.search.SearchTabGroups;
import com.ibm.cics.cm.ui.search.SearchTabHistory;
import com.ibm.cics.cm.ui.search.SearchTabLists;
import com.ibm.cics.cm.ui.search.SearchTabResourceDefinitions;
import com.ibm.cics.core.model.CICSTypes;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICSDGroupDefinition;
import com.ibm.cics.model.IResourceGroupDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.ui.IWorkbenchWindow;

public class CMSearchDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String FILTEREXPRESSION = "FILTEREXPRESSION";
    public static final String OPERATOR = "OPERATOR";
    public static final String ERRORS = "ERRORS";
    public static final int RESOURCE = 0;
    public static final int GROUP = 1;
    public static final int LIST = 2;
    public static final int HISTORY = 3;
    private IStructuredSelection selection;
    private int currentSelectedTab;
    protected Map<String, Configuration> selectedConfigurations = new HashMap<String, Configuration>();
    protected Map<String, ResourceDefinitionGroup> selectedGroups = new HashMap<String, ResourceDefinitionGroup>();
    protected ICICSType seededCICSType;
    protected ICICSType selectedCICSType;
    protected ICICSDefinition selectedDefinition;
    private Composite parent;
    private ArrayList<SearchTabGeneric> tabs;
    private ShellListener shellListener;
    private TabFolder tabbedComposite;

    public CMSearchDialog(Shell parentShell, IWorkbenchWindow workbenchWindow, ICICSType type, int searchTypeFlag) {
        super(parentShell);
        this.setTitleImage(ImageFactory.getSearchWizardBanner());
        this.currentSelectedTab = searchTypeFlag;
        this.seededCICSType = type;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10 | 0x100000);
        this.populateSelections(workbenchWindow);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("CMSearchDialog.shellTitle"));
    }

    protected Control createDialogArea(Composite parent) {
        this.parent = parent;
        this.tabs = new ArrayList();
        this.tabbedComposite = new TabFolder(parent, -1);
        this.tabbedComposite.setLayoutData((Object)new GridData(1808));
        this.tabs.add(new SearchTabResourceDefinitions());
        this.tabs.add(new SearchTabGroups());
        this.tabs.add(new SearchTabLists());
        this.tabs.add(new SearchTabHistory());
        for (SearchTabGeneric tab : this.tabs) {
            tab.setDialog(this);
            tab.buildTab(this.tabbedComposite);
            tab.addListeners();
            tab.populateFromSelection();
        }
        this.shellListener = new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                for (SearchTabGeneric tab : CMSearchDialog.this.tabs) {
                    tab.connectionChecks();
                }
                CMSearchDialog.this.tabChanged();
            }
        };
        this.getShell().addShellListener(this.shellListener);
        this.tabbedComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CMSearchDialog.this.tabChanged();
            }
        });
        this.tabbedComposite.setSelection(this.currentSelectedTab);
        this.tabChanged();
        return this.tabbedComposite;
    }

    protected void cancelPressed() {
        for (SearchTabGeneric tab : this.tabs) {
            tab.removeGlobalListeners();
        }
        this.getShell().removeShellListener(this.shellListener);
        super.cancelPressed();
    }

    private void tabChanged() {
        int selectedTab = this.tabbedComposite.getSelectionIndex();
        SearchTabGeneric liveTab = this.tabs.get(selectedTab);
        liveTab.setActiveTab();
    }

    protected void okPressed() {
        int selectedTab = this.tabbedComposite.getSelectionIndex();
        SearchTabGeneric liveTab = this.tabs.get(selectedTab);
        liveTab.okPressed();
        for (SearchTabGeneric tab : this.tabs) {
            tab.removeGlobalListeners();
        }
        super.okPressed();
    }

    private void populateSelections(IWorkbenchWindow workbenchWindow) {
        this.selection = (IStructuredSelection)workbenchWindow.getSelectionService().getSelection();
        if (this.selection != null) {
            for (Object object : this.selection) {
                if (object instanceof Configuration) {
                    Configuration configuration = (Configuration)object;
                    this.selectedConfigurations.put(configuration.getName(), configuration);
                    continue;
                }
                if (object instanceof ResourceDefinitionGroup) {
                    ResourceDefinitionGroup group = (ResourceDefinitionGroup)object;
                    this.selectedGroups.put(group.getName(), group);
                    this.selectedConfigurations.put(group.getConfiguration().getName(), group.getConfiguration());
                    continue;
                }
                if (object instanceof ICICSDefinition) {
                    ICICSDefinition definition = (ICICSDefinition)object;
                    ICICSType tempCICSType = CICSTypes.findForImplementation(definition.getClass());
                    if (!CMUtilities.isValidResourceTypeForRelease((ICICSType)tempCICSType)) continue;
                    this.selectedCICSType = tempCICSType;
                    this.selectedDefinition = definition;
                    continue;
                }
                if (!(object instanceof IResourceGroupDefinition) && !(object instanceof ICSDGroupDefinition)) continue;
                SMCMResourceGroupAdapterFactory resourceGroupAdapterFactory = new SMCMResourceGroupAdapterFactory();
                ResourceDefinitionGroup group = (ResourceDefinitionGroup)resourceGroupAdapterFactory.getAdapter(object, ResourceDefinitionGroup.class);
                this.selectedGroups.put(group.getName(), group);
                this.selectedConfigurations.put(group.getConfiguration().getName(), group.getConfiguration());
            }
        }
    }

    protected Button getButtonCustom(int id) {
        return this.getButton(id);
    }

    protected Control getButtonBarCustom() {
        return this.getButtonBar();
    }

    protected ICICSType getSeededResourceType() {
        return this.seededCICSType;
    }
}

