/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.history;

import com.ibm.cics.cm.model.HistoryEntry;
import com.ibm.cics.cm.ui.history.ZfsDefinitionType;
import com.ibm.cics.core.model.CICSTypes;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSType;
import java.util.Map;

public class ResourceDefinitionType {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final ICICSType<?> underlyingResourceType;

    public ResourceDefinitionType(ICICSType<?> resourceType) {
        this.underlyingResourceType = resourceType;
    }

    public static ResourceDefinitionType getResourceDefinitionType(String type) {
        ICICSType resourceType = CICSTypes.findForResourceTableName((String)type);
        if (resourceType == null && type.equals("ZFSFILE")) {
            return new ZfsDefinitionType();
        }
        return new ResourceDefinitionType(resourceType);
    }

    public String getAttributeName(String attribute) {
        ICICSAttribute cicsAttribute;
        if (this.underlyingResourceType != null && (cicsAttribute = this.underlyingResourceType.findAttributeByCicsName(attribute)) != null) {
            return cicsAttribute.getPropertyId();
        }
        return attribute;
    }

    public String[] getOrderedAttributeNames(Map<String, HistoryEntry.Change> changes) {
        return changes.keySet().toArray(new String[0]);
    }

    public boolean isRestorable() {
        return this.underlyingResourceType != null;
    }
}

