/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.history;

import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.FilterAttribute;
import com.ibm.cics.cm.model.FilterAttributeDescriptorComparator;
import com.ibm.cics.cm.model.HistoryFilterAttribute;
import com.ibm.cics.cm.ui.CMUIUtilities;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.model.ICICSType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class HistoryFilterAttributeFactory
implements Constants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String[] filterNames = new String[]{"JNLOBJTYPE", "JNLOBJNAME", "JNLOBJGROUP", "JNLAPI_COMMAND", "JNLUSERID", "JNLCPID", "JNLSCHEME", "FROMDATE", "TODATE"};
    private static String[] searchFilterNames = new String[]{"JNLAPI_COMMAND", "JNLUSERID", "JNLCPID", "JNLSCHEME", "FROMDATE", "TODATE"};
    private static String[] historyFilterNames = new String[]{"JNLOBJTYPE", "JNLOBJNAME", "JNLOBJGROUP", "JNLAPI_COMMAND", "JNLUSERID", "JNLCPID", "JNLSCHEME"};
    private static String[] commands = new String[]{"ADD", "ALTER", "BACKOUT", "COPY", "CREATE", "DELETE", "DISCARD", "IMPORT", "INSTALL", "MIGRATE", "NEWCOPY", "REMOVE", "RENAME", "UPDATE"};
    private static Map<String, String> commandMapping = new HashMap<String, String>();
    private static Map<String, String> typeMapping = new HashMap<String, String>();

    static {
        String[] stringArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            String command = stringArray[n2];
            String displayName = Messages.getString(command);
            commandMapping.put(displayName, command);
            ++n2;
        }
        HashMap<ICICSType<?>, String> typesToDescriptiveNames = CMUIUtilities.getTypesToDescriptiveNames();
        for (Map.Entry<ICICSType<?>, String> entry : typesToDescriptiveNames.entrySet()) {
            String resourceTableName = entry.getKey().getResourceTableName();
            typeMapping.put(entry.getValue(), resourceTableName);
        }
    }

    public static Map<String, HistoryFilterAttribute> getFilterAttributes() {
        HashMap<String, HistoryFilterAttribute> filterMap = new HashMap<String, HistoryFilterAttribute>();
        Map<String, String> mapping = null;
        String[] stringArray = filterNames;
        int n = filterNames.length;
        int n2 = 0;
        while (n2 < n) {
            Class type;
            String filterAttributeName = stringArray[n2];
            if ("JNLAPI_COMMAND".equals(filterAttributeName)) {
                mapping = commandMapping;
                type = Enum.class;
            } else if ("JNLOBJTYPE".equals(filterAttributeName)) {
                type = Enum.class;
                mapping = typeMapping;
            } else {
                type = "TODATE".equals(filterAttributeName) || "FROMDATE".equals(filterAttributeName) ? Date.class : String.class;
            }
            HistoryFilterAttribute historyFilterAttribute = new HistoryFilterAttribute(filterAttributeName, Messages.getString(filterAttributeName), Messages.getString(filterAttributeName), type);
            if (mapping != null) {
                historyFilterAttribute.setValueMapping(mapping);
            }
            mapping = null;
            type = null;
            filterMap.put(filterAttributeName, historyFilterAttribute);
            ++n2;
        }
        return filterMap;
    }

    public static Map<String, HistoryFilterAttribute> getHistoryFilters() {
        Map<String, HistoryFilterAttribute> filterMap = HistoryFilterAttributeFactory.getFilterAttributes();
        HashMap<String, HistoryFilterAttribute> filters = new HashMap<String, HistoryFilterAttribute>();
        String[] stringArray = historyFilterNames;
        int n = historyFilterNames.length;
        int n2 = 0;
        while (n2 < n) {
            String attributeName = stringArray[n2];
            filters.put(attributeName, filterMap.get(attributeName));
            ++n2;
        }
        return filters;
    }

    public static FilterAttribute[] getSearchFilters() {
        Map<String, HistoryFilterAttribute> filterMap = HistoryFilterAttributeFactory.getFilterAttributes();
        ArrayList<HistoryFilterAttribute> filters = new ArrayList<HistoryFilterAttribute>();
        String[] stringArray = searchFilterNames;
        int n = searchFilterNames.length;
        int n2 = 0;
        while (n2 < n) {
            String attributeName = stringArray[n2];
            filters.add(filterMap.get(attributeName));
            ++n2;
        }
        Collections.sort(filters, new FilterAttributeDescriptorComparator());
        HistoryFilterAttribute[] searchFilters = filters.toArray(new HistoryFilterAttribute[filters.size()]);
        return searchFilters;
    }

    public static HistoryFilterAttribute createHistoryFilterAttribute(String resourceName, String attributeName, Class<?> type, Map<String, String> mapping) {
        HistoryFilterAttribute historyFilterAttribute = new HistoryFilterAttribute(attributeName, Messages.getString(attributeName), Messages.getString(attributeName), type);
        historyFilterAttribute.getFilterExpression().setValue((Object)resourceName);
        historyFilterAttribute.setValueMapping(mapping);
        return historyFilterAttribute;
    }

    public static HistoryFilterAttribute getNameFilter(String resourceName) {
        HistoryFilterAttribute historyFilterAttribute = HistoryFilterAttributeFactory.createHistoryFilterAttribute(resourceName, "JNLOBJNAME", String.class, null);
        return historyFilterAttribute;
    }

    public static HistoryFilterAttribute getTypeFilter(String resourceType) {
        HistoryFilterAttribute historyFilterAttribute = HistoryFilterAttributeFactory.createHistoryFilterAttribute(resourceType, "JNLOBJTYPE", Enum.class, typeMapping);
        return historyFilterAttribute;
    }

    public static HistoryFilterAttribute getGroupFilter(String groupName) {
        HistoryFilterAttribute historyFilterAttribute = HistoryFilterAttributeFactory.createHistoryFilterAttribute(groupName, "JNLOBJGROUP", String.class, null);
        return historyFilterAttribute;
    }
}

