/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.history;

import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.model.HistoryFilterAttribute;
import com.ibm.cics.cm.model.runtime.IRestrictionCriteria;
import com.ibm.cics.cm.ui.views.HistoryView;
import org.eclipse.jface.action.IAction;

public class HistoryFilter
implements Constants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String filterAttributeName;
    private String displayValue;
    private FilterExpression.Operator operator = FilterExpression.Operator.EQ;
    private IAction action;
    private HistoryView.IControlEditor editor;
    private HistoryFilterAttribute historyFilterAttribute;
    private FilterExpression filterExpression;

    public HistoryFilter(HistoryFilterAttribute historyFilterAttribute) {
        this.setHistoryFilterAttribute(historyFilterAttribute);
    }

    public void reset() {
        this.setOperator(FilterExpression.Operator.EQ);
        this.clear();
    }

    public void clear() {
        this.clearControl();
        this.displayValue = null;
        this.filterExpression.setValue(null);
    }

    public void setControlEditor(HistoryView.IControlEditor editor) {
        this.editor = editor;
    }

    public void clearControl() {
        this.editor.clearControl();
    }

    public IAction getAction() {
        return this.action;
    }

    public void setAction(IAction action) {
        this.action = action;
    }

    public FilterExpression.Operator getOperator() {
        return this.operator;
    }

    public void setOperator(FilterExpression.Operator operator) {
        this.operator = operator;
        this.filterExpression.setOperator(operator);
    }

    public String[] getValues() {
        return this.historyFilterAttribute.getDisplayValues();
    }

    public String getDisplayName() {
        return this.historyFilterAttribute.getDisplayName();
    }

    public IRestrictionCriteria getRestrictionCriteria() {
        return this.filterExpression.getRestrictionCriteria();
    }

    public void setDisplayValue(String selectedValue) {
        this.displayValue = selectedValue;
        if (this.filterExpression == null) {
            this.filterExpression = this.historyFilterAttribute.getFilterExpression();
        }
        this.filterExpression.setValue((Object)this.historyFilterAttribute.getValue(selectedValue));
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public String getAttributeName() {
        return this.filterAttributeName;
    }

    public void setHistoryFilterAttribute(HistoryFilterAttribute historyFilterAttribute) {
        this.historyFilterAttribute = historyFilterAttribute;
        this.filterAttributeName = historyFilterAttribute.getAPIName();
        this.filterExpression = historyFilterAttribute.getFilterExpression();
        if (this.filterExpression.getValue() != null) {
            this.displayValue = historyFilterAttribute.getDisplayName(this.filterExpression.getValue());
        }
    }
}

