/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.handlers;

import com.ibm.cics.cm.model.ZfsDefinition;
import com.ibm.cics.cm.model.runtime.CMServerDeleteException;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.eclipse.common.ViewHelper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class ZfsDefinitionDeleteHandler
extends AbstractHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static Logger logger = Logger.getLogger("com.ibm.cics.cm.model");

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            final ArrayList<ZfsDefinition> zfsDefsToDelete = new ArrayList<ZfsDefinition>();
            String zfsDefsString = "";
            for (Object element : ((IStructuredSelection)selection).toList()) {
                if (!(element instanceof ZfsDefinition)) continue;
                ZfsDefinition zfsDef = (ZfsDefinition)element;
                zfsDefsString = String.valueOf(zfsDefsString) + "\n" + zfsDef.getName();
                zfsDefsToDelete.add(zfsDef);
            }
            if (!zfsDefsToDelete.isEmpty()) {
                String[] buttons = new String[2];
                int yesIndex = 0;
                int noIndex = 1;
                buttons[yesIndex] = IDialogConstants.YES_LABEL;
                buttons[noIndex] = IDialogConstants.NO_LABEL;
                MessageDialog mBox = new MessageDialog(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell(), Messages.getString("Messages.title.confirmDelete"), null, MessageFormat.format(Messages.getString("ZfsDefinitionsView.message.confirmDelete"), zfsDefsString), 3, buttons, yesIndex);
                if (mBox.open() == 0) {
                    Job deleteJob = new Job(Messages.getString("ZfsDefinitionsView.delete.job.text")){

                        protected IStatus run(IProgressMonitor monitor) {
                            monitor.beginTask(Messages.getString("ZfsDefinitionsView.delete.job.text"), zfsDefsToDelete.size());
                            int i = 1;
                            boolean allOK = true;
                            for (ZfsDefinition toDelete : zfsDefsToDelete) {
                                String zfsDefName = toDelete.getName();
                                monitor.subTask(MessageFormat.format(Messages.getString("ZfsDefinitionsView.delete.job.text"), zfsDefName));
                                boolean result = false;
                                try {
                                    result = toDelete.delete();
                                }
                                catch (CMServerDeleteException e) {
                                    Status status = new Status(2, "com.ibm.cics.cm.ui", MessageFormat.format(Messages.getString("ZfsDefinitionsView.delete.failure"), e.getReturnResponse()));
                                    UIActivator.getDefault().getLog().log((IStatus)status);
                                    ViewHelper.setDeferredStatusErrorMessage((String)status.getMessage());
                                    allOK = false;
                                }
                                if (result) {
                                    ViewHelper.setDeferredStatusInformationMessage((String)MessageFormat.format(Messages.getString("ZfsDefinitionsView.delete.success"), zfsDefName));
                                }
                                monitor.worked(i++);
                            }
                            return allOK ? Status.OK_STATUS : Integer.valueOf(4);
                        }
                    };
                    deleteJob.schedule();
                }
            }
        }
        return null;
    }
}

