/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.handlers;

import java.util.List;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;

public class CopyPasteHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final LocalSelectionTransfer SUPPORTED_TRANSFER = LocalSelectionTransfer.getTransfer();

    public static void setClipboardSelection(IStructuredSelection selection) {
        SUPPORTED_TRANSFER.setSelection((ISelection)selection);
        Clipboard clipboard = new Clipboard(Display.getDefault());
        clipboard.setContents(new Object[]{selection}, new Transfer[]{SUPPORTED_TRANSFER});
    }

    public static <T> List<T> getClipboardSelectionAsList(Class<T> selectionType) {
        TransferData[] transferDataArray;
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        TransferData[] transferDataArray2 = transferDataArray = clipboard.getAvailableTypes();
        int n = transferDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISelection definitionSelection;
            TransferData transferData = transferDataArray2[n2];
            if (SUPPORTED_TRANSFER.isSupportedType(transferData) && !(definitionSelection = SUPPORTED_TRANSFER.getSelection()).isEmpty() && definitionSelection instanceof IStructuredSelection) {
                for (Object o : (IStructuredSelection)definitionSelection) {
                    if (selectionType.isAssignableFrom(o.getClass())) continue;
                    return null;
                }
                return ((IStructuredSelection)definitionSelection).toList();
            }
            ++n2;
        }
        return null;
    }

    public static ISelection getClipboardSelection() {
        TransferData[] transferDataArray;
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        TransferData[] transferDataArray2 = transferDataArray = clipboard.getAvailableTypes();
        int n = transferDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData transferData = transferDataArray2[n2];
            if (SUPPORTED_TRANSFER.isSupportedType(transferData)) {
                ISelection definitionSelection = SUPPORTED_TRANSFER.getSelection();
                return definitionSelection;
            }
            ++n2;
        }
        return null;
    }
}

