/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.editors;

import com.ibm.cics.cm.model.CICSConfiguration;
import com.ibm.cics.cm.model.CMObject;
import com.ibm.cics.cm.model.CPSMConfiguration;
import com.ibm.cics.cm.model.CSDConfiguration;
import com.ibm.cics.cm.model.ChangePackage;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.PackageCommand;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.cm.model.ResourceList;
import com.ibm.cics.cm.model.runtime.CMServerAddException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.ui.CMUIUtilities;
import com.ibm.cics.cm.ui.ConfigurationsViewLabelProvider;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.chgpkg.ChangePackageLabelProvider;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.model.AbstractCICSDefinitionType;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.model.ICICSType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class PackageCommandsDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    PackageCommand.Type commandType = null;
    private Mode uiMode = Mode.RESOURCE;
    ICMDefinition sourceDef = null;
    String targetGrpString;
    ResourceDefinitionGroup targetGrp = null;
    ResourceDefinitionGroup sourceGrp = null;
    ResourceList targetList = null;
    Configuration configForTarget = null;
    private List<ICMObject> sourceObjects = new ArrayList<ICMObject>();
    private ChangePackage changePackage;
    private List<Configuration> cicsConfigurations;
    private List<Configuration> csdConfigurations;
    private List<Configuration> cpsmConfigurations;
    private Button selectedCmdButton = null;
    Button addCmdButton;
    Button remCmdButton;
    private Button delCmdButton;
    Button beforeButton;
    Button afterButton;
    Button metaResourceButton;
    Button metaGroupButton;
    Button metaListButton;
    ComboViewer packageCombo;
    private ComboViewer configurationCombo;
    private ComboViewer groupCombo;
    private ComboViewer typeCombo;
    private ComboViewer nameCombo;
    ComboViewer positionCombo;
    Label containerTypeLabel;
    private Group containerGroup;
    ComboViewer contNameCombo;
    ComboViewer targetConfCombo;
    private Label groupComboLabel;
    private Label typeComboLabel;
    private Label nameComboLabel;
    private ListViewer listViewer;
    private boolean beforeAfterSupported = true;
    private ISelection savedTypeSelection = null;
    private ISelection savedNameSelection = null;
    private ISelection savedGroupSelection = null;
    private ISelection savedListSelection = null;
    private ISelection savedConfigSelection = null;
    private Configuration initialConfig = null;
    List<Configuration> listConfigs = null;
    Map<Configuration, List<PackageCommand>> mapConfigsToPackageCommands = null;

    public PackageCommandsDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(48);
    }

    public PackageCommandsDialog(Shell parentShell, ChangePackage cp) {
        this(parentShell);
        this.changePackage = cp;
        this.initialiseData();
    }

    public PackageCommandsDialog(Shell parentShell, ChangePackage cp, List<ICMObject> inputObjects) {
        this(parentShell, cp);
        this.sourceObjects = inputObjects;
        this.initialiseData();
    }

    public void initialiseData() {
        if (this.sourceObjects.size() > 0) {
            ICMObject icmObject = this.sourceObjects.get(0);
            if (icmObject instanceof ICMDefinition) {
                this.uiMode = Mode.RESOURCE;
                this.initialConfig = ((ICMDefinition)icmObject).getConfiguration();
                this.savedGroupSelection = new StructuredSelection((Object)((ICMDefinition)icmObject).getResourceGroup());
                this.savedTypeSelection = new StructuredSelection((Object)CMUIUtilities.getTypeFromDescriptiveName(CMUIUtilities.getDescriptiveTypeName(((ICMDefinition)icmObject).getType())));
                this.savedNameSelection = new StructuredSelection((Object)icmObject);
            } else if (icmObject instanceof ResourceDefinitionGroup) {
                this.uiMode = Mode.GROUP;
                this.initialConfig = ((ResourceDefinitionGroup)icmObject).getConfiguration();
                this.savedGroupSelection = new StructuredSelection((Object)icmObject);
            } else if (icmObject instanceof ResourceList) {
                if (ConfigurationManager.getCurrent().getConnection().getRelease() < 540) {
                    this.uiMode = Mode.RESOURCE;
                    this.sourceObjects = Collections.emptyList();
                } else {
                    this.uiMode = Mode.LIST;
                    this.initialConfig = ((ResourceList)icmObject).getConfiguration();
                    this.savedListSelection = new StructuredSelection((Object)icmObject);
                }
            }
        }
    }

    private void initialiseUI() {
        if (this.changePackage != null && this.packageCombo != null) {
            this.packageCombo.setSelection((ISelection)new StructuredSelection((Object)this.changePackage), true);
        }
        if (this.commandType != null) {
            switch (this.commandType) {
                case ADD: {
                    this.selectedCmdButton = this.addCmdButton;
                    break;
                }
                case REMOVE: {
                    this.selectedCmdButton = this.remCmdButton;
                    break;
                }
                case DELETE: {
                    this.selectedCmdButton = this.delCmdButton;
                }
            }
            if (this.selectedCmdButton != null) {
                this.selectedCmdButton.setSelection(true);
            }
        }
        this.metaResourceButton.setSelection(this.uiMode == Mode.RESOURCE);
        this.metaGroupButton.setSelection(this.uiMode == Mode.GROUP);
        this.metaListButton.setSelection(this.uiMode == Mode.LIST);
        if (this.initialConfig != null) {
            this.savedConfigSelection = new StructuredSelection((Object)this.initialConfig);
            IFilteredCollection groupsCollection = this.initialConfig.getResourceGroups();
            this.groupCombo.setInput((Object)groupsCollection.getResults());
        }
        switch (this.uiMode) {
            case RESOURCE: {
                this.configurationCombo.setInput(this.cicsConfigurations);
                this.configurationCombo.setSelection(this.savedConfigSelection);
                this.groupComboLabel.setEnabled(true);
                this.groupCombo.getCombo().setEnabled(true);
                this.groupCombo.setSelection(this.savedGroupSelection);
                this.typeComboLabel.setEnabled(true);
                this.typeCombo.getCombo().setEnabled(true);
                this.typeCombo.setSelection(this.savedTypeSelection);
                this.nameComboLabel.setEnabled(true);
                this.nameCombo.getCombo().setEnabled(true);
                this.populateNameField();
                break;
            }
            case GROUP: {
                this.configurationCombo.setInput(this.cicsConfigurations);
                this.configurationCombo.setSelection(this.savedConfigSelection);
                this.groupComboLabel.setEnabled(true);
                this.groupCombo.getCombo().setEnabled(true);
                this.groupCombo.setSelection(this.savedGroupSelection);
                this.typeComboLabel.setEnabled(false);
                this.typeCombo.getCombo().setEnabled(false);
                this.typeCombo.setSelection(null);
                this.nameComboLabel.setEnabled(false);
                this.nameCombo.getCombo().setEnabled(false);
                this.nameCombo.setSelection(null);
                break;
            }
            case LIST: {
                this.configurationCombo.setInput(this.csdConfigurations);
                this.configurationCombo.setSelection(this.savedConfigSelection);
                this.groupComboLabel.setEnabled(false);
                this.groupCombo.getCombo().setEnabled(false);
                this.groupCombo.setSelection(null);
                this.typeComboLabel.setEnabled(false);
                this.typeCombo.getCombo().setEnabled(false);
                this.typeCombo.setSelection(null);
                this.nameComboLabel.setEnabled(true);
                this.nameCombo.getCombo().setEnabled(true);
                this.populateNameField();
                break;
            }
        }
        this.enableCommandTypeButtons(null);
        this.updatePositionCombo();
        this.validateDialog();
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.initialiseUI();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout gLayout = new GridLayout(2, false);
        dialogArea.setLayout((Layout)gLayout);
        GridDataFactory gdf = GridDataFactory.fillDefaults().grab(true, true);
        this.getShell().setText(Messages.getString("PackageCommandsDialog.dialog.title"));
        this.setTitle(Messages.getString("PackageCommandsDialog.dialog.title"));
        this.setMessage(Messages.getString("PackageCommandsDialog.dialog.message"));
        Group definitionGroup = new Group(dialogArea, 0);
        definitionGroup.setText(Messages.getString("PackageCommandsDialog.group.definition"));
        GridData defData = new GridData(4, 4, true, true);
        defData.horizontalSpan = 1;
        defData.verticalSpan = 2;
        definitionGroup.setLayoutData((Object)defData);
        GridLayout grid = new GridLayout(2, false);
        definitionGroup.setLayout((Layout)grid);
        gdf.applyTo((Control)definitionGroup);
        Composite metaChoiceComposite = new Composite((Composite)definitionGroup, 0);
        GridData metaCompData = new GridData(4, 128, true, false);
        metaCompData.horizontalSpan = 2;
        metaChoiceComposite.setLayoutData((Object)metaCompData);
        metaChoiceComposite.setLayout((Layout)new RowLayout());
        this.metaResourceButton = new Button(metaChoiceComposite, 16);
        this.metaResourceButton.setText(Messages.getString("PackageCommandsDialog.button.metaResource"));
        this.metaGroupButton = new Button(metaChoiceComposite, 16);
        this.metaGroupButton.setText(Messages.getString("PackageCommandsDialog.button.metaGroup"));
        this.metaListButton = new Button(metaChoiceComposite, 16);
        this.metaListButton.setText(Messages.getString("PackageCommandsDialog.button.metaList"));
        if (ConfigurationManager.getCurrent().getConnection().getRelease() < 540) {
            this.metaListButton.setEnabled(false);
            this.beforeAfterSupported = false;
        }
        SelectionAdapter metaRadioListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                if (button.getSelection()) {
                    PackageCommandsDialog.this.widgetSelected((Widget)button);
                    PackageCommandsDialog.this.validateDialog();
                }
            }
        };
        this.metaListButton.addSelectionListener((SelectionListener)metaRadioListener);
        this.metaGroupButton.addSelectionListener((SelectionListener)metaRadioListener);
        this.metaResourceButton.addSelectionListener((SelectionListener)metaRadioListener);
        this.metaResourceButton.setSelection(true);
        Label confComboLabel = new Label((Composite)definitionGroup, 0);
        confComboLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        confComboLabel.setText(Messages.getString("PackageCommandsDialog.label.configuration"));
        this.configurationCombo = new ComboViewer((Composite)definitionGroup, 8);
        Combo combo_3 = this.configurationCombo.getCombo();
        combo_3.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.configurationCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.configurationCombo.setLabelProvider((IBaseLabelProvider)new ConfigurationsViewLabelProvider());
        this.cicsConfigurations = new ArrayList<Configuration>();
        this.csdConfigurations = new ArrayList<Configuration>();
        this.cpsmConfigurations = new ArrayList<Configuration>();
        for (Configuration config : ConfigurationManager.getCurrent().getConfigurations().getResults()) {
            if (!(config instanceof CICSConfiguration)) continue;
            this.cicsConfigurations.add(config);
            if (config instanceof CSDConfiguration) {
                this.csdConfigurations.add(config);
            }
            if (!(config instanceof CPSMConfiguration)) continue;
            this.cpsmConfigurations.add(config);
        }
        this.groupComboLabel = new Label((Composite)definitionGroup, 0);
        this.groupComboLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.groupComboLabel.setText(Messages.getString("PackageCommandsDialog.label.group"));
        this.groupCombo = new ComboViewer((Composite)definitionGroup, 8);
        Combo combo_1 = this.groupCombo.getCombo();
        combo_1.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.groupCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.groupCombo.setLabelProvider((IBaseLabelProvider)new ConfigurationsViewLabelProvider());
        this.typeComboLabel = new Label((Composite)definitionGroup, 0);
        this.typeComboLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.typeComboLabel.setText(Messages.getString("PackageCommandsDialog.label.typeCombo"));
        this.typeCombo = new ComboViewer((Composite)definitionGroup, 8);
        Combo combo_2 = this.typeCombo.getCombo();
        combo_2.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.typeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.typeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                HashMap<ICICSType<?>, String> typesToDescriptiveNames = CMUIUtilities.getTypesToDescriptiveNames();
                return typesToDescriptiveNames.get((ICICSType)element);
            }
        });
        Set<ICICSType<?>> typeSet = CMUIUtilities.getTypesToDescriptiveNames().keySet();
        ArrayList sortedTypes = new ArrayList();
        for (ICICSType<?> type : typeSet) {
            if (!(type instanceof AbstractCICSDefinitionType)) continue;
            sortedTypes.add(type);
        }
        Collections.sort(sortedTypes, new Comparator<ICICSType<?>>(){

            @Override
            public int compare(ICICSType<?> arg0, ICICSType<?> arg1) {
                return arg0.toString().compareTo(arg1.toString());
            }
        });
        this.typeCombo.setInput((Object)sortedTypes.toArray(new ICICSType[0]));
        this.nameComboLabel = new Label((Composite)definitionGroup, 0);
        this.nameComboLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.nameComboLabel.setText(Messages.getString("PackageCommandsDialog.label.nameCombo"));
        this.nameCombo = new ComboViewer((Composite)definitionGroup, 8);
        Combo combo = this.nameCombo.getCombo();
        combo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.nameCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.nameCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                switch (PackageCommandsDialog.this.uiMode) {
                    case RESOURCE: {
                        if (!(element instanceof ICMDefinition)) break;
                        ICMDefinition def = (ICMDefinition)element;
                        if (StringUtil.hasContent((String)def.getResourceGroupName())) {
                            return def.getName();
                        }
                        return def.getName();
                    }
                    case LIST: {
                        if (!(element instanceof ResourceList)) break;
                        return ((ResourceList)element).getName();
                    }
                }
                return "";
            }
        });
        Composite buttonGroup = new Composite((Composite)definitionGroup, 0);
        GridData butGroupData = GridDataFactory.fillDefaults().create();
        butGroupData.horizontalSpan = 2;
        buttonGroup.setLayoutData((Object)butGroupData);
        GridLayout butGroupLayout = new GridLayout(2, true);
        butGroupLayout.marginWidth = 0;
        butGroupLayout.marginHeight = 0;
        buttonGroup.setLayout((Layout)butGroupLayout);
        Button addDefButton = new Button(buttonGroup, 0);
        addDefButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        addDefButton.setText(Messages.getString("PackageCommandsDialog.addDefButton.text"));
        addDefButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (PackageCommandsDialog.this.uiMode) {
                    case RESOURCE: {
                        ICMDefinition def = PackageCommandsDialog.this.getDefinitionFromNameSelection(PackageCommandsDialog.this.nameCombo.getSelection());
                        if (def == null || PackageCommandsDialog.this.sourceObjects.contains(def)) break;
                        PackageCommandsDialog.this.sourceObjects.add(def);
                        PackageCommandsDialog.this.listViewer.refresh();
                        break;
                    }
                    case GROUP: {
                        IStructuredSelection structSel;
                        Object firstElement;
                        ISelection selection = PackageCommandsDialog.this.groupCombo.getSelection();
                        if (!(selection instanceof IStructuredSelection) || (firstElement = (structSel = (IStructuredSelection)selection).getFirstElement()) == null || !(firstElement instanceof ResourceDefinitionGroup)) break;
                        ResourceDefinitionGroup group = (ResourceDefinitionGroup)firstElement;
                        if (PackageCommandsDialog.this.sourceObjects.contains(group)) break;
                        PackageCommandsDialog.this.sourceObjects.add(group);
                        PackageCommandsDialog.this.listViewer.refresh();
                        break;
                    }
                    case LIST: {
                        IStructuredSelection structSel;
                        Object firstElement;
                        ISelection selection = PackageCommandsDialog.this.nameCombo.getSelection();
                        if (!(selection instanceof IStructuredSelection) || (firstElement = (structSel = (IStructuredSelection)selection).getFirstElement()) == null || !(firstElement instanceof ResourceList)) break;
                        ResourceList list = (ResourceList)firstElement;
                        if (PackageCommandsDialog.this.sourceObjects.contains(list)) break;
                        PackageCommandsDialog.this.sourceObjects.add(list);
                        PackageCommandsDialog.this.listViewer.refresh();
                    }
                }
                PackageCommandsDialog.this.validateDialog();
            }
        });
        Button remDefButton = new Button(buttonGroup, 0);
        remDefButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        remDefButton.setText(Messages.getString("PackageCommandsDialog.remDefButton.text"));
        remDefButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = PackageCommandsDialog.this.listViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structSel = (IStructuredSelection)selection;
                    Object[] objectArray = structSel.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object next = objectArray[n2];
                        if (PackageCommandsDialog.this.sourceObjects.contains(next)) {
                            PackageCommandsDialog.this.sourceObjects.remove(next);
                            PackageCommandsDialog.this.listViewer.refresh();
                        }
                        ++n2;
                    }
                }
                PackageCommandsDialog.this.validateDialog();
            }
        });
        this.listViewer = new ListViewer((Composite)definitionGroup, 2562);
        org.eclipse.swt.widgets.List list = this.listViewer.getList();
        GridData listLayoutData = new GridData(4, 4, false, true, 2, 1);
        listLayoutData.heightHint = 100;
        list.setLayoutData((Object)listLayoutData);
        this.listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listViewer.setLabelProvider((IBaseLabelProvider)new CommandObjectLabelProvider());
        this.listViewer.setInput(this.sourceObjects);
        this.configurationCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection != null && !selection.equals(PackageCommandsDialog.this.savedConfigSelection)) {
                    IStructuredSelection structSel;
                    Object firstElement;
                    PackageCommandsDialog.this.savedConfigSelection = selection;
                    Configuration selectedConfig = null;
                    if (selection instanceof IStructuredSelection && (firstElement = (structSel = (IStructuredSelection)selection).getFirstElement()) != null && firstElement instanceof Configuration) {
                        selectedConfig = (Configuration)firstElement;
                    }
                    if (selectedConfig != null) {
                        IFilteredCollection groupsCollection = selectedConfig.getResourceGroups();
                        List resourceGroups = groupsCollection.getResults();
                        PackageCommandsDialog.this.groupCombo.setInput((Object)resourceGroups);
                        PackageCommandsDialog.this.groupCombo.setSelection(PackageCommandsDialog.this.savedGroupSelection);
                        PackageCommandsDialog.this.enableCommandTypeButtons(selectedConfig);
                    } else {
                        PackageCommandsDialog.this.groupCombo.setInput(null);
                    }
                    PackageCommandsDialog.this.populateNameField();
                    PackageCommandsDialog.this.validateDialog();
                }
            }
        });
        this.typeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection;
                if (PackageCommandsDialog.this.uiMode == Mode.RESOURCE && (selection = event.getSelection()) != null && !selection.equals(PackageCommandsDialog.this.savedTypeSelection)) {
                    PackageCommandsDialog.this.savedTypeSelection = selection;
                    PackageCommandsDialog.this.populateNameField();
                }
            }
        });
        this.groupCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection != null && !selection.equals(PackageCommandsDialog.this.savedGroupSelection)) {
                    if (PackageCommandsDialog.this.uiMode != Mode.LIST) {
                        PackageCommandsDialog.this.savedGroupSelection = selection;
                    }
                    if (PackageCommandsDialog.this.uiMode == Mode.RESOURCE) {
                        PackageCommandsDialog.this.populateNameField();
                    }
                }
            }
        });
        this.nameCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = PackageCommandsDialog.this.nameCombo.getSelection();
                if (PackageCommandsDialog.this.uiMode == Mode.RESOURCE) {
                    PackageCommandsDialog.this.savedNameSelection = selection;
                } else if (PackageCommandsDialog.this.uiMode == Mode.LIST) {
                    PackageCommandsDialog.this.savedListSelection = selection;
                }
            }
        });
        Composite rightHand = new Composite(dialogArea, 0);
        rightHand.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        GridLayout gl_leftHand = new GridLayout();
        gl_leftHand.marginWidth = 0;
        gl_leftHand.marginHeight = 0;
        rightHand.setLayout((Layout)gl_leftHand);
        Group packageGroup = new Group(rightHand, 0);
        packageGroup.setText(Messages.getString("PackageCommandsDialog.group.changepackage"));
        GridData packData = new GridData(4, 128, false, false);
        packData.horizontalSpan = 1;
        packData.verticalSpan = 1;
        packageGroup.setLayoutData((Object)packData);
        packageGroup.setLayout((Layout)new GridLayout());
        this.packageCombo = new ComboViewer((Composite)packageGroup, 8);
        Combo combo_6 = this.packageCombo.getCombo();
        combo_6.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.packageCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.packageCombo.setLabelProvider((IBaseLabelProvider)new ChangePackageLabelProvider());
        this.packageCombo.setInput((Object)ConfigurationManager.getCurrent().getChangePackages().getResults());
        Group commandGroup = new Group(rightHand, 0);
        commandGroup.setText(Messages.getString("PackageCommandsDialog.group.command"));
        gdf = GridDataFactory.fillDefaults().grab(true, true);
        GridData cmdData = gdf.create();
        cmdData.verticalSpan = 1;
        commandGroup.setLayoutData((Object)cmdData);
        FillLayout fill = new FillLayout();
        fill.type = 512;
        commandGroup.setLayout((Layout)fill);
        this.addCmdButton = new Button((Composite)commandGroup, 16);
        this.addCmdButton.setData((Object)PackageCommand.Type.ADD);
        this.addCmdButton.setText(Messages.getString("PackageCommandsDialog.radio.addCommand"));
        this.remCmdButton = new Button((Composite)commandGroup, 16);
        this.remCmdButton.setData((Object)PackageCommand.Type.REMOVE);
        this.remCmdButton.setText(Messages.getString("PackageCommandsDialog.radio.remCommand"));
        this.delCmdButton = new Button((Composite)commandGroup, 16);
        this.delCmdButton.setData((Object)PackageCommand.Type.DELETE);
        this.delCmdButton.setText(Messages.getString("PackageCommandsDialog.radio.delCommand"));
        new Label(dialogArea, 0);
        new Label(dialogArea, 0);
        Listener cmdRadioListener = new Listener(){

            public void handleEvent(Event event) {
                PackageCommandsDialog.this.selectCommandTypeWidget(event.widget);
                PackageCommandsDialog.this.validateDialog();
            }
        };
        this.addCmdButton.addListener(13, cmdRadioListener);
        this.remCmdButton.addListener(13, cmdRadioListener);
        this.delCmdButton.addListener(13, cmdRadioListener);
        this.containerGroup = new Group(rightHand, 0);
        this.containerGroup.setText(Messages.getString("PackageCommandsDialog.group.container"));
        gdf = GridDataFactory.fillDefaults().grab(true, true);
        GridData contLayoutData = gdf.create();
        contLayoutData.verticalSpan = 1;
        this.containerGroup.setLayoutData((Object)contLayoutData);
        GridLayout gl_containerGroup = new GridLayout();
        gl_containerGroup.numColumns = 2;
        this.containerGroup.setLayout((Layout)gl_containerGroup);
        Label targetConfComboLabel = new Label((Composite)this.containerGroup, 0);
        targetConfComboLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        targetConfComboLabel.setText(Messages.getString("PackageCommandsDialog.label.configuration"));
        this.targetConfCombo = new ComboViewer((Composite)this.containerGroup, 8);
        Combo combo_4 = this.targetConfCombo.getCombo();
        combo_4.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.targetConfCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.targetConfCombo.setLabelProvider((IBaseLabelProvider)new ConfigurationsViewLabelProvider());
        this.targetConfCombo.setInput(this.cpsmConfigurations);
        this.containerTypeLabel = new Label((Composite)this.containerGroup, 0);
        this.containerTypeLabel.setText(Messages.getString("PackageCommandsDialog.label.to"));
        this.containerTypeLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.contNameCombo = new ComboViewer((Composite)this.containerGroup, 0);
        this.contNameCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.contNameCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ICMObject) {
                    return ((ICMObject)element).getName();
                }
                return super.getText(element);
            }
        });
        Combo combo_5 = this.contNameCombo.getCombo();
        combo_5.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        combo_5.setTextLimit(8);
        combo_5.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PackageCommandsDialog.this.validateDialog();
            }
        });
        combo_5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackageCommandsDialog.this.validateDialog();
            }
        });
        Listener targetConfComboListener = new Listener(){

            public void handleEvent(Event event) {
                Object firstElement = ((IStructuredSelection)PackageCommandsDialog.this.targetConfCombo.getSelection()).getFirstElement();
                if (firstElement != null && firstElement instanceof Configuration) {
                    PackageCommandsDialog.this.configForTarget = (Configuration)firstElement;
                }
                PackageCommandsDialog.this.updateContainerNameCombo();
                PackageCommandsDialog.this.validateDialog();
            }
        };
        Composite beforeAfterComposite = new Composite((Composite)this.containerGroup, 0);
        GridLayout bACLayout = new GridLayout(2, false);
        beforeAfterComposite.setLayout((Layout)bACLayout);
        this.targetConfCombo.getCombo().addListener(13, targetConfComboListener);
        this.beforeButton = new Button(beforeAfterComposite, 16);
        this.beforeButton.setText(Messages.getString("PackageCommandsDialog.radio.beforeGroup"));
        this.afterButton = new Button(beforeAfterComposite, 16);
        this.afterButton.setText(Messages.getString("PackageCommandsDialog.radio.afterGroup"));
        this.positionCombo = new ComboViewer((Composite)this.containerGroup, 8);
        this.positionCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.positionCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ICMObject) {
                    return ((ICMObject)element).getName();
                }
                return super.getText(element);
            }
        });
        Combo combo_7 = this.positionCombo.getCombo();
        combo_7.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Listener targetContainerComboListener = new Listener(){

            public void handleEvent(Event event) {
                PackageCommandsDialog.this.updatePositionCombo();
                PackageCommandsDialog.this.validateDialog();
            }
        };
        this.contNameCombo.getCombo().addListener(24, targetContainerComboListener);
        parent.pack();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialogArea.getShell(), "com.ibm.cics.cm.ui.dialog_addpackagecommands");
        return dialogArea;
    }

    private void populateNameField() {
        switch (this.uiMode) {
            case RESOURCE: {
                IStructuredSelection typeSel;
                ResourceDefinitionGroup selectedGroup = null;
                ICICSType selectedType = null;
                IStructuredSelection groupSel = (IStructuredSelection)this.groupCombo.getSelection();
                if (!groupSel.isEmpty() && groupSel.getFirstElement() instanceof ResourceDefinitionGroup) {
                    selectedGroup = (ResourceDefinitionGroup)groupSel.getFirstElement();
                }
                if (!(typeSel = (IStructuredSelection)this.typeCombo.getSelection()).isEmpty() && typeSel.getFirstElement() instanceof ICICSType) {
                    selectedType = (ICICSType)typeSel.getFirstElement();
                }
                if (selectedType != null && selectedGroup != null) {
                    IFilteredCollection definitions = selectedGroup.getDefinitions();
                    definitions.setObjectType(selectedType.getResourceTableName());
                    List results = definitions.getResults();
                    Comparator<ICMDefinition> comp = new Comparator<ICMDefinition>(){

                        @Override
                        public int compare(ICMDefinition o1, ICMDefinition o2) {
                            return o1.getName().compareTo(o2.getName());
                        }
                    };
                    Collections.sort(results, comp);
                    this.nameCombo.setInput((Object)results);
                    this.nameCombo.setSelection(this.savedNameSelection);
                    break;
                }
                this.nameCombo.setInput(null);
                break;
            }
            case LIST: {
                ISelection selection = this.configurationCombo.getSelection();
                if (!(selection instanceof IStructuredSelection)) break;
                IStructuredSelection structSel = (IStructuredSelection)selection;
                Object firstElement = structSel.getFirstElement();
                if (firstElement != null && firstElement instanceof CSDConfiguration) {
                    IFilteredCollection lists = ((Configuration)firstElement).getResourceLists();
                    List results = lists.getResults();
                    Comparator<ResourceList> comp = new Comparator<ResourceList>(){

                        @Override
                        public int compare(ResourceList o1, ResourceList o2) {
                            return o1.getName().compareTo(o2.getName());
                        }
                    };
                    Collections.sort(results, comp);
                    this.nameCombo.setInput((Object)results);
                    this.nameCombo.setSelection(this.savedListSelection);
                    break;
                }
                this.nameCombo.setInput(null);
                break;
            }
            default: {
                this.nameCombo.setInput(null);
            }
        }
        this.validateDialog();
    }

    private void enableCommandTypeButtons(Configuration selectedConfig) {
        this.delCmdButton.setEnabled(true);
        switch (this.uiMode) {
            case RESOURCE: {
                this.addCmdButton.setEnabled(true);
                this.remCmdButton.setEnabled(true);
                this.targetConfCombo.setInput(this.cpsmConfigurations);
                break;
            }
            case GROUP: {
                this.addCmdButton.setEnabled(true);
                this.remCmdButton.setEnabled(true);
                this.targetConfCombo.setInput(this.cicsConfigurations);
                break;
            }
            case LIST: {
                this.addCmdButton.setEnabled(false);
                this.remCmdButton.setEnabled(false);
                this.addCmdButton.setSelection(false);
                this.remCmdButton.setSelection(false);
                this.delCmdButton.setSelection(true);
                this.selectCommandTypeWidget((Widget)this.delCmdButton);
            }
        }
    }

    private void selectCommandTypeWidget(Widget widget) {
        this.selectedCmdButton = widget != null ? (Button)widget : null;
        PackageCommand.Type type = this.commandType = this.selectedCmdButton != null ? (PackageCommand.Type)this.selectedCmdButton.getData() : null;
        if (widget != null) {
            if (widget == this.addCmdButton) {
                this.toggleToFromField(true);
            } else {
                this.toggleToFromField(false);
            }
        }
        this.updatePositionCombo();
        this.enableContainerGroup(widget == null || widget != this.delCmdButton);
    }

    private void updateContainerNameCombo() {
        if (this.configForTarget != null) {
            if (this.uiMode == Mode.RESOURCE) {
                this.contNameCombo.setInput((Object)this.configForTarget.getResourceGroups().getResults());
            } else {
                this.contNameCombo.setInput((Object)this.configForTarget.getResourceLists().getResults());
            }
        }
        this.updatePositionCombo();
    }

    private void updatePositionCombo() {
        Object firstElement = null;
        if (this.uiMode == Mode.GROUP && this.commandType == PackageCommand.Type.ADD && this.configForTarget instanceof CSDConfiguration) {
            firstElement = ((IStructuredSelection)this.contNameCombo.getSelection()).getFirstElement();
        }
        if (!this.beforeAfterSupported || firstElement == null || !(firstElement instanceof ResourceList)) {
            this.beforeButton.setEnabled(false);
            this.afterButton.setEnabled(false);
            this.positionCombo.getCombo().setEnabled(false);
            this.beforeButton.setSelection(false);
            this.afterButton.setSelection(false);
            this.positionCombo.setInput((Object)Collections.EMPTY_LIST);
        } else {
            this.beforeButton.setEnabled(true);
            this.afterButton.setEnabled(true);
            this.positionCombo.getCombo().setEnabled(true);
            this.positionCombo.setInput((Object)((ResourceList)firstElement).getResourceGroups(this.configForTarget).getResults());
        }
    }

    private void widgetSelected(Widget widget) {
        Object firstElement;
        Mode lastMode = this.uiMode;
        this.uiMode = this.widgetToMode(widget);
        if (this.uiMode != lastMode) {
            if (this.uiMode == Mode.LIST) {
                this.configurationCombo.setInput(this.csdConfigurations);
                this.configurationCombo.setSelection(this.savedConfigSelection);
                this.groupComboLabel.setEnabled(false);
                this.groupCombo.getCombo().setEnabled(false);
                this.groupCombo.setSelection(null);
            }
            if (lastMode == Mode.LIST) {
                this.configurationCombo.setInput(this.cicsConfigurations);
                this.configurationCombo.setSelection(this.savedConfigSelection);
                this.groupComboLabel.setEnabled(true);
                this.groupCombo.getCombo().setEnabled(true);
                this.groupCombo.setSelection(this.savedGroupSelection);
            }
            if (this.uiMode == Mode.RESOURCE) {
                this.typeComboLabel.setEnabled(true);
                this.typeCombo.getCombo().setEnabled(true);
                this.typeCombo.setSelection(this.savedTypeSelection);
            }
            if (lastMode == Mode.RESOURCE) {
                this.typeComboLabel.setEnabled(false);
                this.typeCombo.getCombo().setEnabled(false);
                this.typeCombo.setSelection(null);
            }
            if (this.uiMode == Mode.GROUP) {
                this.nameComboLabel.setEnabled(false);
                this.nameCombo.getCombo().setEnabled(false);
                this.nameCombo.setSelection(null);
            }
            if (lastMode == Mode.GROUP) {
                this.nameComboLabel.setEnabled(true);
                this.nameCombo.getCombo().setEnabled(true);
                this.populateNameField();
            }
            this.sourceObjects = new ArrayList<ICMObject>();
            this.listViewer.setInput(this.sourceObjects);
            this.updateContainerNameCombo();
        }
        Configuration current = (firstElement = ((IStructuredSelection)this.configurationCombo.getSelection()).getFirstElement()) != null && firstElement instanceof Configuration ? (Configuration)firstElement : null;
        this.enableCommandTypeButtons(current);
    }

    private Mode widgetToMode(Widget widget) {
        if (widget == this.metaResourceButton) {
            return Mode.RESOURCE;
        }
        if (widget == this.metaGroupButton) {
            return Mode.GROUP;
        }
        if (widget == this.metaListButton) {
            return Mode.LIST;
        }
        return this.uiMode;
    }

    private ICMDefinition getDefinitionFromNameSelection(ISelection selection) {
        IStructuredSelection structSel;
        Object firstElement;
        if (selection instanceof IStructuredSelection && (firstElement = (structSel = (IStructuredSelection)selection).getFirstElement()) != null && firstElement instanceof ICMDefinition) {
            return (ICMDefinition)firstElement;
        }
        return null;
    }

    private void toggleToFromField(boolean isTo) {
        if (isTo) {
            this.containerTypeLabel.setText(Messages.getString("PackageCommandsDialog.label.to"));
        } else {
            this.containerTypeLabel.setText(Messages.getString("PackageCommandsDialog.label.from"));
        }
        this.containerTypeLabel.requestLayout();
    }

    private void enableContainerGroup(boolean enable) {
        this.containerGroup.setEnabled(enable);
        Control[] controlArray = this.containerGroup.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control next = controlArray[n2];
            next.setEnabled(enable);
            ++n2;
        }
    }

    public void setSource(CMObject source) {
        if (source instanceof ICMDefinition) {
            this.sourceDef = (ICMDefinition)source;
        } else if (source instanceof ResourceDefinitionGroup) {
            this.sourceGrp = (ResourceDefinitionGroup)source;
        }
    }

    public void setTarget(CMObject target) {
        if (target instanceof ResourceDefinitionGroup) {
            this.targetGrp = (ResourceDefinitionGroup)target;
        } else if (target instanceof ResourceList) {
            this.targetList = (ResourceList)target;
        }
    }

    private boolean validateDialog() {
        IStructuredSelection selection;
        Object firstElement;
        if (this.selectedCmdButton == null) {
            return this.error(Messages.getString("PackageCommandsDialog.error.commandtype.notselected"));
        }
        if (!(this.packageCombo == null || (firstElement = (selection = (IStructuredSelection)this.packageCombo.getSelection()).getFirstElement()) != null && firstElement instanceof ChangePackage)) {
            return this.error(Messages.getString("PackageCommandsDialog.error.changepackage.notselected"));
        }
        if (this.sourceObjects == null || this.sourceObjects.size() == 0) {
            return this.error(Messages.getString("PackageCommandsDialog.error.sourceobjects.empty"));
        }
        if (!(this.selectedCmdButton.equals(this.delCmdButton) || this.contNameCombo != null && StringUtil.hasContent((String)this.contNameCombo.getCombo().getText()))) {
            return this.error(Messages.getString("PackageCommandsDialog.error.containerName.empty"));
        }
        return this.error(null);
    }

    private List<PackageCommand> getPackComForConfig(Configuration config) {
        List<PackageCommand> list;
        if (!this.listConfigs.contains(config)) {
            this.listConfigs.add(config);
        }
        if ((list = this.mapConfigsToPackageCommands.get(config)) == null) {
            list = new ArrayList<PackageCommand>();
            this.mapConfigsToPackageCommands.put(config, list);
        }
        return list;
    }

    protected void okPressed() {
        if (!this.validateDialog()) {
            return;
        }
        String targetContainer = this.contNameCombo.getCombo().getText();
        this.listConfigs = new ArrayList<Configuration>();
        this.mapConfigsToPackageCommands = new HashMap<Configuration, List<PackageCommand>>();
        for (ICMObject sourceObj : this.sourceObjects) {
            List<PackageCommand> commandsList;
            ICMDefinition current;
            if (this.uiMode == Mode.RESOURCE && sourceObj instanceof ICMDefinition) {
                current = (ICMDefinition)sourceObj;
                commandsList = this.getPackComForConfig(current.getConfiguration());
                commandsList.add(new PackageCommand(this.commandType, current, current.getResourceGroup(), targetContainer));
            }
            if (this.uiMode == Mode.GROUP && sourceObj instanceof ResourceDefinitionGroup) {
                current = (ResourceDefinitionGroup)sourceObj;
                commandsList = this.getPackComForConfig(current.getConfiguration());
                ResourceDefinitionGroup adjGroup = (ResourceDefinitionGroup)((IStructuredSelection)this.positionCombo.getSelection()).getFirstElement();
                if (this.commandType == PackageCommand.Type.ADD && (this.beforeButton.getSelection() || this.afterButton.getSelection()) && adjGroup != null) {
                    String groupPlacement = this.beforeButton.getSelection() ? "BEFORE" : "AFTER";
                    commandsList.add(new PackageCommand((ResourceDefinitionGroup)current, targetContainer, groupPlacement, adjGroup));
                } else {
                    commandsList.add(new PackageCommand(this.commandType, (ResourceDefinitionGroup)current, targetContainer));
                }
            }
            if (this.uiMode != Mode.LIST || !(sourceObj instanceof ResourceList)) continue;
            current = (ResourceList)sourceObj;
            commandsList = this.getPackComForConfig(current.getConfiguration());
            commandsList.add(new PackageCommand((ResourceList)current));
        }
        this.changePackage = (ChangePackage)((IStructuredSelection)this.packageCombo.getSelection()).getFirstElement();
        CMServerAddException lastException = null;
        for (Configuration conf : this.listConfigs) {
            Status status;
            try {
                this.changePackage.addCommands(this.mapConfigsToPackageCommands.get(conf), conf);
            }
            catch (CMServerAddException e) {
                lastException = e;
            }
            if (lastException == null) {
                status = new Status(1, "com.ibm.cics.cm.ui", MessageFormat.format(Messages.getString("PackageCommandsDialog.message.addedCommands"), this.mapConfigsToPackageCommands.get(conf).size(), conf.getName(), this.changePackage.getName()));
                UIActivator.getDefault().getLog().log((IStatus)status);
                ViewHelper.setDeferredStatusInformationMessage((String)status.getMessage());
                continue;
            }
            status = new Status(2, "com.ibm.cics.cm.ui", MessageFormat.format(Messages.getString("PackageCommandsDialog.warning.addCommandsFailed"), lastException.getMessageResponse().getReadableReasonCode()), (Throwable)lastException);
            UIActivator.getDefault().getLog().log((IStatus)status);
            ViewHelper.setDeferredStatusErrorMessage((String)status.getMessage());
            this.error(status.getMessage());
            return;
        }
        super.okPressed();
    }

    private boolean error(String errorMessage) {
        this.setErrorMessage(errorMessage);
        if (errorMessage == null) {
            this.getButton(0).setEnabled(true);
            return true;
        }
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(false);
        }
        return false;
    }

    private class CommandObjectLabelProvider
    extends LabelProvider {
        private CommandObjectLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ICMDefinition) {
                ICMDefinition cmDef = (ICMDefinition)element;
                return String.valueOf(cmDef.getConfiguration().getName()) + "\\" + cmDef.getResourceGroupName() + "\\" + cmDef.getType() + "(" + cmDef.getName() + ")";
            }
            if (element instanceof ResourceDefinitionGroup) {
                ResourceDefinitionGroup cmDef = (ResourceDefinitionGroup)element;
                return String.valueOf(cmDef.getConfiguration().getName()) + "\\" + cmDef.getName();
            }
            if (element instanceof ResourceList) {
                ResourceList cmDef = (ResourceList)element;
                return String.valueOf(cmDef.getConfiguration().getName()) + "\\" + cmDef.getName();
            }
            return null;
        }
    }

    private static enum Mode {
        RESOURCE,
        GROUP,
        LIST;

    }
}

