/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.editors;

import com.ibm.cics.cm.model.CMServerRemoveException;
import com.ibm.cics.cm.model.ChangePackage;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.MigrationScheme;
import com.ibm.cics.cm.model.ReadyListObject;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.ui.CMUIUtilities;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.chgpkg.ChangePackageLabelProvider;
import com.ibm.cics.cm.ui.chgpkg.ChangePackageTreeContentProvider;
import com.ibm.cics.cm.ui.chgpkg.ChangePackageTreeNode;
import com.ibm.cics.cm.ui.dialogs.ConfirmRemovalDialog;
import com.ibm.cics.cm.ui.editors.ChangePackageEditor;
import com.ibm.cics.cm.ui.editors.ChangePackageEditorInput;
import com.ibm.cics.cm.ui.editors.IChangePackageReadyListListener;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.eclipse.common.ui.DelegateLabelProvider;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ManagePackageResourcesPage
extends FormPage
implements IChangePackageReadyListListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ManagePackageResourcesPage.class);
    public static final String PAGE_ID = "manageresources";
    private FormEditor editor;
    private Combo schemeCombo;
    private TreeViewer resourcesViewer;
    private FormText errorText;
    protected boolean typeColumnIsHidden = true;
    private ManagedResourcesComparator comparator;

    public ManagePackageResourcesPage(ChangePackageEditor changePackageEditor) {
        super(PAGE_ID, Messages.getString("ManagePackageResourcesPage.title"));
        this.initialize(changePackageEditor);
        this.editor = changePackageEditor;
    }

    protected void createFormContent(IManagedForm managedForm) {
        IManagedForm mForm = managedForm;
        FormToolkit toolkit = mForm.getToolkit();
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)new GridLayout(1, false));
        Section schemeSection = toolkit.createSection(body, 448);
        schemeSection.setText(Messages.getString("ManagePackageResourcesPage.section.migrationscheme"));
        schemeSection.setDescription(Messages.getString("ManagePackageResourcesPage.section.migrationscheme.description"));
        schemeSection.setLayoutData((Object)new GridData(4, -1, true, false));
        Composite schemeArea = toolkit.createComposite((Composite)schemeSection, 0);
        schemeArea.setLayout((Layout)new GridLayout(1, false));
        schemeSection.setClient((Control)schemeArea);
        schemeArea.setData((Object)new GridData(4, 128, true, false));
        this.schemeCombo = new Combo(schemeArea, 8);
        this.schemeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String item = ManagePackageResourcesPage.this.schemeCombo.getItem(ManagePackageResourcesPage.this.schemeCombo.getSelectionIndex());
                ((PackageResourcesTreeContentProvider)ManagePackageResourcesPage.this.resourcesViewer.getContentProvider()).setScheme(item);
                ManagePackageResourcesPage.this.resourcesViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Section resourceSection = toolkit.createSection(body, 448);
        resourceSection.setText(Messages.getString("ManagePackageResourcesPage.section.resources"));
        resourceSection.setDescription(Messages.getString("ManagePackageResourcesPage.section.resources.description"));
        resourceSection.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite resourcesArea = toolkit.createComposite((Composite)resourceSection, 0);
        resourcesArea.setLayout((Layout)new GridLayout(2, false));
        resourcesArea.setData((Object)new GridData(4, 4, true, true));
        resourceSection.setClient((Control)resourcesArea);
        this.errorText = toolkit.createFormText(resourcesArea, true);
        this.errorText.setBackground(Display.getCurrent().getSystemColor(29));
        this.errorText.setForeground(Display.getCurrent().getSystemColor(28));
        this.errorText.setText("", false, false);
        this.errorText.setLayoutData((Object)new GridData(4, 16384, true, false, 2, 1));
        Tree resourceTree = toolkit.createTree(resourcesArea, 2050);
        this.resourcesViewer = new TreeViewer(resourceTree);
        resourceTree.setLayoutData((Object)new GridData(4, 4, true, true));
        final PackageResourcesTreeContentProvider content = new PackageResourcesTreeContentProvider();
        content.addListener(this);
        this.resourcesViewer.setContentProvider((IContentProvider)content);
        this.resourcesViewer.setLabelProvider((IBaseLabelProvider)new ChangePackageLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.resourcesViewer);
        this.resourcesViewer.getTree().setHeaderVisible(true);
        this.comparator = new ManagedResourcesComparator();
        this.resourcesViewer.setComparator((ViewerComparator)this.comparator);
        this.createColumns(this.resourcesViewer);
        this.packColumns(this.resourcesViewer.getTree());
        Composite buttonArea = toolkit.createComposite(resourcesArea, 0);
        buttonArea.setLayoutData((Object)new GridData(-1, 128, false, false));
        buttonArea.setLayout((Layout)new GridLayout(1, true));
        final Button remButton = toolkit.createButton(buttonArea, Messages.getString("ManagePackageResourcesPage.button.remove"), 8);
        remButton.setLayoutData((Object)new GridData(4, -1, true, false));
        remButton.setEnabled(false);
        remButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HashMap objectsByConfig = new HashMap();
                ISelection selection = ManagePackageResourcesPage.this.resourcesViewer.getSelection();
                ArrayList<ReadyListObject> cmObjects = new ArrayList<ReadyListObject>();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)selection;
                    List list = iStructuredSelection.toList();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Object obj = iterator.next();
                        if (!(obj instanceof ReadyListObject)) continue;
                        cmObjects.add((ReadyListObject)obj);
                    }
                }
                for (ICMObject iCMObject : cmObjects) {
                    String configName;
                    if (!(iCMObject instanceof ReadyListObject) || (configName = (String)iCMObject.getAttributes().get("SEL_CCONFIG")) == null) continue;
                    List<Map> listCMObjects = null;
                    if (!objectsByConfig.containsKey(configName)) {
                        listCMObjects = new ArrayList();
                        objectsByConfig.put(configName, listCMObjects);
                    } else {
                        listCMObjects = (List)objectsByConfig.get(configName);
                    }
                    listCMObjects.add(iCMObject.getAttributes());
                }
                IEditorInput iEditorInput = ManagePackageResourcesPage.this.editor.getEditorInput();
                if (iEditorInput instanceof ChangePackageEditorInput) {
                    ChangePackage changePackage = ((ChangePackageEditorInput)iEditorInput).getChangePackage();
                    String resourcesString = ManagePackageResourcesPage.this.resourcesToString(objectsByConfig);
                    ConfirmRemovalDialog dialog = new ConfirmRemovalDialog(ManagePackageResourcesPage.this.editor.getSite().getShell(), MessageFormat.format(Messages.getString("ManagePackageResourcesPage.message.confirmRemove"), resourcesString, changePackage.getName()));
                    if (dialog.open() == 0) {
                        Status status;
                        boolean allOK = true;
                        for (String nextConf : objectsByConfig.keySet()) {
                            try {
                                changePackage.removeResources((List)objectsByConfig.get(nextConf), nextConf);
                                ManagePackageResourcesPage.this.resourcesViewer.refresh();
                            }
                            catch (CMServerRemoveException e1) {
                                debug.error("removeResources", (Throwable)e1);
                                Status status2 = new Status(4, "com.ibm.cics.cm.ui", MessageFormat.format(Messages.getString("ManagePackageResourcesPage.remove.error"), e1.getReturnResponse()), (Throwable)e1);
                                UIActivator.getDefault().getLog().log((IStatus)status2);
                                ViewHelper.setDeferredStatusErrorMessage((String)status2.getMessage());
                                allOK = false;
                            }
                        }
                        if (allOK) {
                            status = new Status(1, "com.ibm.cics.cm.ui", MessageFormat.format(Messages.getString("ManagePackageResourcesPage.remove.success"), changePackage.getName()), null);
                            UIActivator.getDefault().getLog().log((IStatus)status);
                            ViewHelper.setDeferredStatusInformationMessage((String)status.getMessage());
                        } else {
                            status = new Status(4, "com.ibm.cics.cm.ui", MessageFormat.format(Messages.getString("ManagePackageResourcesPage.remove.errors"), changePackage.getName()), null);
                            UIActivator.getDefault().getLog().log((IStatus)status);
                            ViewHelper.setDeferredStatusErrorMessage((String)status.getMessage());
                        }
                    }
                }
            }
        });
        this.resourcesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                remButton.setEnabled(false);
                Object[] objectArray = ((StructuredSelection)event.getSelection()).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selected = objectArray[n2];
                    if (!(selected instanceof ChangePackageTreeNode)) {
                        remButton.setEnabled(true);
                    }
                    ++n2;
                }
            }
        });
        final Button groupByTypeButton = toolkit.createButton(resourcesArea, Messages.getString("ManagePackageResourcesPage.label.groupResourcesByType"), 32);
        groupByTypeButton.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        groupByTypeButton.setSelection(true);
        groupByTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean fresh;
                boolean last = content.isGroupByType();
                if (last != (fresh = groupByTypeButton.getSelection())) {
                    content.setGroupByType(fresh);
                    ManagePackageResourcesPage.this.typeColumnIsHidden = fresh;
                    ManagePackageResourcesPage.this.resourcesViewer.refresh();
                    ManagePackageResourcesPage.this.packColumns(ManagePackageResourcesPage.this.resourcesViewer.getTree());
                }
            }
        });
        this.resourcesViewer.getTree().addTreeListener(new TreeListener(){

            public void treeExpanded(TreeEvent e) {
                ManagePackageResourcesPage.this.packColumns(ManagePackageResourcesPage.this.resourcesViewer.getTree());
            }

            public void treeCollapsed(TreeEvent e) {
                ManagePackageResourcesPage.this.packColumns(ManagePackageResourcesPage.this.resourcesViewer.getTree());
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.resourcesViewer);
        this.createPopupMenu();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)body, this.getHelpContextID());
        IEditorInput input = this.editor.getEditorInput();
        if (input instanceof ChangePackageEditorInput) {
            ChangePackage changePackage = ((ChangePackageEditorInput)input).getChangePackage();
            this.updateMigrationSchemeCombo(changePackage);
            this.resourcesViewer.setInput((Object)changePackage);
        }
    }

    protected void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        Menu popupMenu = menuMgr.createContextMenu(this.resourcesViewer.getControl());
        this.resourcesViewer.getControl().setMenu(popupMenu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.resourcesViewer);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
            }
        });
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("open"));
        manager.add((IContributionItem)new Separator("actions"));
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected String getHelpContextID() {
        return "com.ibm.cics.cm.ui.editor_changepackage";
    }

    private void packColumns(final Tree tree) {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!tree.isDisposed()) {
                    TreeColumn[] treeColumnArray = tree.getColumns();
                    int n = treeColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeColumn next = treeColumnArray[n2];
                        if (next.getText().equals(Messages.getString("ManagePackageResourcesPage.column.resourcetype")) && ManagePackageResourcesPage.this.typeColumnIsHidden) {
                            next.setWidth(0);
                        } else {
                            next.pack();
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    private String resourcesToString(Map<String, List<Map<String, String>>> objectsByConfig) {
        StringBuffer result = new StringBuffer();
        Set<String> keySet = objectsByConfig.keySet();
        result.append("\n");
        for (String next : keySet) {
            List<Map<String, String>> list = objectsByConfig.get(next);
            result.append("\n\tConfiguration " + next + "\n");
            for (Map<String, String> nextCM : list) {
                String objectString = "";
                if (!nextCM.get("SEL_OBJTYPE").equals("RESGROUP") && !nextCM.get("SEL_OBJTYPE").equals("RESDESC")) {
                    String type = nextCM.get("SEL_OBJTYPE");
                    type = CMUIUtilities.getDescriptiveTypeName(type);
                    objectString = String.valueOf(type) + "(" + nextCM.get("SEL_OBJNAME") + ")";
                } else if (nextCM.get("SEL_OBJTYPE").equals("RESDESC")) {
                    objectString = String.valueOf(CMUIUtilities.getDescriptiveTypeName("RESDESC")) + "(" + nextCM.get("SEL_OBJNAME") + ")";
                } else if (nextCM.get("SEL_OBJTYPE").equals("RESGROUP")) {
                    objectString = String.valueOf(CMUIUtilities.getDescriptiveTypeName("RESGROUP")) + "(" + nextCM.get("SEL_OBJNAME") + ")";
                }
                result.append("\t\t" + objectString + "\n");
            }
        }
        result.append("\n");
        return result.toString();
    }

    private TreeViewerColumn createColumn(TreeViewer viewer, String text, CellLabelProvider labelProvider, int width, boolean resizable, boolean moveable, int swtArgs, String attribute) {
        TreeViewerColumn column = new TreeViewerColumn(viewer, swtArgs);
        column.getColumn().setWidth(width);
        column.getColumn().setResizable(resizable);
        column.getColumn().setMoveable(moveable);
        column.getColumn().setText(text);
        column.setLabelProvider(labelProvider);
        column.getColumn().addSelectionListener((SelectionListener)this.getSortListener(column, attribute));
        return column;
    }

    private void createColumns(TreeViewer viewer) {
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        Object labelProvider = new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DelegateLabelProvider((ILabelProvider)new ChangePackageLabelProvider()), decorator, null);
        this.createColumn(viewer, Messages.getString("ManagePackageResourcesPage.column.resources"), (CellLabelProvider)labelProvider, 100, true, false, 0, "SEL_OBJNAME");
        labelProvider = new customColumnLabelProvider("SEL_OBJTYPE");
        this.createColumn(viewer, Messages.getString("ManagePackageResourcesPage.column.resourcetype"), (CellLabelProvider)labelProvider, 0, true, true, 0, "SEL_OBJTYPE");
        labelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ReadyListObject) {
                    ReadyListObject rlo = (ReadyListObject)element;
                    return rlo.getState().getShortState();
                }
                return "";
            }

            public String getToolTipText(Object element) {
                if (element instanceof ReadyListObject) {
                    ReadyListObject rlo = (ReadyListObject)element;
                    return rlo.getState().getDescription();
                }
                return "";
            }
        };
        this.createColumn(viewer, Messages.getString("ManagePackageResourcesPage.column.readystate"), (CellLabelProvider)labelProvider, 100, true, true, 0, "REASONCODE");
        labelProvider = new customColumnLabelProvider("SEL_GROUP");
        this.createColumn(viewer, Messages.getString("ManagePackageResourcesPage.column.group"), (CellLabelProvider)labelProvider, 100, true, true, 0, "SEL_GROUP");
        labelProvider = new customColumnLabelProvider("SEL_CCONFIG");
        this.createColumn(viewer, Messages.getString("ManagePackageResourcesPage.column.configuration"), (CellLabelProvider)labelProvider, 100, true, true, 0, "SEL_CCONFIG");
    }

    private SelectionAdapter getSortListener(final TreeViewerColumn column, final String columnID) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManagePackageResourcesPage.this.comparator.setColumn(columnID);
                boolean sortAscending = ManagePackageResourcesPage.this.comparator.isSortAscending();
                ManagePackageResourcesPage.this.resourcesViewer.getTree().setSortColumn(column.getColumn());
                ManagePackageResourcesPage.this.resourcesViewer.getTree().setSortDirection(sortAscending ? 1024 : 128);
                ManagePackageResourcesPage.this.resourcesViewer.refresh();
            }
        };
        return listener;
    }

    private void updateMigrationSchemeCombo(ChangePackage changePackage) {
        IFilteredCollection migrationSchemes = ConfigurationManager.getCurrent().getMigrationSchemes();
        List schemes = migrationSchemes.getResults();
        TreeSet<String> names = new TreeSet<String>();
        names.add("");
        for (MigrationScheme next : schemes) {
            names.add(next.getName());
        }
        this.schemeCombo.setItems(names.toArray(new String[0]));
        MigrationScheme lastScheme = changePackage.getLastScheme();
        String lastSchemeName = null;
        if (lastScheme != null) {
            lastSchemeName = lastScheme.getName();
        }
        if (StringUtil.hasContent(lastSchemeName) && names.contains(lastSchemeName)) {
            this.schemeCombo.select(this.schemeCombo.indexOf(lastSchemeName));
        }
        PackageResourcesTreeContentProvider content = (PackageResourcesTreeContentProvider)this.resourcesViewer.getContentProvider();
        content.setScheme(lastSchemeName);
    }

    @Override
    public void errorEvent(ChangePackage.ReadyListError rle) {
        if (!this.errorText.isDisposed()) {
            if (rle != null) {
                this.errorText.setText(rle.getDescription(), false, false);
            } else {
                this.errorText.setText("", false, false);
            }
            this.errorText.getParent().layout(true);
        }
    }

    public void refresh() {
        if (this.resourcesViewer != null) {
            this.resourcesViewer.refresh();
        }
    }

    private class ManagedResourcesComparator
    extends ViewerComparator {
        private boolean ascending = true;
        private String columnIndex = "SEL_OBJNAME";

        private ManagedResourcesComparator() {
        }

        public boolean isSortAscending() {
            return this.ascending;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof ReadyListObject & e2 instanceof ReadyListObject) {
                ReadyListObject rlo1 = (ReadyListObject)e1;
                ReadyListObject rlo2 = (ReadyListObject)e2;
                int result = ((String)rlo1.getAttributes().get(this.columnIndex)).compareTo((String)rlo2.getAttributes().get(this.columnIndex));
                return this.ascending ? result : -result;
            }
            return 0;
        }

        public void setColumn(String columnID) {
            if (this.columnIndex.matches(columnID)) {
                this.ascending = !this.ascending;
            } else {
                this.columnIndex = columnID;
                this.ascending = true;
            }
        }
    }

    public class PackageResourcesTreeContentProvider
    implements ITreeContentProvider {
        private boolean groupByType = true;
        private String scheme;
        private Viewer viewer;
        private List<IChangePackageReadyListListener> listeners = new ArrayList<IChangePackageReadyListListener>();

        public void addListener(IChangePackageReadyListListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(IChangePackageReadyListListener listener) {
            this.listeners.remove(listener);
        }

        public void dispose() {
            this.listeners = new ArrayList<IChangePackageReadyListListener>();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.viewer = viewer;
        }

        public Object[] getElements(Object inputElement) {
            Object[] results;
            if (inputElement instanceof ChangePackage) {
                ChangePackage cp = (ChangePackage)inputElement;
                IFilteredCollection resources = cp.getResources(this.scheme);
                if (this.groupByType) {
                    results = ChangePackageTreeContentProvider.resourcesGroupedByType(resources);
                } else {
                    List resultList = resources.getResults();
                    results = resultList.toArray(new ICMObject[0]);
                }
                final ChangePackage.ReadyListError error = cp.getLastReadyListError();
                for (final IChangePackageReadyListListener next : this.listeners) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            next.errorEvent(error);
                        }
                    });
                }
            } else {
                results = new Object[]{};
            }
            return results;
        }

        public Object[] getChildren(Object parentElement) {
            Object data;
            if (parentElement instanceof ChangePackageTreeNode && (data = ((ChangePackageTreeNode)parentElement).getData()) != null) {
                IFilteredCollection items;
                if (data instanceof IFilteredCollection && (items = (IFilteredCollection)data).size() > 0) {
                    if (this.groupByType) {
                        return ChangePackageTreeContentProvider.resourcesGroupedByType(items);
                    }
                    return items.toArray();
                }
                if (data instanceof Object[]) {
                    return (Object[])data;
                }
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            Object data;
            if (element instanceof ChangePackageTreeNode && (data = ((ChangePackageTreeNode)element).getData()) != null) {
                if (data instanceof IFilteredCollection) {
                    return ((IFilteredCollection)data).size() > 0;
                }
                if (data instanceof Object[]) {
                    return ((Object[])data).length > 0;
                }
            }
            return false;
        }

        public boolean isGroupByType() {
            return this.groupByType;
        }

        public void setGroupByType(boolean groupByType) {
            this.groupByType = groupByType;
        }

        public String getScheme() {
            return this.scheme;
        }

        public void setScheme(String scheme) {
            this.scheme = scheme;
        }
    }

    private class customColumnLabelProvider
    extends ColumnLabelProvider {
        private String attribute;

        public customColumnLabelProvider(String attribute) {
            this.attribute = attribute;
        }

        public String getText(Object element) {
            ReadyListObject thing;
            String string;
            StringBuffer result = new StringBuffer();
            if (element instanceof ReadyListObject && (string = (String)(thing = (ReadyListObject)element).getAttributes().get(this.attribute)) != null) {
                if (this.attribute.equals("SEL_OBJTYPE")) {
                    string = CMUIUtilities.getDescriptiveTypeName(string);
                }
                result.append(string);
            }
            return result.toString();
        }
    }
}

