/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.editors;

import com.ibm.cics.cm.model.CMServerRemoveException;
import com.ibm.cics.cm.model.ChangePackage;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.MigrationScheme;
import com.ibm.cics.cm.model.PackageCommand;
import com.ibm.cics.cm.model.ReadyListCommand;
import com.ibm.cics.cm.model.ReadyListObject;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.ui.CMUIUtilities;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.cm.ui.chgpkg.ChangePackageLabelProvider;
import com.ibm.cics.cm.ui.chgpkg.ChangePackageTreeContentProvider;
import com.ibm.cics.cm.ui.chgpkg.ChangePackageTreeNode;
import com.ibm.cics.cm.ui.dialogs.ConfirmRemovalDialog;
import com.ibm.cics.cm.ui.editors.ChangePackageEditor;
import com.ibm.cics.cm.ui.editors.ChangePackageEditorInput;
import com.ibm.cics.cm.ui.editors.IChangePackageReadyListListener;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.eclipse.common.ui.DelegateLabelProvider;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ManagePackageCommandsPage
extends FormPage
implements IChangePackageReadyListListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ManagePackageCommandsPage.class);
    public static final String PAGE_ID = "managecommands";
    private FormEditor editor;
    private Combo schemeCombo;
    private TreeViewer commandsViewer;
    private FormText errorText;
    protected boolean typeColumnIsHidden = true;
    private ManagedCommandsComparator comparator;

    public ManagePackageCommandsPage(ChangePackageEditor changePackageEditor) {
        super(PAGE_ID, Messages.getString("ManagePackageCommandsPage.title"));
        this.initialize(changePackageEditor);
        this.editor = changePackageEditor;
    }

    protected void createFormContent(IManagedForm managedForm) {
        IManagedForm mForm = managedForm;
        FormToolkit toolkit = mForm.getToolkit();
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)new GridLayout(1, false));
        Section schemeSection = toolkit.createSection(body, 448);
        schemeSection.setText(Messages.getString("ManagePackageCommandsPage.section.migrationscheme"));
        schemeSection.setDescription(Messages.getString("ManagePackageCommandsPage.section.migrationscheme.description"));
        schemeSection.setLayoutData((Object)new GridData(4, -1, true, false));
        Composite schemeArea = toolkit.createComposite((Composite)schemeSection, 0);
        schemeArea.setLayout((Layout)new GridLayout(1, false));
        schemeSection.setClient((Control)schemeArea);
        schemeArea.setData((Object)new GridData(4, -1, true, false));
        this.schemeCombo = new Combo(schemeArea, 8);
        this.schemeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String item = ManagePackageCommandsPage.this.schemeCombo.getItem(ManagePackageCommandsPage.this.schemeCombo.getSelectionIndex());
                ((PackageCommandsTreeContentProvider)ManagePackageCommandsPage.this.commandsViewer.getContentProvider()).setScheme(item);
                ManagePackageCommandsPage.this.commandsViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Section commandSection = toolkit.createSection(body, 448);
        commandSection.setText(Messages.getString("ManagePackageCommandsPage.section.commands"));
        commandSection.setDescription(Messages.getString("ManagePackageCommandsPage.section.commands.description"));
        commandSection.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite commandsArea = toolkit.createComposite((Composite)commandSection, 0);
        commandsArea.setLayout((Layout)new GridLayout(2, false));
        commandsArea.setLayoutData((Object)new GridData(4, 4, true, true));
        commandSection.setClient((Control)commandsArea);
        this.errorText = toolkit.createFormText(commandsArea, true);
        this.errorText.setBackground(Display.getCurrent().getSystemColor(29));
        this.errorText.setForeground(Display.getCurrent().getSystemColor(28));
        this.errorText.setText("", false, false);
        this.errorText.setLayoutData((Object)new GridData(4, 16384, true, false, 2, 1));
        Tree resourceTree = toolkit.createTree(commandsArea, 2050);
        this.commandsViewer = new TreeViewer(resourceTree);
        resourceTree.setLayoutData((Object)new GridData(4, 4, true, true));
        final PackageCommandsTreeContentProvider content = new PackageCommandsTreeContentProvider();
        content.addListener(this);
        this.commandsViewer.setContentProvider((IContentProvider)content);
        this.commandsViewer.setLabelProvider((IBaseLabelProvider)new ChangePackageLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.commandsViewer);
        this.commandsViewer.getTree().setHeaderVisible(true);
        this.comparator = new ManagedCommandsComparator();
        this.commandsViewer.setComparator((ViewerComparator)this.comparator);
        this.createColumns(this.commandsViewer);
        this.packColumns(this.commandsViewer.getTree());
        Composite buttonArea = toolkit.createComposite(commandsArea, 0);
        buttonArea.setLayoutData((Object)new GridData(-1, 128, false, false));
        GridLayout grid = new GridLayout(1, true);
        buttonArea.setLayout((Layout)grid);
        final Button remButton = toolkit.createButton(buttonArea, Messages.getString("ManagePackageCommandsPage.button.remove"), 8);
        remButton.setLayoutData((Object)new GridData(4, -1, true, false));
        remButton.setEnabled(false);
        remButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HashMap objectsByConfig = new HashMap();
                ISelection selection = ManagePackageCommandsPage.this.commandsViewer.getSelection();
                ArrayList<ReadyListCommand> readyListCommands = new ArrayList<ReadyListCommand>();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structSel = (IStructuredSelection)selection;
                    List list = structSel.toList();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ReadyListCommand rlComm;
                        Object obj = iterator.next();
                        ReadyListCommand readyListCommand = rlComm = obj instanceof ReadyListCommand ? (ReadyListCommand)obj : null;
                        if (rlComm == null) continue;
                        readyListCommands.add(rlComm);
                    }
                }
                for (ReadyListCommand nextObj : readyListCommands) {
                    String configurationName = (String)nextObj.getAttributes().get("SEL_CCONFIG");
                    if (!StringUtil.hasContent((String)configurationName)) continue;
                    List<Map> listCmdAttribs = null;
                    if (!objectsByConfig.containsKey(configurationName)) {
                        listCmdAttribs = new ArrayList();
                        objectsByConfig.put(configurationName, listCmdAttribs);
                    } else {
                        listCmdAttribs = (List)objectsByConfig.get(configurationName);
                    }
                    listCmdAttribs.add(nextObj.getAttributes());
                }
                IEditorInput input = ManagePackageCommandsPage.this.editor.getEditorInput();
                if (input instanceof ChangePackageEditorInput) {
                    ChangePackage changePackage = ((ChangePackageEditorInput)input).getChangePackage();
                    String commandsString = ManagePackageCommandsPage.this.commandsToString(objectsByConfig);
                    ConfirmRemovalDialog dialog = new ConfirmRemovalDialog(ManagePackageCommandsPage.this.editor.getSite().getShell(), MessageFormat.format(Messages.getString("ManagePackageCommandsPage.message.confirmRemove"), commandsString, changePackage.getName()));
                    if (dialog.open() == 0) {
                        Status status;
                        boolean allOK = true;
                        for (String nextConf : objectsByConfig.keySet()) {
                            try {
                                changePackage.removeCommands((List)objectsByConfig.get(nextConf), nextConf);
                                ManagePackageCommandsPage.this.commandsViewer.refresh();
                            }
                            catch (CMServerRemoveException e1) {
                                debug.error("removeCommands", (Throwable)e1);
                                Status status2 = new Status(4, "com.ibm.cics.cm.ui", MessageFormat.format(Messages.getString("ManagePackageCommandsPage.remove.error"), e1.getReturnResponse()), (Throwable)e1);
                                UIActivator.getDefault().getLog().log((IStatus)status2);
                                ViewHelper.setDeferredStatusErrorMessage((String)status2.getMessage());
                                allOK = false;
                            }
                        }
                        if (allOK) {
                            status = new Status(1, "com.ibm.cics.cm.ui", MessageFormat.format(Messages.getString("ManagePackageCommandsPage.remove.success"), changePackage.getName()), null);
                            UIActivator.getDefault().getLog().log((IStatus)status);
                            ViewHelper.setDeferredStatusInformationMessage((String)status.getMessage());
                        } else {
                            status = new Status(4, "com.ibm.cics.cm.ui", MessageFormat.format(Messages.getString("ManagePackageCommandsPage.remove.errors"), changePackage.getName()), null);
                            UIActivator.getDefault().getLog().log((IStatus)status);
                            ViewHelper.setDeferredStatusErrorMessage((String)status.getMessage());
                        }
                    }
                }
            }
        });
        this.commandsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                remButton.setEnabled(false);
                Object[] objectArray = ((StructuredSelection)event.getSelection()).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selected = objectArray[n2];
                    if (!(selected instanceof ChangePackageTreeNode)) {
                        remButton.setEnabled(true);
                    }
                    ++n2;
                }
            }
        });
        final Button groupByTypeButton = toolkit.createButton(commandsArea, Messages.getString("ManagePackageCommandsPage.label.groupCommandsByType"), 32);
        groupByTypeButton.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        groupByTypeButton.setSelection(true);
        groupByTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean fresh;
                boolean last = content.isGroupByType();
                if (last != (fresh = groupByTypeButton.getSelection())) {
                    content.setGroupByType(fresh);
                    ManagePackageCommandsPage.this.typeColumnIsHidden = fresh;
                    ManagePackageCommandsPage.this.commandsViewer.refresh();
                    ManagePackageCommandsPage.this.packColumns(ManagePackageCommandsPage.this.commandsViewer.getTree());
                }
            }
        });
        this.commandsViewer.getTree().addTreeListener(new TreeListener(){

            public void treeExpanded(TreeEvent e) {
                ManagePackageCommandsPage.this.packColumns(ManagePackageCommandsPage.this.commandsViewer.getTree());
            }

            public void treeCollapsed(TreeEvent e) {
                ManagePackageCommandsPage.this.packColumns(ManagePackageCommandsPage.this.commandsViewer.getTree());
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)body, this.getHelpContextID());
        IEditorInput input = this.editor.getEditorInput();
        if (input instanceof ChangePackageEditorInput) {
            ChangePackage changePackage = ((ChangePackageEditorInput)input).getChangePackage();
            this.updateMigrationSchemeCombo(changePackage);
            this.commandsViewer.setInput((Object)changePackage);
        }
    }

    protected String getHelpContextID() {
        return "com.ibm.cics.cm.ui.editor_changepackage";
    }

    private void packColumns(final Tree tree) {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!tree.isDisposed()) {
                    TreeColumn[] treeColumnArray = tree.getColumns();
                    int n = treeColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeColumn next = treeColumnArray[n2];
                        if (next.getText().equals(Messages.getString("ManagePackageCommandsPage.column.resourcetype")) && ManagePackageCommandsPage.this.typeColumnIsHidden) {
                            next.setWidth(0);
                        } else {
                            next.pack();
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    private String commandsToString(Map<String, List<Map<String, String>>> objectsByConfig) {
        StringBuffer result = new StringBuffer();
        Set<String> keySet = objectsByConfig.keySet();
        result.append("\n");
        for (String nextConfig : keySet) {
            List<Map<String, String>> list = objectsByConfig.get(nextConfig);
            result.append("\n\tConfiguration " + nextConfig + "\n");
            for (Map<String, String> nextCmd : list) {
                String objectString = "";
                String commandString = nextCmd.get("SEL_COMMAND");
                PackageCommand.Type commandType = null;
                if (commandString.matches("A")) {
                    commandType = PackageCommand.Type.ADD;
                } else if (commandString.matches("R")) {
                    commandType = PackageCommand.Type.REMOVE;
                } else if (commandString.matches("D")) {
                    commandType = PackageCommand.Type.DELETE;
                }
                boolean toOrFrom = commandType.equals((Object)PackageCommand.Type.ADD);
                String sourceObject = "";
                String containerTarget = "";
                if (!nextCmd.get("SEL_OBJTYPE").equals("RESGROUP")) {
                    String type = nextCmd.get("SEL_OBJTYPE");
                    type = CMUIUtilities.getDescriptiveTypeName(type);
                    sourceObject = String.valueOf(type) + "(" + nextCmd.get("SEL_OBJNAME") + ")";
                    containerTarget = String.valueOf(CMUIUtilities.getDescriptiveTypeName("RESGROUP")) + "(" + nextCmd.get("SEL_TCONTAINER") + ")";
                } else {
                    sourceObject = String.valueOf(CMUIUtilities.getDescriptiveTypeName("RESGROUP")) + "(" + nextCmd.get("SEL_OBJNAME") + ")";
                    containerTarget = String.valueOf(CMUIUtilities.getDescriptiveTypeName("RESDESC")) + "(" + nextCmd.get("SEL_TCONTAINER") + ")";
                }
                String coreMessage = toOrFrom ? Messages.getString("ManagePackageCommandsPage.message.to") : Messages.getString("ManagePackageCommandsPage.message.from");
                objectString = MessageFormat.format(coreMessage, commandType, sourceObject, containerTarget);
                result.append("\t\t" + objectString + "\n");
            }
        }
        result.append("\n");
        return result.toString();
    }

    private TreeViewerColumn createColumn(TreeViewer viewer, String text, CellLabelProvider labelProvider, int width, boolean resizable, boolean moveable, int swtArgs, String attribute) {
        TreeViewerColumn column = new TreeViewerColumn(viewer, swtArgs);
        column.getColumn().setWidth(width);
        column.getColumn().setResizable(resizable);
        column.getColumn().setMoveable(moveable);
        column.getColumn().setText(text);
        column.setLabelProvider(labelProvider);
        column.getColumn().addSelectionListener((SelectionListener)this.getSortListener(column, attribute));
        return column;
    }

    private void createColumns(TreeViewer viewer) {
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        Object labelProvider = new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DelegateLabelProvider((ILabelProvider)new ChangePackageLabelProvider()), decorator, null);
        this.createColumn(viewer, Messages.getString("ManagePackageCommandsPage.column.commands"), (CellLabelProvider)labelProvider, 100, true, false, 0, "SEL_OBJNAME");
        labelProvider = new customColumnLabelProvider("SEL_OBJTYPE");
        this.createColumn(viewer, Messages.getString("ManagePackageCommandsPage.column.resourcetype"), (CellLabelProvider)labelProvider, 0, true, true, 0, "SEL_OBJTYPE");
        labelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ReadyListObject) {
                    ReadyListObject rlo = (ReadyListObject)element;
                    return rlo.getState().getShortState();
                }
                return "";
            }

            public String getToolTipText(Object element) {
                if (element instanceof ReadyListObject) {
                    ReadyListObject rlo = (ReadyListObject)element;
                    return rlo.getState().getDescription();
                }
                return "";
            }
        };
        this.createColumn(viewer, Messages.getString("ManagePackageCommandsPage.column.readystate"), (CellLabelProvider)labelProvider, 100, true, true, 0, "REASONCODE");
        labelProvider = new customColumnLabelProvider("SEL_GROUP");
        this.createColumn(viewer, Messages.getString("ManagePackageCommandsPage.column.group"), (CellLabelProvider)labelProvider, 100, true, true, 0, "SEL_GROUP");
        labelProvider = new customColumnLabelProvider("SEL_CCONFIG");
        this.createColumn(viewer, Messages.getString("ManagePackageCommandsPage.column.configuration"), (CellLabelProvider)labelProvider, 100, true, true, 0, "SEL_CCONFIG");
    }

    private SelectionAdapter getSortListener(final TreeViewerColumn column, final String columnID) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManagePackageCommandsPage.this.comparator.setColumn(columnID);
                boolean sortAscending = ManagePackageCommandsPage.this.comparator.isSortAscending();
                ManagePackageCommandsPage.this.commandsViewer.getTree().setSortColumn(column.getColumn());
                ManagePackageCommandsPage.this.commandsViewer.getTree().setSortDirection(sortAscending ? 1024 : 128);
                ManagePackageCommandsPage.this.commandsViewer.refresh();
            }
        };
        return listener;
    }

    private void updateMigrationSchemeCombo(ChangePackage changePackage) {
        IFilteredCollection migrationSchemes = ConfigurationManager.getCurrent().getMigrationSchemes();
        List schemes = migrationSchemes.getResults();
        TreeSet<String> names = new TreeSet<String>();
        names.add("");
        for (MigrationScheme next : schemes) {
            names.add(next.getName());
        }
        this.schemeCombo.setItems(names.toArray(new String[0]));
        MigrationScheme lastScheme = changePackage.getLastScheme();
        String lastSchemeName = null;
        if (lastScheme != null) {
            lastSchemeName = lastScheme.getName();
        }
        if (StringUtil.hasContent(lastSchemeName) && names.contains(lastSchemeName)) {
            this.schemeCombo.select(this.schemeCombo.indexOf(lastSchemeName));
        }
        PackageCommandsTreeContentProvider content = (PackageCommandsTreeContentProvider)this.commandsViewer.getContentProvider();
        content.setScheme(lastSchemeName);
    }

    @Override
    public void errorEvent(ChangePackage.ReadyListError rle) {
        if (!this.errorText.isDisposed()) {
            if (rle != null) {
                this.errorText.setText(rle.getDescription(), false, false);
            } else {
                this.errorText.setText("", false, false);
            }
            Composite parent = this.errorText.getParent();
            parent.layout(true);
        }
    }

    public void refresh() {
        if (this.commandsViewer != null) {
            this.commandsViewer.refresh();
        }
    }

    private class ManagedCommandsComparator
    extends ViewerComparator {
        private boolean ascending = true;
        private String columnIndex = "SEL_OBJNAME";

        private ManagedCommandsComparator() {
        }

        public boolean isSortAscending() {
            return this.ascending;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof ReadyListObject & e2 instanceof ReadyListObject) {
                ReadyListObject rlo1 = (ReadyListObject)e1;
                ReadyListObject rlo2 = (ReadyListObject)e2;
                int result = ((String)rlo1.getAttributes().get(this.columnIndex)).compareTo((String)rlo2.getAttributes().get(this.columnIndex));
                return this.ascending ? result : -result;
            }
            return 0;
        }

        public void setColumn(String columnID) {
            if (this.columnIndex.matches(columnID)) {
                this.ascending = !this.ascending;
            } else {
                this.columnIndex = columnID;
                this.ascending = true;
            }
        }
    }

    public class PackageCommandsTreeContentProvider
    implements ITreeContentProvider {
        private boolean groupByType = true;
        private String scheme;
        private List<IChangePackageReadyListListener> listeners = new ArrayList<IChangePackageReadyListListener>();

        public void addListener(IChangePackageReadyListListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(IChangePackageReadyListListener listener) {
            this.listeners.remove(listener);
        }

        public void dispose() {
            this.listeners = new ArrayList<IChangePackageReadyListListener>();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            Object[] results;
            if (inputElement instanceof ChangePackage) {
                ChangePackage cp = (ChangePackage)inputElement;
                IFilteredCollection commands = cp.getCommands(this.scheme);
                if (this.groupByType) {
                    results = ChangePackageTreeContentProvider.resourcesGroupedByType(commands);
                } else {
                    List resultList = commands.getResults();
                    results = resultList.toArray(new ICMObject[0]);
                }
                final ChangePackage.ReadyListError error = cp.getLastReadyListError();
                for (final IChangePackageReadyListListener next : this.listeners) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            next.errorEvent(error);
                        }
                    });
                }
            } else {
                results = new Object[]{};
            }
            return results;
        }

        public Object[] getChildren(Object parentElement) {
            Object data;
            if (parentElement instanceof ChangePackageTreeNode && (data = ((ChangePackageTreeNode)parentElement).getData()) != null) {
                IFilteredCollection items;
                if (data instanceof IFilteredCollection && (items = (IFilteredCollection)data).size() > 0) {
                    if (this.groupByType) {
                        return ChangePackageTreeContentProvider.resourcesGroupedByType(items);
                    }
                    return items.toArray();
                }
                if (data instanceof Object[]) {
                    return (Object[])data;
                }
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            Object data;
            if (element instanceof ChangePackageTreeNode && (data = ((ChangePackageTreeNode)element).getData()) != null) {
                if (data instanceof IFilteredCollection) {
                    return ((IFilteredCollection)data).size() > 0;
                }
                if (data instanceof Object[]) {
                    return ((Object[])data).length > 0;
                }
            }
            return false;
        }

        public boolean isGroupByType() {
            return this.groupByType;
        }

        public void setGroupByType(boolean groupByType) {
            this.groupByType = groupByType;
        }

        public String getScheme() {
            return this.scheme;
        }

        public void setScheme(String scheme) {
            this.scheme = scheme;
        }
    }

    private class customColumnLabelProvider
    extends ColumnLabelProvider {
        private String attribute;

        public customColumnLabelProvider(String attribute) {
            this.attribute = attribute;
        }

        public String getText(Object element) {
            ReadyListObject thing;
            String string;
            StringBuffer result = new StringBuffer();
            if (element instanceof ReadyListObject && (string = (String)(thing = (ReadyListObject)element).getAttributes().get(this.attribute)) != null) {
                if (this.attribute.equals("SEL_OBJTYPE")) {
                    string = CMUIUtilities.getDescriptiveTypeName(string);
                }
                result.append(string);
            }
            return result.toString();
        }
    }
}

