/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.editors;

import com.ibm.cics.cm.model.ChangePackage;
import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.chgpkg.ChangePackageLabelProvider;
import com.ibm.cics.cm.ui.editors.PackageResourcesHandler;
import com.ibm.cics.cm.ui.wizards.NewChangePackageWizard;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractAddToPackageHandler
implements IHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String PACKAGE_PARM_ID = "com.ibm.cics.cm.ui.chgpkg.parm.package";
    public static final String CONFIGURATION_PARM_ID = "com.ibm.cics.cm.ui.chgpkg.parm.configuration";
    protected static final Logger logger = Logger.getLogger(PackageResourcesHandler.class.getPackage().getName());
    private List<IHandlerListener> listeners = new ArrayList<IHandlerListener>();
    protected ChangePackage targetPackage = null;

    public void addHandlerListener(IHandlerListener handlerListener) {
        this.listeners.add(handlerListener);
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
        this.listeners.remove(handlerListener);
    }

    public void dispose() {
        this.listeners.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object execute(ExecutionEvent event) {
        String cPackage = event.getParameter(PACKAGE_PARM_ID);
        IFilteredCollection changePackages = ConfigurationManager.getCurrent().getChangePackages();
        if (cPackage == null) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new ChangePackageLabelProvider());
            dialog.setTitle(Messages.getString("ChangePackage.selectDialog.title"));
            dialog.setMessage(Messages.getString("ChangePackage.selectDialog.message"));
            dialog.setElements(changePackages.getResults().toArray());
            dialog.setMultipleSelection(false);
            dialog.open();
            if (dialog.getReturnCode() != 0) return null;
            Object firstResult = dialog.getFirstResult();
            if (firstResult == null || !(firstResult instanceof ChangePackage)) return null;
            this.targetPackage = (ChangePackage)firstResult;
            return null;
        } else if (cPackage.equals("")) {
            NewChangePackageWizard wizard = new NewChangePackageWizard();
            WizardDialog dialog = new WizardDialog(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell(), (IWizard)wizard);
            dialog.create();
            dialog.open();
            this.targetPackage = wizard.getNewChangePackage();
            return null;
        } else {
            changePackages.addRestrictionField("CPID", FilterExpression.Operator.EQ, cPackage);
            if (changePackages.size() != 1) {
                logger.logp(Level.WARNING, PackageResourcesHandler.class.getName(), "execute", "Package resources handler failed to resolve Change Package : " + cPackage, event);
                return null;
            }
            this.targetPackage = (ChangePackage)changePackages.get(0);
        }
        return null;
    }
}

