/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.ui.dialogs;

import com.ibm.cics.cm.model.TransformationVariable;
import com.ibm.cics.cm.ui.EnsureUppercaseListener;
import com.ibm.cics.cm.ui.Messages;
import com.ibm.cics.cm.ui.UIActivator;
import com.ibm.cics.eclipse.common.ui.TextInput;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class EditTransformationVariableDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Set<String> currentTransformationVariables;
    private TransformationVariable tv;
    private String name;
    private String value;
    private Button saveButton;
    private Text nameText;
    private MODE mode;
    private Text valueText;

    public EditTransformationVariableDialog(Shell parentShell, Set<String> currentTransformationVariables) {
        super(parentShell);
        this.currentTransformationVariables = currentTransformationVariables;
        this.mode = MODE.ADD;
    }

    public EditTransformationVariableDialog(Shell parentShell, Set<String> currentTransformationVariables, TransformationVariable tv) {
        super(parentShell);
        this.currentTransformationVariables = currentTransformationVariables;
        this.tv = tv;
        this.mode = MODE.EDIT;
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        Composite childArea = new Composite(c, 0);
        GridData data = new GridData(1808);
        childArea.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginBottom = 5;
        gridLayout.marginTop = 5;
        gridLayout.marginRight = 5;
        gridLayout.marginLeft = 5;
        childArea.setLayout((Layout)gridLayout);
        Label nameLabel = new Label(childArea, 0);
        nameLabel.setText(Messages.getString("ConfigurationsOverviewPage.columnHeading.transvar.name"));
        nameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        TextInput nameTextInput = new TextInput(childArea, nameLabel);
        nameTextInput.setNumberOfCharacters(16);
        nameTextInput.setLayoutData((Object)new GridData(4, 128, true, false));
        this.nameText = nameTextInput.text;
        this.nameText.setTextLimit(16);
        if (this.mode == MODE.EDIT && this.tv != null) {
            String name = this.tv.getName();
            if (name != null) {
                this.nameText.setText(name);
            } else {
                this.nameText.setText("");
            }
        } else {
            this.nameText.setText("");
        }
        this.name = this.nameText.getText();
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (EditTransformationVariableDialog.this.validateName() && EditTransformationVariableDialog.this.saveButton != null) {
                    EditTransformationVariableDialog.this.name = EditTransformationVariableDialog.this.nameText.getText().trim();
                    EditTransformationVariableDialog.this.saveButton.setEnabled(true);
                } else if (EditTransformationVariableDialog.this.saveButton != null) {
                    EditTransformationVariableDialog.this.saveButton.setEnabled(false);
                }
            }
        });
        this.nameText.addVerifyListener((VerifyListener)EnsureUppercaseListener.getSingleton());
        Label valueLabel = new Label(childArea, 0);
        valueLabel.setText(Messages.getString("ConfigurationsOverviewPage.columnHeading.transvar.value"));
        valueLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        TextInput valueTextInput = new TextInput(childArea, valueLabel);
        valueTextInput.setNumberOfCharacters(50);
        valueTextInput.setLayoutData((Object)new GridData(4, 128, true, false));
        this.valueText = valueTextInput.text;
        this.valueText.setTextLimit(50);
        if (this.mode == MODE.EDIT && this.tv != null) {
            String value = this.tv.getValue();
            if (value != null) {
                this.valueText.setText(value);
            } else {
                this.valueText.setText("");
            }
        } else {
            this.valueText.setText("");
        }
        this.value = this.valueText.getText();
        this.valueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String valueTextText = EditTransformationVariableDialog.this.valueText.getText();
                if (valueTextText != null && !valueTextText.trim().isEmpty() && !valueTextText.equals(Messages.getString("transvar.value.hint")) && EditTransformationVariableDialog.this.saveButton != null) {
                    EditTransformationVariableDialog.this.value = EditTransformationVariableDialog.this.valueText.getText().trim();
                }
            }
        });
        if (this.mode == MODE.ADD) {
            this.setTitle(Messages.getString("transvar.dialog.add.title"));
            this.getShell().setText(Messages.getString("transvar.dialog.add.title"));
        } else {
            this.setTitle(Messages.getString("transvar.dialog.edit.title"));
            this.getShell().setText(Messages.getString("transvar.dialog.edit.title"));
        }
        this.setTitleImage(UIActivator.getImage(UIActivator.IMGD_TRANS_VAR_WIZ));
        this.setMessage(Messages.getString("transvar.dialog.description"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), this.getContextHelpID());
        return c;
    }

    private String getContextHelpID() {
        return this.mode == MODE.ADD ? "com.ibm.cics.cm.ui.dialog_addtransvar" : "com.ibm.cics.cm.ui.dialog_edittransvar";
    }

    private boolean validateName() {
        String nameTextText = this.nameText.getText();
        if (nameTextText == null || nameTextText.trim().isEmpty() || nameTextText.equals(Messages.getString("transvar.name.hint"))) {
            this.setErrorMessage(Messages.getString("transvar.validate.empty"));
            return false;
        }
        if ((this.mode == MODE.ADD || !nameTextText.equals(this.tv.getName())) && this.currentTransformationVariables.contains(nameTextText.toUpperCase())) {
            this.setErrorMessage(Messages.getString("transvar.validate.already"));
            return false;
        }
        if (!nameTextText.matches("[A-Z0-9$@#_-]{1,16}")) {
            this.setErrorMessage(Messages.getString("transvar.validate.notvalidstring"));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.saveButton = this.createButton(parent, 0, this.mode == MODE.ADD ? Messages.getString("transvar.dialog.button.add") : Messages.getString("transvar.dialog.button.save"), true);
        if (this.mode == MODE.ADD) {
            this.saveButton.setEnabled(false);
        } else {
            this.saveButton.setEnabled(true);
        }
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public TransformationVariable getTransformationVariable() {
        return new TransformationVariable(this.name.toUpperCase(), this.value);
    }

    public static enum MODE {
        ADD,
        EDIT;

    }
}

